using namespace System;
using namespace System::Data;
using namespace System::Data::OleDb;

public ref class KuchenDB
{
private:
	OleDbCommand^ sqlAbfrage;

public:
	KuchenDB()
	{
	}
	KuchenDB(OleDbCommand^ sqlAbfrage)
		: sqlAbfrage(sqlAbfrage)
	{
	}

	~KuchenDB()
	{
	}

	int getSorte(int kuchenid)
	{
		sqlAbfrage->CommandText =
			"SELECT sorte FROM Kuchen " +
			"WHERE id = @kuchenid";

		sqlAbfrage->Parameters->Clear();

		OleDbParameter^ parameter = gcnew OleDbParameter();
		parameter->Value = kuchenid;
		parameter->OleDbType = OleDbType::Integer;
		parameter->ParameterName = "@kuchenid";
		sqlAbfrage->Parameters->Add(parameter);

		Object^ aktSQL = sqlAbfrage->ExecuteScalar();
		if (aktSQL != nullptr)
		{
			int tempid = Convert::ToInt32(aktSQL);
			return tempid;
		}

		return 0;
	}

	void update(Kuchen^ kuchen)
	{
		kuchen->letzterzugriff = DateTime::Now;

		//  Ich habe an dieser Stelle wirklich 2 Tage lang debuggt und gesucht,
		//  warum die Variante mit dem sqlAbfrage->Parameters->AddWithValue("@id", id);
		//  nicht funktioniert in C++ 
		//  Leider gibt es auch keine qualifizierte Fehlermeldung wie z.B. SQLSTATE in DB2
		//  Laut Indernett Foren liegt das Problem bei Access und/oder beim OLEDB :-(
		//
		//sqlAbfrage->Parameters->Clear();
		//sqlAbfrage->Parameters->AddWithValue("@id", kuchen->id);
		//sqlAbfrage->Parameters->AddWithValue("@anbieter", kuchen->anbieter);
		//sqlAbfrage->Parameters->AddWithValue("@sorte", kuchen->sorte);
		//if (kuchen->beschreibung->Length != 0)
		//{
		//	sqlAbfrage->Parameters->AddWithValue("@beschreibung", kuchen->beschreibung);
		//}
		//else
		//{
		//	sqlAbfrage->Parameters->AddWithValue("@beschreibung", DBNull::Value);
		//}
		//sqlAbfrage->Parameters->AddWithValue("@abgabedatum", kuchen->abgabedatum);
		//sqlAbfrage->Parameters->AddWithValue("@anzahl", kuchen->anzahl);
		//sqlAbfrage->Parameters->AddWithValue("@diabetikergeeignet", kuchen->diabetikergeeignet);
		//sqlAbfrage->Parameters->AddWithValue("@letzterzugriff", kuchen->letzterzugriff);
		//
		//sqlAbfrage->CommandText =
		//	"UPDATE Kuchen SET " +
		//	"anbieter = @anbieter, " +
		//	"sorte = @sorte, " +
		//	"beschreibung = @beschreibung, " +
		//	"abgabedatum = @abgabedatum, " +
		//	"anzahl = @anzahl, " +
		//	"diabetikergeeignet = @diabetikergeeignet, " +
		//	"letzterzugriff = @letzterzugriff " +
		//	"WHERE id = @id";
		//
		//int ergebnis1 = sqlAbfrage->ExecuteNonQuery();

		sqlAbfrage->CommandText =
			"UPDATE Kuchen SET" +
			"  anbieter = " + "'" + kuchen->anbieter + "'" +
			", sorte = " + kuchen->sorte.ToString() +
			", beschreibung = " + "'" + kuchen->beschreibung + "'" +
			", abgabedatum =  " + "cvdate('" + kuchen->abgabedatum->ToString() + "')" +
			", anzahl = " + kuchen->anzahl.ToString() +
			", diabetikergeeignet = " + kuchen->diabetikergeeignet.ToString() +
			", letzterzugriff =  " + "cvdate('" + kuchen->letzterzugriff->ToString() + "')" +
			" WHERE id= " + kuchen->id.ToString();

		//int ergebnis2 = sqlAbfrage->ExecuteNonQuery();
	
		sqlAbfrage->ExecuteNonQuery();
	}

	void get(Kuchen^ kuchen)
	{
		sqlAbfrage->CommandText =
			"SELECT anbieter, sorte, beschreibung, " +
			"abgabedatum, anzahl, diabetikergeeignet "+
			"FROM Kuchen WHERE id = @id";

		sqlAbfrage->Parameters->Clear();
		sqlAbfrage->Parameters->AddWithValue("@id", kuchen->id);

		OleDbDataReader^ aktCursor = sqlAbfrage->ExecuteReader();

		aktCursor->Read();

		kuchen->anbieter = aktCursor->GetString(0);
		kuchen->sorte = aktCursor->GetInt32(1);
		
		Object^ tempbeschreibung = aktCursor->GetValue(2);
		if (tempbeschreibung != DBNull::Value)
		{
			kuchen->beschreibung = aktCursor->GetString(2);
		}

		kuchen->abgabedatum = aktCursor->GetDateTime(3);

		kuchen->anzahl = aktCursor->GetInt32(4);
		kuchen->diabetikergeeignet = aktCursor->GetBoolean(5);
	
		aktCursor->Close();
	}

	DataTable^ getTable()
	{
		DataTable^ kuchenTabelle = gcnew DataTable();
		
		kuchenTabelle->Columns->Add("ID", Type::GetType("System.Int32"));
		kuchenTabelle->Columns->Add("Anbieter", Type::GetType("System.String"));
		kuchenTabelle->Columns->Add("Beschreibung", Type::GetType("System.String"));
		kuchenTabelle->Columns->Add("Diabetikergeeignet", Type::GetType("System.Boolean"));
		kuchenTabelle->Columns->Add("LetzterZugriff", Type::GetType("System.DateTime"));

		sqlAbfrage->CommandText =
			"SELECT ID, Anbieter, Beschreibung, Diabetikergeeignet, Letzterzugriff FROM Kuchen";

		OleDbDataReader^ aktCursor = sqlAbfrage->ExecuteReader();

		while (aktCursor->Read())
		{
			DataRow^ zeile = kuchenTabelle->NewRow();
	
			zeile["ID"] = aktCursor->GetInt32(0);
			zeile["Anbieter"] = aktCursor->GetString(1);
			zeile["Beschreibung"] = aktCursor->GetString(2);
			zeile["Diabetikergeeignet"] = aktCursor->GetBoolean(3);
			zeile["LetzterZugriff"] = aktCursor->GetDateTime(4);

			kuchenTabelle->Rows->Add(zeile);
		}

		aktCursor->Close();

		return kuchenTabelle;
	}

private:
};