using namespace System;
using namespace System::Data;
using namespace System::Data::OleDb;

public ref class GaesteDB
{
private:
	OleDbCommand^ sqlAbfrage;

public:
	GaesteDB(OleDbCommand^ sqlAbfrage)
		: sqlAbfrage(sqlAbfrage)
	{
	}

	GaesteDB()
	{
	}
	
	~GaesteDB()
	{
	}
	
	//Liste wird nach Insert/Delete gelscht
	//Liste wird am Anfang sowie bei Bedarf neu aufgebaut
	List<String^>^ gaesteliste = gcnew List<String^>;
	bool isChanged = true;
	
	Dictionary<int, int>^ dictlistIndex2Number = gcnew Dictionary<int, int>;
	Dictionary<int, int>^ dictlistNumber2Index = gcnew Dictionary<int, int>;

	void erzwingeListenaufbau()
	{
		isChanged = true;
		gaesteliste->Clear();
		dictlistIndex2Number->Clear();
		dictlistNumber2Index->Clear();
	}

	List<String^>^ getList()
	{
		isChanged = false;
		int counter = 0;
		
		if (gaesteliste->Count == 0)
		{
			sqlAbfrage->CommandText = "SELECT ID, kurzgast, einrichtung " +
				"FROM GaesteView ORDER BY 1 ASC";

			OleDbDataReader^ aktCursor = sqlAbfrage->ExecuteReader();

			while (aktCursor->Read())
			{
				String^ tempgast = aktCursor->GetString(1);
				String^ tempeinrichtung = aktCursor->GetString(2);
				int tempID = aktCursor->GetInt32(0);

				isChanged = false;

				if (tempID > 0)
				{
					gaesteliste->Add(tempgast + ", " + tempeinrichtung);
				}
				else
				{
					gaesteliste->Add(tempgast);
				}

				dictlistIndex2Number->Add(tempID, counter);
				dictlistNumber2Index->Add(counter, tempID);
				counter++;
			}

			aktCursor->Close();
		}
	
		return gaesteliste;
	}

	int getNumber2Index(int number)
	{
		if (dictlistNumber2Index->ContainsKey(number))
		{
			int tempindex = dictlistNumber2Index[number];
			return tempindex;
		}
		else
		{
			return 0;
		}
	}

	int getIndex2Number(int id)
	{
		if (dictlistIndex2Number->ContainsKey(id))
		{
			int tempnumber = dictlistIndex2Number[id];
			return tempnumber;
		}
		else
		{
			return 0;
		}
	}

	void update(Gast^ aktgast)
	{
		aktgast->Letzterzugriff = DateTime::Now;
				
		sqlAbfrage->CommandText =
			"UPDATE Gaeste SET " +
			"gastname = " + "'" + aktgast->Gastname + "'" + ", " +
			"vorname = " + "'" + aktgast->Vorname + "'" + ", " +
			"kurzgast = " + "'" + aktgast->Kurzname + "'" + ", " +
			"einrichtung = " + aktgast->Einrichtung.ToString() + ", " +
			"telefon = " + "'" + aktgast->Telefon + "'" + ", " +
			"letzterzugriff =  " + "cvdate('" + aktgast->Letzterzugriff->ToString() + "') " +
			"WHERE id = " + aktgast->Id.ToString() + ";";

		sqlAbfrage->ExecuteNonQuery();
	}

	int insert(Gast^ neugast)
	{
		neugast->Letzterzugriff = DateTime::Now;

		sqlAbfrage->CommandText =
			"INSERT INTO Gaeste " +
			"(gastname, vorname, kurzgast, einrichtung, telefon, letzterzugriff) " +
			"VALUES (" +
			"'" + neugast->Gastname + "'" + ", " +
			"'" + neugast->Vorname + "'" + ", " +
			"'" + neugast->Kurzname + "'" + ", " +
			neugast->Einrichtung.ToString() + ", " +
			"'" + neugast->Telefon + "'" + ", " +
			"cvdate('" + neugast->Letzterzugriff->ToString() + "')" +
			");";

		sqlAbfrage->ExecuteNonQuery();

		//Lsche die gaesteliste und die dictionary, sie werden gleich wieder aufgebaut :-)
		erzwingeListenaufbau();

		int neueID = 0;

		sqlAbfrage->CommandText =
			"SELECT id FROM Gaeste " +
			"WHERE kurzgast = " + "'" + neugast->Kurzname->ToString() + "'" +
			" AND  letzterzugriff = " + "cvdate('" + neugast->Letzterzugriff->ToString() + "');";

		Object^ aktSQL = sqlAbfrage->ExecuteScalar();
		if (aktSQL != nullptr)
		{
			neueID = Convert::ToInt32(aktSQL);
		}

		return neueID;
	}

	void del(int aktid)
	{
		sqlAbfrage->CommandText =
			"DELETE " +
			"FROM Gaeste " +
			"WHERE id = @id;";

		sqlAbfrage->Parameters->Clear();
		sqlAbfrage->Parameters->AddWithValue("@id", aktid);

		sqlAbfrage->ExecuteNonQuery();

		//Lsche die gaesteliste und die dictionary, sie werden gleich wieder aufgebaut :-)
		erzwingeListenaufbau();
	}

	Gast^ get(int aktid)
	{
		Gast^ aktGast = gcnew Gast();

		aktGast->Id = aktid;

		sqlAbfrage->CommandText =
			"SELECT gastname, vorname, kurzgast, einrichtung, telefon " +
			"FROM Gaeste " +
			"WHERE id = @id;";

		sqlAbfrage->Parameters->Clear();
		sqlAbfrage->Parameters->AddWithValue("@id", aktid);

		OleDbDataReader^ aktCursor = sqlAbfrage->ExecuteReader();

		aktCursor->Read();

		aktGast->Gastname = aktCursor->GetString(0);
		aktGast->Kurzname = aktCursor->GetString(2);
		aktGast->Einrichtung = aktCursor->GetInt32(3);
	
		Object^ tempvorname = aktCursor->GetValue(1);
		if (tempvorname != DBNull::Value)
		{
			aktGast->Vorname = aktCursor->GetString(1);
		}
		Object^ temptelefon = aktCursor->GetValue(4);
		if (temptelefon != DBNull::Value)
		{
			aktGast->Telefon = aktCursor->GetString(4);
		}

		aktCursor->Close();

		return aktGast;
	}

	DataTable^ getTable()
	{
		DataTable^ gaesteTabelle = gcnew DataTable();

		gaesteTabelle->Columns->Add("ID", Type::GetType("System.Int32"));
		gaesteTabelle->Columns->Add("Kurzname", Type::GetType("System.String"));
		gaesteTabelle->Columns->Add("Einrichtung", Type::GetType("System.String"));
		gaesteTabelle->Columns->Add("LetzterZugriff", Type::GetType("System.DateTime"));

		sqlAbfrage->CommandText =
			"SELECT ID, KurzGast, Einrichtung, Letzterzugriff " +
			"FROM GaesteView WHERE id > 0;";

		OleDbDataReader^ aktCursor = sqlAbfrage->ExecuteReader();

		while (aktCursor->Read())
		{
			DataRow^ zeile = gaesteTabelle->NewRow();

			zeile["ID"] = aktCursor->GetInt32(0);
			zeile["Kurzname"] = aktCursor->GetString(1);
			zeile["Einrichtung"] = aktCursor->GetString(2);
			zeile["LetzterZugriff"] = aktCursor->GetDateTime(3);

			gaesteTabelle->Rows->Add(zeile);
		}

		aktCursor->Close();

		return gaesteTabelle;
	}

	DataTable^ getTable(String^ suchmaske)
	{
		DataTable^ gaesteTabelle = gcnew DataTable();
		String^ suchstring;

		gaesteTabelle->Columns->Add("ID", Type::GetType("System.Int32"));
		gaesteTabelle->Columns->Add("Kurzname", Type::GetType("System.String"));
		gaesteTabelle->Columns->Add("Einrichtung", Type::GetType("System.String"));
		gaesteTabelle->Columns->Add("LetzterZugriff", Type::GetType("System.DateTime"));

		sqlAbfrage->CommandText =
			"SELECT ID, KurzGast, Einrichtung, Letzterzugriff, Gastname, Vorname, Telefon " +
			"FROM GaesteView WHERE id > 0;";

		OleDbDataReader^ aktCursor = sqlAbfrage->ExecuteReader();

		while (aktCursor->Read())
		{
			Object^ temp1 = aktCursor->GetValue(5);
			String^ tempvorname = "";
			if (temp1 != DBNull::Value)
			{
				tempvorname = aktCursor->GetString(5);
			}
			Object^ temp2 = aktCursor->GetValue(6);
			String^ temptelefon = "";
			if (temp2 != DBNull::Value)
			{
				temptelefon = aktCursor->GetString(6);
			}
			suchstring = aktCursor->GetString(1) +
				aktCursor->GetString(2) +
				aktCursor->GetString(4) +
				tempvorname +
				temptelefon;
			
			// wenn der Suchstring irgendwie vorkommt?
			// das schliet einen leeren Suchstring implizit mit ein
			if (suchstring->Contains(suchmaske))
			{
				DataRow^ zeile = gaesteTabelle->NewRow();

				zeile["ID"] = aktCursor->GetInt32(0);
				zeile["Kurzname"] = aktCursor->GetString(1);
				zeile["Einrichtung"] = aktCursor->GetString(2);
				zeile["LetzterZugriff"] = aktCursor->GetDateTime(3);

				gaesteTabelle->Rows->Add(zeile);
			}
		}

		aktCursor->Close();

		return gaesteTabelle;
	}
};