#pragma once
#ifndef _IKUCHENBASAR
#include "IKuchenBasar.h"
#endif

namespace KuchenBasar {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;

	public ref class GaesteWerte : public System::Windows::Forms::Form
	{
	private:
		IKuchenBasar^ kuchenBasar;
		DBAssistent^ dbAssistent;
    	Gast^ aktGast;

	public:
		GaesteWerte(IKuchenBasar^ kuchenBasarForm, DBAssistent^ dbAssistentForm)
		{
			InitializeComponent();

			kuchenBasar = kuchenBasarForm;
			dbAssistent = dbAssistentForm;

			if (kuchenBasar->AktGaesteID < 0)
			{
				aktGast = gcnew Gast(-1, "", "", "neuer Gast", 0, "");
			}
			else
			{
				aktGast = dbAssistent->getGaeste(kuchenBasar->AktGaesteID);
			}

			textBoxName->Text = aktGast->Gastname;
			textBoxVorname->Text = aktGast->Vorname;
			textBoxKurzname->Text = aktGast->Kurzname;
			textBoxTelefon->Text = aktGast->Telefon;

			comboBoxEinrichtung->DataSource = dbAssistent->getEinrichtungenList();
			comboBoxEinrichtung->SelectedIndex = aktGast->Einrichtung;
		}

		GaesteWerte()
		{
		}

	protected:
		/// <summary>
		/// Verwendete Ressourcen bereinigen.
		/// </summary>
		~GaesteWerte()
		{
			if (components)
			{
				delete components;
			}
		}

	private: System::Windows::Forms::Button^  buttonSpeichern;
	private: System::Windows::Forms::Button^  buttonAbbruch;

	private: System::Windows::Forms::TextBox^  textBoxName;
	private: System::Windows::Forms::TextBox^  textBoxVorname;
	private: System::Windows::Forms::TextBox^  textBoxKurzname;
	private: System::Windows::Forms::TextBox^  textBoxTelefon;
	private: System::Windows::Forms::ComboBox^  comboBoxEinrichtung;
			 
	private: System::Windows::Forms::Label^  labelName;
	private: System::Windows::Forms::Label^  labelVorname;
	private: System::Windows::Forms::Label^  labelKurzname;

	private: System::Windows::Forms::Label^  labelEinrichtung;

	private: System::Windows::Forms::Label^  labelTelefon;

	private:
		/// <summary>
		/// Erforderliche Designervariable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung.
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		void InitializeComponent(void)
		{
			this->buttonSpeichern = (gcnew System::Windows::Forms::Button());
			this->buttonAbbruch = (gcnew System::Windows::Forms::Button());
			this->labelTelefon = (gcnew System::Windows::Forms::Label());
			this->textBoxName = (gcnew System::Windows::Forms::TextBox());
			this->textBoxVorname = (gcnew System::Windows::Forms::TextBox());
			this->textBoxKurzname = (gcnew System::Windows::Forms::TextBox());
			this->labelName = (gcnew System::Windows::Forms::Label());
			this->labelVorname = (gcnew System::Windows::Forms::Label());
			this->labelKurzname = (gcnew System::Windows::Forms::Label());
			this->labelEinrichtung = (gcnew System::Windows::Forms::Label());
			this->textBoxTelefon = (gcnew System::Windows::Forms::TextBox());
			this->comboBoxEinrichtung = (gcnew System::Windows::Forms::ComboBox());
			this->SuspendLayout();
			// 
			// buttonSpeichern
			// 
			this->buttonSpeichern->Location = System::Drawing::Point(540, 59);
			this->buttonSpeichern->Name = L"buttonSpeichern";
			this->buttonSpeichern->Size = System::Drawing::Size(165, 43);
			this->buttonSpeichern->TabIndex = 0;
			this->buttonSpeichern->Text = L"Speichern";
			this->buttonSpeichern->UseVisualStyleBackColor = true;
			this->buttonSpeichern->Click += gcnew System::EventHandler(this, &GaesteWerte::buttonSpeichern_Click);
			// 
			// buttonAbbruch
			// 
			this->buttonAbbruch->Location = System::Drawing::Point(540, 264);
			this->buttonAbbruch->Name = L"buttonAbbruch";
			this->buttonAbbruch->Size = System::Drawing::Size(165, 40);
			this->buttonAbbruch->TabIndex = 1;
			this->buttonAbbruch->Text = L"Abbruch";
			this->buttonAbbruch->UseVisualStyleBackColor = true;
			this->buttonAbbruch->Click += gcnew System::EventHandler(this, &GaesteWerte::buttonAbbruch_Click);
			// 
			// labelTelefon
			// 
			this->labelTelefon->AutoSize = true;
			this->labelTelefon->Location = System::Drawing::Point(62, 283);
			this->labelTelefon->Name = L"labelTelefon";
			this->labelTelefon->Size = System::Drawing::Size(43, 13);
			this->labelTelefon->TabIndex = 5;
			this->labelTelefon->Text = L"Telefon";
			// 
			// textBoxName
			// 
			this->textBoxName->Location = System::Drawing::Point(164, 31);
			this->textBoxName->Name = L"textBoxName";
			this->textBoxName->Size = System::Drawing::Size(203, 20);
			this->textBoxName->TabIndex = 6;
			// 
			// textBoxVorname
			// 
			this->textBoxVorname->Location = System::Drawing::Point(165, 100);
			this->textBoxVorname->Name = L"textBoxVorname";
			this->textBoxVorname->Size = System::Drawing::Size(202, 20);
			this->textBoxVorname->TabIndex = 7;
			// 
			// textBoxKurzname
			// 
			this->textBoxKurzname->Location = System::Drawing::Point(164, 160);
			this->textBoxKurzname->Name = L"textBoxKurzname";
			this->textBoxKurzname->Size = System::Drawing::Size(201, 20);
			this->textBoxKurzname->TabIndex = 8;
			// 
			// labelName
			// 
			this->labelName->AutoSize = true;
			this->labelName->Location = System::Drawing::Point(70, 34);
			this->labelName->Name = L"labelName";
			this->labelName->Size = System::Drawing::Size(35, 13);
			this->labelName->TabIndex = 10;
			this->labelName->Text = L"Name";
			// 
			// labelVorname
			// 
			this->labelVorname->AutoSize = true;
			this->labelVorname->Location = System::Drawing::Point(56, 103);
			this->labelVorname->Name = L"labelVorname";
			this->labelVorname->Size = System::Drawing::Size(49, 13);
			this->labelVorname->TabIndex = 11;
			this->labelVorname->Text = L"Vorname";
			// 
			// labelKurzname
			// 
			this->labelKurzname->AutoSize = true;
			this->labelKurzname->Location = System::Drawing::Point(51, 167);
			this->labelKurzname->Name = L"labelKurzname";
			this->labelKurzname->Size = System::Drawing::Size(54, 13);
			this->labelKurzname->TabIndex = 12;
			this->labelKurzname->Text = L"Kurzname";
			// 
			// labelEinrichtung
			// 
			this->labelEinrichtung->AutoSize = true;
			this->labelEinrichtung->Location = System::Drawing::Point(45, 226);
			this->labelEinrichtung->Name = L"labelEinrichtung";
			this->labelEinrichtung->Size = System::Drawing::Size(60, 13);
			this->labelEinrichtung->TabIndex = 13;
			this->labelEinrichtung->Text = L"Einrichtung";
			// 
			// textBoxTelefon
			// 
			this->textBoxTelefon->Location = System::Drawing::Point(166, 280);
			this->textBoxTelefon->Name = L"textBoxTelefon";
			this->textBoxTelefon->Size = System::Drawing::Size(201, 20);
			this->textBoxTelefon->TabIndex = 14;
			// 
			// comboBoxEinrichtung
			// 
			this->comboBoxEinrichtung->FormattingEnabled = true;
			this->comboBoxEinrichtung->Location = System::Drawing::Point(164, 218);
			this->comboBoxEinrichtung->Name = L"comboBoxEinrichtung";
			this->comboBoxEinrichtung->Size = System::Drawing::Size(203, 21);
			this->comboBoxEinrichtung->TabIndex = 15;
			// 
			// GaesteWerte
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->BackColor = System::Drawing::SystemColors::Window;
			this->ClientSize = System::Drawing::Size(806, 357);
			this->Controls->Add(this->comboBoxEinrichtung);
			this->Controls->Add(this->textBoxTelefon);
			this->Controls->Add(this->labelEinrichtung);
			this->Controls->Add(this->labelKurzname);
			this->Controls->Add(this->labelVorname);
			this->Controls->Add(this->labelName);
			this->Controls->Add(this->textBoxKurzname);
			this->Controls->Add(this->textBoxVorname);
			this->Controls->Add(this->textBoxName);
			this->Controls->Add(this->labelTelefon);
			this->Controls->Add(this->buttonAbbruch);
			this->Controls->Add(this->buttonSpeichern);
			this->Name = L"GaesteWerte";
			this->Text = L"GsteWerte";
			this->ResumeLayout(false);
			this->PerformLayout();

		}
#pragma endregion
	private:
		bool komplexePlausis()
		{
			if (textBoxName->Text->Length == 0)
			{
				MessageBox::Show("Name mu gefllt werden");
				return false;
			}

			if (textBoxKurzname->Text->Length == 0)
			{
				MessageBox::Show("Kurzname mu gefllt werden");
				return false;
			}

			if (comboBoxEinrichtung->SelectedIndex == 0)
			{
				MessageBox::Show("keine gltige Einrichtung");
				return false;
			}

			return true;
		}

		Void buttonAbbruch_Click(Object^  sender, EventArgs^  e)
		{
			this->Close();
		}

		Void buttonSpeichern_Click(Object^  sender, EventArgs^  e)
		{
			if (!komplexePlausis())
			{
				//MessageBox::Show("mind. ein Feld war nicht korrekt gefllt");
			}
			else
			{
				aktGast->Gastname = textBoxName->Text;
				aktGast->Vorname = textBoxVorname->Text;
				aktGast->Kurzname = textBoxKurzname->Text;
				aktGast->Telefon = textBoxTelefon->Text;

				aktGast->Einrichtung = comboBoxEinrichtung->SelectedIndex;

				if (kuchenBasar->AktGaesteID < 0)
				{
					int neuGaesteID = dbAssistent->insertGaeste(aktGast);
					kuchenBasar->AktGaesteID = neuGaesteID;
				}
				else
				{
					aktGast->Id = kuchenBasar->AktGaesteID;
					dbAssistent->updateGaeste(aktGast);
				}

				this->Close();
			}
		}
	};
}