using namespace System;
using namespace System::Data;
using namespace System::Data::SqlClient;

public ref class KuchenDB
{
private:
	SqlCommand^ sqlAbfrage;

public:
	KuchenDB()
	{
	}
	KuchenDB(SqlCommand^ sqlAbfrage)
		: sqlAbfrage(sqlAbfrage)
	{
	}

	~KuchenDB()
	{
	}

	int getSorte(int kuchenid)
	{
		sqlAbfrage->CommandText =
			"SELECT sorte FROM Kuchen " +
			"WHERE id = @kuchenid";

		sqlAbfrage->Parameters->Clear();

		SqlParameter^ parameter = gcnew SqlParameter();
		parameter->Value = kuchenid;
		parameter->SqlDbType = SqlDbType::Int;
		parameter->ParameterName = "@kuchenid";
		sqlAbfrage->Parameters->Add(parameter);

		Object^ aktSQL = sqlAbfrage->ExecuteScalar();
		if (aktSQL != nullptr)
		{
			int tempid = Convert::ToInt32(aktSQL);
			return tempid;
		}

		return 0;
	}

	void update(Kuchen^ kuchen)
	{
		kuchen->letzterzugriff = DateTime::Now;

		sqlAbfrage->CommandText =
			"UPDATE Kuchen SET" +
			"  anbieter = " + "'" + kuchen->anbieter + "'" +
			", sorte = " + kuchen->sorte.ToString() +
			", beschreibung = " + "'" + kuchen->beschreibung + "'" +
			", abgabedatum =  " + "cast('" + kuchen->abgabedatum->ToString() + "' as datetime)" +
			", anzahl = " + kuchen->anzahl.ToString() +
			", diabetikergeeignet = " + "'" + kuchen->diabetikergeeignet.ToString() + "'" +
			", letzterzugriff =  " + "cast('" + kuchen->letzterzugriff->ToString() + "' as datetime)" +
			" WHERE id= " + kuchen->id.ToString();

		int ergebnis2 = sqlAbfrage->ExecuteNonQuery();
	
	}

	void get(Kuchen^ kuchen)
	{
		sqlAbfrage->CommandText =
			"SELECT anbieter, sorte, beschreibung, " +
			"abgabedatum, anzahl, diabetikergeeignet "+
			"FROM Kuchen WHERE id = @id";

		sqlAbfrage->Parameters->Clear();
		sqlAbfrage->Parameters->AddWithValue("@id", kuchen->id);

		SqlDataReader^ aktCursor = sqlAbfrage->ExecuteReader();

		aktCursor->Read();

		kuchen->anbieter = aktCursor->GetString(0);
		kuchen->sorte = aktCursor->GetInt32(1);
		
		Object^ tempbeschreibung = aktCursor->GetValue(2);
		if (tempbeschreibung != DBNull::Value)
		{
			kuchen->beschreibung = aktCursor->GetString(2);
		}

		kuchen->abgabedatum = aktCursor->GetDateTime(3);

		kuchen->anzahl = aktCursor->GetInt32(4);
		kuchen->diabetikergeeignet = aktCursor->GetBoolean(5);
	
		aktCursor->Close();
	}

	DataTable^ getTable()
	{
		DataTable^ kuchenTabelle = gcnew DataTable();
		
		kuchenTabelle->Columns->Add("ID", Type::GetType("System.Int32"));
		kuchenTabelle->Columns->Add("Anbieter", Type::GetType("System.String"));
		kuchenTabelle->Columns->Add("Beschreibung", Type::GetType("System.String"));
		kuchenTabelle->Columns->Add("Diabetikergeeignet", Type::GetType("System.Boolean"));
		kuchenTabelle->Columns->Add("LetzterZugriff", Type::GetType("System.DateTime"));

		sqlAbfrage->CommandText =
			"SELECT ID, Anbieter, Beschreibung, Diabetikergeeignet, Letzterzugriff FROM Kuchen";

		SqlDataReader^ aktCursor = sqlAbfrage->ExecuteReader();

		while (aktCursor->Read())
		{
			DataRow^ zeile = kuchenTabelle->NewRow();
	
			zeile["ID"] = aktCursor->GetInt32(0);
			zeile["Anbieter"] = aktCursor->GetString(1);
			zeile["Beschreibung"] = aktCursor->GetString(2);
			zeile["Diabetikergeeignet"] = aktCursor->GetBoolean(3);
			zeile["LetzterZugriff"] = aktCursor->GetDateTime(4);

			kuchenTabelle->Rows->Add(zeile);
		}

		aktCursor->Close();

		return kuchenTabelle;
	}

private:
};