using namespace System;
using namespace System::Windows::Forms;

public ref class Gast
{
private:
	int id;
	String^ name;
	String^ vorname;
	String^ firma;
	String^ mobile;
	String^ email;
	DateTime^ timestamp;

public:
	property int Id
	{
		int get()
		{
			return this->id;
		}

		void set(int id)
		{
			this->id = id;
		}
	}

	property String^ Name
	{
		String^ get()
		{
			return this->name;
		}

		void set(String^ name)
		{
			this->name = name;
		}
	}

	property String^ Vorname
	{
		String^ get()
		{
			return this->vorname;
		}

		void set(String^ vorname)
		{
			this->vorname = vorname;
		}
	}

	property String^ Firma
	{
		String^ get()
		{
			return this->firma;
		}

		void set(String^ firma)
		{
			this->firma = firma;
		}
	}

	property String^ Mobile
	{
		String^ get()
		{
			return this->mobile;
		}

		void set(String^ mobile)
		{
			this->mobile = mobile;
		}
	}

	property String^ Email
	{
		String^ get()
		{
			return this->email;
		}

		void set(String^ email)
		{
			this->email = email;
		}
	}

	property DateTime^ Timestamp
	{
		DateTime^ get()
		{
			return this->timestamp;
		}
	}

	Gast(int id, String^ name, String^ vorname, String^ firma, String^ mobile, String^ email)
		//Aufruf ohne die Properties => C++
		//:id(id), name(name), vorname(vorname), firma(firma), mobile(mobile), email(email)
	{
		//Zuweisung ber die Properties
		Id = id;
		Name = name;
		Vorname = vorname;
		Firma = firma;
		Mobile = mobile;
		Email = email;
		//timestamp kann nur gelesen werden!!!
		this->timestamp = DateTime::Now;
	}

	Gast(String^ gaesteInformation)
	{
		array<String^>^ kompletteListe = gaesteInformation->Split(';');

		if (!Int32::TryParse(kompletteListe[0], id))
		{
			id = 0;
		}

		Name = kompletteListe[1];
		Vorname = kompletteListe[2];
		Firma = kompletteListe[3];
		Mobile = kompletteListe[4];
		Email = kompletteListe[5];

		//beim Laden sollte der Timestamp absichtlich nicht erneuert werden!
		timestamp = DateTime::Parse(kompletteListe[6]);
	}

	Gast()
	{
		this->timestamp = DateTime::Now;
	}

	~Gast()
	{

	}

	void change(Gast^ aktGast)
	{
		this->Name = aktGast->Name;
		this->Vorname = aktGast->Vorname;
		this->Firma = aktGast->Firma;
		this->Mobile = aktGast->Mobile;
		this->Email = aktGast->Email;
		this->timestamp = DateTime::Now;
	}

	String^ gesamt()
	{
		String^ temp;
		temp = Id.ToString() + ";" + Name + ";" + Vorname + ";" + Firma + ";" + Mobile + ";" + Email + ";" + Timestamp->ToString();

		return temp;
	}

};
