using namespace System;
using namespace System::Collections;
using namespace System::Collections::Generic;
using namespace System::IO;
using namespace System::Text;
using namespace System::Data;
#include "Kuchen.h"

public ref class KuchenM
{
private:
	List<Kuchen^>^ kuchenListe;
	String^ eingabeDateiname = "kuchen.csv";
	String^ ausgabeDateiname = "kuchen.csv";

	int getAutoID()
	{
		int id = 1;
		for each (Kuchen^ tempkuchen in kuchenListe)
		{
			if (tempkuchen->Id >= id)
			{
				id = tempkuchen->Id + 1;
			}
		}
		return id;
	}

public:
	KuchenM()
	{
		kuchenListe = gcnew List<Kuchen^>;

		lesen();
	}

	~KuchenM()
	{
		speichern();
	}

	void setInfos(Kuchen^ aktKuchen)
	{
		for each (Kuchen^ tempkuchen in kuchenListe)
		{
			if (tempkuchen->Id == aktKuchen->Id)
			{
				tempkuchen->change(aktKuchen);
				break;
			}
		}
	}

	Kuchen^ getInfos(int aktid)
	{
		for each (Kuchen^ tempkuchen in kuchenListe)
		{
			if (tempkuchen->Id == aktid)
			{
				return tempkuchen;
			}
		}
		return nullptr;
	}

	DataTable^ getTabelle()
	{
		DataTable^ kuchenTabelle = gcnew DataTable();

		kuchenTabelle->Columns->Add("ID", Type::GetType("System.Int32"));
		kuchenTabelle->Columns->Add("Anbieter", Type::GetType("System.String"));
		kuchenTabelle->Columns->Add("Sorte", Type::GetType("System.String"));
		kuchenTabelle->Columns->Add("Aktuell", Type::GetType("System.DateTime"));

		DataRow^ tabellenZeile;

		for each (Kuchen^ tempkuchen in kuchenListe)
		{
			tabellenZeile = kuchenTabelle->NewRow();
			tabellenZeile["ID"] = tempkuchen->Id;
			tabellenZeile["Anbieter"] = tempkuchen->Anbieter;
			tabellenZeile["Sorte"] = tempkuchen->Sorte;
			tabellenZeile["Aktuell"] = tempkuchen->Timestamp;

			kuchenTabelle->Rows->Add(tabellenZeile);
		}

		return kuchenTabelle;
	}

	DataTable^ getTabelle(String^ suchmaske)
	{
		DataTable^ kuchenTabelle = gcnew DataTable();

		kuchenTabelle->Columns->Add("ID", Type::GetType("System.Int32"));
		kuchenTabelle->Columns->Add("Anbieter", Type::GetType("System.String"));
		kuchenTabelle->Columns->Add("Sorte", Type::GetType("System.String"));
		kuchenTabelle->Columns->Add("Aktuell", Type::GetType("System.DateTime"));

		DataRow^ tabellenZeile;

		for each (Kuchen^ tempkuchen in kuchenListe)
		{
			// wenn der Suchstring irgendwie vorkommt?
			// das schliet einen leeren Suchstring implizit mit ein
			if (tempkuchen->gesamt()->Contains(suchmaske))
			{
				tabellenZeile = kuchenTabelle->NewRow();
				tabellenZeile["ID"] = tempkuchen->Id;
				tabellenZeile["Anbieter"] = tempkuchen->Anbieter;
				tabellenZeile["Sorte"] = tempkuchen->Sorte;
				tabellenZeile["Aktuell"] = tempkuchen->Timestamp;

				kuchenTabelle->Rows->Add(tabellenZeile);
			}
		}

		return kuchenTabelle;
	}

	property List<Kuchen^>^ KuchenListe
	{
		List<Kuchen^>^ get()
		{
			return kuchenListe;
		}
	}

	void add(Kuchen^ aktkuchen)
	{
		kuchenListe->Add(aktkuchen);
	}

	void del(int aktid)
	{
		Kuchen^ loeschkuchen;
		bool existKuchen = false;

		for each (Kuchen^ tempkuchen in kuchenListe)
		{
			if (tempkuchen->Id == aktid)
			{
				existKuchen = true;
				loeschkuchen = tempkuchen;
				break;
			}
		}
		if (existKuchen)
		{
			kuchenListe->Remove(loeschkuchen);
		}
	}

	void neu(Kuchen^ aktkuchen)
	{
		aktkuchen->Id = getAutoID();
		//die anderen Felder werden leer initialisiert
		aktkuchen->Anbieter = "";
		aktkuchen->Sorte = "";
		aktkuchen->Beschreibung = "";
		aktkuchen->Anzahl = 0;
		aktkuchen->Abgabedatum = DateTime(2000, 1, 1);
		aktkuchen->Diabetikergeeignet = false;

		kuchenListe->Add(aktkuchen);
	}

	void lesen()
	{
		StreamReader^ streamreader;
		String^ zeile;
		Kuchen^ tempKuchen;

		kuchenListe->Clear();

		try
		{
			streamreader = gcnew StreamReader(eingabeDateiname);

			while (zeile = streamreader->ReadLine())
			{
				if (zeile->Length > 0)
				{
					tempKuchen = gcnew Kuchen(zeile);
					add(tempKuchen);
				}
			}

			streamreader->Close();
		}

		catch (Exception^ e)
		{
			MessageBox::Show(e->Message);
		}

		finally
		{
			delete streamreader;
		}
	}

	void speichern()
	{
		StreamWriter^ streamwriter;
		String^ zeile;

		try
		{
			streamwriter = gcnew StreamWriter(ausgabeDateiname);

			for each(Kuchen^ tempKuchen in KuchenListe)
			{
				zeile = tempKuchen->gesamt();
				streamwriter->WriteLine(zeile);
			}

			streamwriter->Close();
		}

		catch (Exception^ e)
		{
			MessageBox::Show(e->Message);
		}

		finally
		{
			delete streamwriter;
		}
	}
};
