using namespace System::Data;
using namespace System::Data::OleDb;
using namespace System::Data::SqlClient;
using namespace System;
using namespace System::Collections::Generic;

#include "KuchenDB.h"
#include "SortenDB.h"

public ref class DBAssistent
{
private:
	OleDbConnection^ verbindung;
//	SqlConnection^ verbindungSQL;

	OleDbCommand^ sqlabfrage;
//	SqlCommand^ sqlabfrageSQL;

	KuchenDB^ kuchenDB;
	SortenDB^ sortenDB;

	void initVerbindung()
	{
		verbindung = gcnew OleDbConnection();
		verbindung->ConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source = Kuchenbasar.mdb";
		verbindung->Open();

		sqlabfrage = gcnew OleDbCommand();
		sqlabfrage->Connection = verbindung;
	}

/*	void initVerbindungSQL()
	{
		verbindungSQL = gcnew SqlConnection();
		verbindungSQL->ConnectionString = "";
		verbindungSQL->Open();

		sqlabfrageSQL = gcnew SqlCommand();
		sqlabfrageSQL->Connection = verbindung;
	}
*/
public:
	DBAssistent()
	{
		initVerbindung();

		kuchenDB = gcnew KuchenDB(sqlabfrage);
		sortenDB = gcnew SortenDB(sqlabfrage);

	}

	~DBAssistent()
	{
	}

	DataTable^ getKuchenTabelle()
	{
		return kuchenDB->getTable();
	}

	List<String^>^ getSortenList()
	{
		return sortenDB->getList();
	}

	String^ getSortenname(int kuchenid)
	{
		int fkId = kuchenDB->getSorte(kuchenid);
		return sortenDB->getBackwarenSorte(fkId);
	}

	void closeDataBase()
	{
		verbindung->Close();
//		verbindungSQL->Close();
	}

	void updateKuchen(Kuchen^ aktkuchen)
	{
		kuchenDB->update(aktkuchen);
	}

	void getKuchen(Kuchen^ aktkuchen)
	{
		kuchenDB->get(aktkuchen);
	}

private:
};