using namespace System;
using namespace System::Data;
using namespace System::Data::OleDb;
using namespace System::Collections::Generic;

public ref class EinrichtungenDB
{
private:
	OleDbCommand^ sqlAbfrage;

public:
	EinrichtungenDB(OleDbCommand^ sqlAbfrage)
		:sqlAbfrage(sqlAbfrage)
	{
	}

	EinrichtungenDB()
	{
	}

	~EinrichtungenDB()
	{
	}

	List<String^>^ einrichtungenliste = nullptr;
	Dictionary<int, String^>^ dictlist;

	List<String^>^ getList()
	{
		if (nullptr == einrichtungenliste)
		{
			einrichtungenliste = gcnew List<String^>;
			dictlist = gcnew Dictionary<int, String^>;

			sqlAbfrage->CommandText = "SELECT ID, einrichtung FROM Einrichtungen ORDER BY 1 ASC";
			OleDbDataReader^ aktCursor = sqlAbfrage->ExecuteReader();

			while (aktCursor->Read())
			{
				int tempid = aktCursor->GetInt32(0);
				String^ tempname = aktCursor->GetString(1);

				einrichtungenliste->Add(tempname);
				dictlist->Add(tempid, tempname);
			}

			aktCursor->Close();
		}
		return einrichtungenliste;
	}

	String^ getEinrichtung(int gaesteid)
	{
		sqlAbfrage->CommandText =
			"SELECT einrichtung " + 
			"FROM Einrichtungen " +
			"WHERE id IN "+ 
			"      (SELECT einrichtung " +
			"       FROM Gaeste " +
			"       WHERE id = @gaesteid);";

		sqlAbfrage->Parameters->Clear();
		sqlAbfrage->Parameters->AddWithValue("@gaesteid", gaesteid);

		Object^ aktSQL = sqlAbfrage->ExecuteScalar();
		if (aktSQL != nullptr)
		{
			String^ tempEinrichtung = Convert::ToString(aktSQL);
			return tempEinrichtung;
		}

		return "";
	}
};