#pragma once
#ifndef _IKUCHENBASAR
#include "IKuchenBasar.h"
#endif

namespace KuchenBasar {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;

	public ref class KuchenWerte : public System::Windows::Forms::Form
	{
	private:
		IKuchenBasar^ kuchenBasar;
		DBAssistent^ dbAssistent;
        Kuchen^ aktKuchen;

	public:
		KuchenWerte(IKuchenBasar^ kuchenBasarForm, DBAssistent^ dbAssistentForm)
		{
			InitializeComponent();

			kuchenBasar = kuchenBasarForm;
			dbAssistent = dbAssistentForm;

			if (kuchenBasar->AktKuchenID < 0)
			{
				aktKuchen = gcnew Kuchen(-1, "", 0, "neuer Kuchen", "", DateTime::Now, 0, 0.0, false);
			}
			else
			{
				aktKuchen = dbAssistent->getKuchen(kuchenBasar->AktKuchenID);
			}

			textBoxAnbieter->Text = aktKuchen->Anbieter;
			textBoxKurzName->Text = aktKuchen->Kurzkuchen;
			textBoxBeschreibung->Text = aktKuchen->Beschreibung;

			comboBoxSorte->DataSource = dbAssistent->getSortenList();
			comboBoxSorte->SelectedIndex = aktKuchen->Sorte;

			numericUpDownAnzahl->Value = Convert::ToInt32(aktKuchen->Anzahl);
			numericUpDownPreis->Value = Convert::ToDecimal(aktKuchen->Preis);

			dateTimePickerAbgabedatum->CustomFormat = "dd.MMM.yyyy, HH:mm:ss";
			dateTimePickerAbgabedatum->Value = Convert::ToDateTime(aktKuchen->Abgabedatum);

			checkBoxDiabetikergeeignet->Checked = aktKuchen->Diabetikergeeignet;
		}

		KuchenWerte()
		{
		}
	
	protected:
		/// <summary>
		/// Verwendete Ressourcen bereinigen.
		/// </summary>
		~KuchenWerte()
		{
			if (components)
			{
				delete components;
			}
		}

	private: System::Windows::Forms::Button^  buttonSpeichern;
	private: System::Windows::Forms::Button^  buttonAbbruch;

	private: System::Windows::Forms::NumericUpDown^  numericUpDownAnzahl;
	private: System::Windows::Forms::TextBox^  textBoxAnbieter;
	private: System::Windows::Forms::TextBox^  textBoxKurzName;
	private: System::Windows::Forms::TextBox^  textBoxBeschreibung;
	private: System::Windows::Forms::DateTimePicker^  dateTimePickerAbgabedatum;
	private: System::Windows::Forms::CheckBox^  checkBoxDiabetikergeeignet;
	private: System::Windows::Forms::ComboBox^  comboBoxSorte;	
	private: System::Windows::Forms::NumericUpDown^  numericUpDownPreis;
	
	private: System::Windows::Forms::Label^  labelPreis;
	private: System::Windows::Forms::Label^  labelAnbieter;
	private: System::Windows::Forms::Label^  labelSorte;
	private: System::Windows::Forms::Label^  labelBeschreibung;
	private: System::Windows::Forms::Label^  labelAbgabedatum;
	private: System::Windows::Forms::Label^  labelKurzName;
	private: System::Windows::Forms::Label^  labelAnzahl;

	private:
		/// <summary>
		/// Erforderliche Designervariable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung.
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		void InitializeComponent(void)
		{
			this->buttonSpeichern = (gcnew System::Windows::Forms::Button());
			this->buttonAbbruch = (gcnew System::Windows::Forms::Button());
			this->numericUpDownAnzahl = (gcnew System::Windows::Forms::NumericUpDown());
			this->labelAnzahl = (gcnew System::Windows::Forms::Label());
			this->textBoxAnbieter = (gcnew System::Windows::Forms::TextBox());
			this->textBoxBeschreibung = (gcnew System::Windows::Forms::TextBox());
			this->dateTimePickerAbgabedatum = (gcnew System::Windows::Forms::DateTimePicker());
			this->labelAnbieter = (gcnew System::Windows::Forms::Label());
			this->labelSorte = (gcnew System::Windows::Forms::Label());
			this->labelBeschreibung = (gcnew System::Windows::Forms::Label());
			this->labelAbgabedatum = (gcnew System::Windows::Forms::Label());
			this->checkBoxDiabetikergeeignet = (gcnew System::Windows::Forms::CheckBox());
			this->comboBoxSorte = (gcnew System::Windows::Forms::ComboBox());
			this->textBoxKurzName = (gcnew System::Windows::Forms::TextBox());
			this->labelKurzName = (gcnew System::Windows::Forms::Label());
			this->numericUpDownPreis = (gcnew System::Windows::Forms::NumericUpDown());
			this->labelPreis = (gcnew System::Windows::Forms::Label());
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownAnzahl))->BeginInit();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownPreis))->BeginInit();
			this->SuspendLayout();
			// 
			// buttonSpeichern
			// 
			this->buttonSpeichern->Location = System::Drawing::Point(540, 59);
			this->buttonSpeichern->Name = L"buttonSpeichern";
			this->buttonSpeichern->Size = System::Drawing::Size(165, 43);
			this->buttonSpeichern->TabIndex = 11;
			this->buttonSpeichern->Text = L"Speichern";
			this->buttonSpeichern->UseVisualStyleBackColor = true;
			this->buttonSpeichern->Click += gcnew System::EventHandler(this, &KuchenWerte::buttonSpeichern_Click);
			// 
			// buttonAbbruch
			// 
			this->buttonAbbruch->Location = System::Drawing::Point(540, 264);
			this->buttonAbbruch->Name = L"buttonAbbruch";
			this->buttonAbbruch->Size = System::Drawing::Size(165, 40);
			this->buttonAbbruch->TabIndex = 12;
			this->buttonAbbruch->Text = L"Abbruch";
			this->buttonAbbruch->UseVisualStyleBackColor = true;
			this->buttonAbbruch->Click += gcnew System::EventHandler(this, &KuchenWerte::buttonAbbruch_Click);
			// 
			// numericUpDownAnzahl
			// 
			this->numericUpDownAnzahl->Location = System::Drawing::Point(162, 245);
			this->numericUpDownAnzahl->Name = L"numericUpDownAnzahl";
			this->numericUpDownAnzahl->Size = System::Drawing::Size(203, 20);
			this->numericUpDownAnzahl->TabIndex = 6;
			// 
			// labelAnzahl
			// 
			this->labelAnzahl->AutoSize = true;
			this->labelAnzahl->Location = System::Drawing::Point(62, 252);
			this->labelAnzahl->Name = L"labelAnzahl";
			this->labelAnzahl->Size = System::Drawing::Size(39, 13);
			this->labelAnzahl->TabIndex = 5;
			this->labelAnzahl->Text = L"Anzahl";
			// 
			// textBoxAnbieter
			// 
			this->textBoxAnbieter->Location = System::Drawing::Point(162, 21);
			this->textBoxAnbieter->Name = L"textBoxAnbieter";
			this->textBoxAnbieter->Size = System::Drawing::Size(203, 20);
			this->textBoxAnbieter->TabIndex = 1;
			// 
			// textBoxBeschreibung
			// 
			this->textBoxBeschreibung->Location = System::Drawing::Point(164, 148);
			this->textBoxBeschreibung->Name = L"textBoxBeschreibung";
			this->textBoxBeschreibung->Size = System::Drawing::Size(201, 20);
			this->textBoxBeschreibung->TabIndex = 4;
			// 
			// dateTimePickerAbgabedatum
			// 
			this->dateTimePickerAbgabedatum->CustomFormat = L"dd.MMM.yyyy, HH:mm:ss";
			this->dateTimePickerAbgabedatum->Format = System::Windows::Forms::DateTimePickerFormat::Custom;
			this->dateTimePickerAbgabedatum->Location = System::Drawing::Point(164, 200);
			this->dateTimePickerAbgabedatum->Name = L"dateTimePickerAbgabedatum";
			this->dateTimePickerAbgabedatum->Size = System::Drawing::Size(203, 20);
			this->dateTimePickerAbgabedatum->TabIndex = 5;
			// 
			// labelAnbieter
			// 
			this->labelAnbieter->AutoSize = true;
			this->labelAnbieter->Location = System::Drawing::Point(55, 28);
			this->labelAnbieter->Name = L"labelAnbieter";
			this->labelAnbieter->Size = System::Drawing::Size(46, 13);
			this->labelAnbieter->TabIndex = 0;
			this->labelAnbieter->Text = L"Anbieter";
			// 
			// labelSorte
			// 
			this->labelSorte->AutoSize = true;
			this->labelSorte->Location = System::Drawing::Point(69, 67);
			this->labelSorte->Name = L"labelSorte";
			this->labelSorte->Size = System::Drawing::Size(32, 13);
			this->labelSorte->TabIndex = 0;
			this->labelSorte->Text = L"Sorte";
			// 
			// labelBeschreibung
			// 
			this->labelBeschreibung->AutoSize = true;
			this->labelBeschreibung->Location = System::Drawing::Point(37, 155);
			this->labelBeschreibung->Name = L"labelBeschreibung";
			this->labelBeschreibung->Size = System::Drawing::Size(72, 13);
			this->labelBeschreibung->TabIndex = 12;
			this->labelBeschreibung->Text = L"Beschreibung";
			// 
			// labelAbgabedatum
			// 
			this->labelAbgabedatum->AutoSize = true;
			this->labelAbgabedatum->Location = System::Drawing::Point(28, 207);
			this->labelAbgabedatum->Name = L"labelAbgabedatum";
			this->labelAbgabedatum->Size = System::Drawing::Size(73, 13);
			this->labelAbgabedatum->TabIndex = 13;
			this->labelAbgabedatum->Text = L"Abgabedatum";
			// 
			// checkBoxDiabetikergeeignet
			// 
			this->checkBoxDiabetikergeeignet->AutoSize = true;
			this->checkBoxDiabetikergeeignet->Location = System::Drawing::Point(162, 346);
			this->checkBoxDiabetikergeeignet->Name = L"checkBoxDiabetikergeeignet";
			this->checkBoxDiabetikergeeignet->Size = System::Drawing::Size(118, 17);
			this->checkBoxDiabetikergeeignet->TabIndex = 8;
			this->checkBoxDiabetikergeeignet->Text = L"Diabetiker geeignet";
			this->checkBoxDiabetikergeeignet->UseVisualStyleBackColor = true;
			// 
			// comboBoxSorte
			// 
			this->comboBoxSorte->FormattingEnabled = true;
			this->comboBoxSorte->Location = System::Drawing::Point(162, 59);
			this->comboBoxSorte->Name = L"comboBoxSorte";
			this->comboBoxSorte->Size = System::Drawing::Size(201, 21);
			this->comboBoxSorte->TabIndex = 2;
			// 
			// textBoxKurzName
			// 
			this->textBoxKurzName->Location = System::Drawing::Point(162, 103);
			this->textBoxKurzName->Name = L"textBoxKurzName";
			this->textBoxKurzName->Size = System::Drawing::Size(201, 20);
			this->textBoxKurzName->TabIndex = 3;
			// 
			// labelKurzName
			// 
			this->labelKurzName->AutoSize = true;
			this->labelKurzName->Location = System::Drawing::Point(55, 110);
			this->labelKurzName->Name = L"labelKurzName";
			this->labelKurzName->Size = System::Drawing::Size(54, 13);
			this->labelKurzName->TabIndex = 0;
			this->labelKurzName->Text = L"Kurzname";
			// 
			// numericUpDownPreis
			// 
			this->numericUpDownPreis->DecimalPlaces = 2;
			this->numericUpDownPreis->Increment = System::Decimal(gcnew cli::array< System::Int32 >(4) { 10, 0, 0, 131072 });
			this->numericUpDownPreis->Location = System::Drawing::Point(162, 298);
			this->numericUpDownPreis->Name = L"numericUpDownPreis";
			this->numericUpDownPreis->Size = System::Drawing::Size(203, 20);
			this->numericUpDownPreis->TabIndex = 7;
			// 
			// labelPreis
			// 
			this->labelPreis->AutoSize = true;
			this->labelPreis->Location = System::Drawing::Point(70, 305);
			this->labelPreis->Name = L"labelPreis";
			this->labelPreis->Size = System::Drawing::Size(30, 13);
			this->labelPreis->TabIndex = 19;
			this->labelPreis->Text = L"Preis";
			// 
			// KuchenWerte
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->BackColor = System::Drawing::SystemColors::Window;
			this->ClientSize = System::Drawing::Size(806, 388);
			this->Controls->Add(this->labelPreis);
			this->Controls->Add(this->numericUpDownPreis);
			this->Controls->Add(this->labelKurzName);
			this->Controls->Add(this->textBoxKurzName);
			this->Controls->Add(this->comboBoxSorte);
			this->Controls->Add(this->checkBoxDiabetikergeeignet);
			this->Controls->Add(this->labelAbgabedatum);
			this->Controls->Add(this->labelBeschreibung);
			this->Controls->Add(this->labelSorte);
			this->Controls->Add(this->labelAnbieter);
			this->Controls->Add(this->dateTimePickerAbgabedatum);
			this->Controls->Add(this->textBoxBeschreibung);
			this->Controls->Add(this->textBoxAnbieter);
			this->Controls->Add(this->labelAnzahl);
			this->Controls->Add(this->numericUpDownAnzahl);
			this->Controls->Add(this->buttonAbbruch);
			this->Controls->Add(this->buttonSpeichern);
			this->Name = L"KuchenWerte";
			this->Text = L"KuchenWerte";
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownAnzahl))->EndInit();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownPreis))->EndInit();
			this->ResumeLayout(false);
			this->PerformLayout();

		}
#pragma endregion
	private:
		bool komplexePlausis()
		{
			if (textBoxAnbieter->Text->Length == 0)
			{
				MessageBox::Show("Anbieter mu gefllt werden");
				return false;
			}

			if (textBoxKurzName->Text->Length == 0)
			{
				MessageBox::Show("Kurzname mu gefllt werden");
				return false;
			}

			if (comboBoxSorte->SelectedIndex == 0)
			{
				MessageBox::Show("keine gltige Kuchensorte");
				return false;
			}

			if (numericUpDownAnzahl->Value == 0)
			{
				MessageBox::Show("Anzahl darf nicht 0 sein");
				return false;
			}

			if (Convert::ToDouble(numericUpDownPreis->Value) < 0.1)
			{
				MessageBox::Show("Preis darf nicht 0.00 sein");
				return false;
			}

			return true;
		}

		Void buttonAbbruch_Click(Object^  sender, EventArgs^  e)
		{
			this->Close();
		}

		Void buttonSpeichern_Click(Object^  sender, EventArgs^  e)
		{
			if (! komplexePlausis())
			{
				//MessageBox::Show("mind. ein Feld war nicht korrekt gefllt");
			}
			else
			{
				aktKuchen->Anbieter = textBoxAnbieter->Text;
				aktKuchen->Beschreibung = textBoxBeschreibung->Text;
				aktKuchen->Kurzkuchen = textBoxKurzName->Text;

				aktKuchen->Sorte = comboBoxSorte->SelectedIndex;

				aktKuchen->Anzahl = Convert::ToInt32(numericUpDownAnzahl->Value);
				aktKuchen->Preis = Convert::ToDouble(numericUpDownPreis->Value);

				//wieder Entfernen des Custom Format Kommas
				String^ tempAbgabedatum = dateTimePickerAbgabedatum->Text->Replace(',', ' ');
				aktKuchen->Abgabedatum = Convert::ToDateTime(tempAbgabedatum);

				aktKuchen->Diabetikergeeignet = checkBoxDiabetikergeeignet->Checked;

				if (kuchenBasar->AktKuchenID < 0)
				{
					int neuKuchenID = dbAssistent->insertKuchen(aktKuchen);
					kuchenBasar->AktKuchenID = neuKuchenID;
				}
				else
				{
					aktKuchen->Id = kuchenBasar->AktKuchenID;
					dbAssistent->updateKuchen(aktKuchen);
				}

				this->Close();
			}
		}
	};
}
