using namespace System::Data;
using namespace System::Data::OleDb;
using namespace System;
using namespace System::Collections::Generic;

#include "BestellungenDB.h"
#include "KuchenDB.h"
#include "SortenDB.h"
#include "GaesteDB.h"
#include "EinrichtungenDB.h"

public ref class DBAssistent
{
private:
	OleDbConnection^ verbindung;

	OleDbCommand^ sqlabfrage;

	BestellungenDB^ bestellungenDB;
	KuchenDB^ kuchenDB;
	SortenDB^ sortenDB;
	GaesteDB^ gaesteDB;
	EinrichtungenDB^ einrichtungenDB;

	void initVerbindung()
	{
		verbindung = gcnew OleDbConnection();
		verbindung->ConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source = Kuchenbasar.mdb";
		verbindung->Open();

		sqlabfrage = gcnew OleDbCommand();
		sqlabfrage->Connection = verbindung;
	}

public:
	DBAssistent()
	{
		initVerbindung();

		bestellungenDB = gcnew BestellungenDB(sqlabfrage);
		kuchenDB = gcnew KuchenDB(sqlabfrage);
		sortenDB = gcnew SortenDB(sqlabfrage);
		gaesteDB = gcnew GaesteDB(sqlabfrage);
		einrichtungenDB = gcnew EinrichtungenDB(sqlabfrage);
	}

	~DBAssistent()
	{
	}

	void closeDataBase()
	{
		verbindung->Close();
	}

	//BestellungenDB
	DataTable^ getBestellungenTabelle()
	{
		return bestellungenDB->getTable();
	}

	DataTable^ getBestellungenTabelle(String^ suchstring)
	{
		return bestellungenDB->getTable(suchstring);
	}

	Bestellung^ getBestellung(int aktid)
	{
		return bestellungenDB->get(aktid);
	}

	DataTable^ getBestellungenKomplettTabelle()
	{
		return bestellungenDB->getKomplettTable();
	}

	void updateBestellung(Bestellung^ aktbestellung)
	{
		bestellungenDB->update(aktbestellung);

		int tempKuchenID = aktbestellung->KuchenId;
		int tempKuchenVeraenderung = -1 * aktbestellung->Menge;

		kuchenDB->setVorrat(tempKuchenID, tempKuchenVeraenderung);
	}

	void updateBestellung(Bestellung^ aktbestellung, int alterKuchenID, int alterKuchenMenge)
	{
		bestellungenDB->update(aktbestellung);

		int tempKuchenID = aktbestellung->KuchenId;
		int tempKuchenVeraenderung = -1 * aktbestellung->Menge;

		kuchenDB->setVorrat(tempKuchenID, tempKuchenVeraenderung);

		kuchenDB->setVorrat(alterKuchenID, alterKuchenMenge);
	}

	int insertBestellung(Bestellung^ neubestellung)
	{
		int tempNeuID = bestellungenDB->insert(neubestellung);

		int tempKuchenID = neubestellung->KuchenId;
		int tempKuchenVeraenderung = -1 * neubestellung->Menge;
	
		kuchenDB->setVorrat(tempKuchenID, tempKuchenVeraenderung);
	
		return tempNeuID;
	}

	void deleteBestellung(int aktid)
	{
		bestellungenDB->del(aktid);
	}

	bool vorhandenBestellung(int gaesteid, int kuchenid)
	{
		return bestellungenDB->vorhandenBestellung(gaesteid, kuchenid);
	}

	//KuchenDB
	List<String^>^ getKuchenList()
	{
		return kuchenDB->getList();
	}

	bool changedKuchenList()
	{
		return kuchenDB->isChanged;
	}

	DataTable^ getKuchenTabelle()
	{
		return kuchenDB->getTable();
	}

	DataTable^ getKuchenTabelle(String^ suchstring)
	{
		return kuchenDB->getTable(suchstring);
	}

	Kuchen^ getKuchen(int aktid)
	{
		return kuchenDB->get(aktid);
	}

	void updateKuchen(Kuchen^ aktkuchen)
	{
		kuchenDB->update(aktkuchen);
	}

	int insertKuchen(Kuchen^ aktkuchen)
	{
		return kuchenDB->insert(aktkuchen);
	}

	void deleteKuchen(int aktid)
	{
		kuchenDB->del(aktid);
	}

	int getVorratKuchen(int aktid)
	{
		return kuchenDB->getVorrat(aktid);
	}

	double getPreisKuchen(int aktid)
	{
		return kuchenDB->getPreis(aktid);
	}

	int getKuchenBestellungenGesamt(int kuchenid)
	{
		return bestellungenDB->getKuchenGesamt(kuchenid);
	}

	//da die Kuchen in der Access-DB Lcken im Key(Index) haben knnen, 
	//in der Comboxbox aber nicht, wird hier eine Umsetzung in beide Richtungen
	//ber die Dictionary gewhrleistet
	int IdFromIndexKuchen(int index)
	{
		return kuchenDB->getIdFromIndex(index);
	}

	int IndexFromIdKuchen(int id)
	{
		return kuchenDB->getIndexFromId(id);
	}

	//SortenDB	
	List<String^>^ getSortenList()
	{
		return sortenDB->getList();
	}

	String^ getSorte(int kuchenid)
	{
		List<String^>^ backwaren = sortenDB->getList();
		int fkId = kuchenDB->getSorte(kuchenid);

		return sortenDB->getBackwarenSorte(fkId);
	}
	//GaesteDB
	List<String^>^ getGaesteList()
	{
		return gaesteDB->getList();
	}

	bool changedGaesteList()
	{
		return gaesteDB->isChanged;
	}

	DataTable^ getGaesteTabelle()
	{
		return gaesteDB->getTable();
	}

	DataTable^ getGaesteTabelle(String^ suchstring)
	{
		return gaesteDB->getTable(suchstring);
	}

	Gast^ getGaeste(int aktid)
	{
		return gaesteDB->get(aktid);
	}

	void updateGaeste(Gast^ aktgast)
	{
		gaesteDB->update(aktgast);
	}

	int insertGaeste(Gast^ aktgast)
	{
		return gaesteDB->insert(aktgast);
	}

	void deleteGaeste(int aktid)
	{
		gaesteDB->del(aktid);
	}
	
	//da die Gaeste in der Access-DB Lcken im Key(Index) haben knnen, 
	//in der Comboxbox aber nicht, wird hier eine Umsetzung in beide Richtungen
	//ber die Dictionary gewhrleistet
	int IdFromIndexGaeste(int index)
	{
		return gaesteDB->getIdFromIndex(index);
	}

	int IndexFromIdGaeste(int id)
	{
		return gaesteDB->getIndexFromId(id);
	}

	int getGaesteBestellungenGesamt(int gaesteid)
	{
		return bestellungenDB->getGaesteGesamt(gaesteid);
	}

	//EinrichtungenDB	
	List<String^>^ getEinrichtungenList()
	{
		return einrichtungenDB->getList();
	}

	String^ getEinrichtung(int gaesteid)
	{
		return einrichtungenDB->getEinrichtung(gaesteid);
	}
};