using namespace System;
using namespace System::Windows::Forms;

public ref class Kuchen
{
private:
	int id;
	String^ anbieter;
	int sorte;
	String^ kurzkuchen;
	String^ beschreibung;
	DateTime^ abgabedatum;
	int anzahl;
	double preis;
	bool diabetikergeeignet;
	DateTime^ letzterzugriff;

public:
	property int Id
	{
		int get()
		{
			return this->id;
		}

		void set(int id)
		{
			this->id = id;
		}
	}

	property String^ Anbieter
	{
		String^ get()
		{
			return this->anbieter;
		}

		void set(String^ anbieter)
		{
			this->anbieter = anbieter;
		}
	}

	property int Sorte
	{
		int get()
		{
			return this->sorte;
		}

		void set(int sorte)
		{
			this->sorte = sorte;
		}
	}

	property String^ Kurzkuchen
	{
		String^ get()
		{
			return this->kurzkuchen;
		}

		void set(String^ kurzkuchen)
		{
			this->kurzkuchen = kurzkuchen;
		}
	}

	property String^ Beschreibung
	{
		String^ get()
		{
			return this->beschreibung;
		}

		void set(String^ beschreibung)
		{
			this->beschreibung = beschreibung;
		}
	}

	property DateTime^ Abgabedatum
	{
		DateTime^ get()
		{
			return this->abgabedatum;
		}

		void set(DateTime^ abgabedatum)
		{
			this->abgabedatum = abgabedatum;
		}
	}

	property int Anzahl
	{
		int get()
		{
			return this->anzahl;
		}

		void set(int anzahl)
		{
			this->anzahl = anzahl;
		}
	}

	property double Preis
	{
		double get()
		{
			return this->preis;
		}

		void set(double preis)
		{
			this->preis = preis;
		}
	}

	property bool Diabetikergeeignet
	{
		bool get()
		{
			return this->diabetikergeeignet;
		}

		void set(bool diabetikergeeignet)
		{
			this->diabetikergeeignet = diabetikergeeignet;
		}
	}

	property DateTime^ Letzterzugriff
	{
		DateTime^ get()
		{
			return this->letzterzugriff;
		}

		void set(DateTime^ letzterzugriff)
		{
			this->letzterzugriff = letzterzugriff;
		}
	}

	Kuchen(int id, String^ anbieter, int sorte, String^ kurzkuchen, String^ beschreibung, DateTime^ abgabedatum, int anzahl, double preis, bool diabetikergeeignet)
		:id(id),
		anbieter(anbieter),
		sorte(sorte),
		kurzkuchen(kurzkuchen),
		beschreibung(beschreibung),
		abgabedatum(abgabedatum),
		anzahl(anzahl),
		preis(preis),
		diabetikergeeignet(diabetikergeeignet)
	{
		this->letzterzugriff = DateTime::Now;
	}

	Kuchen(String^ kuchenInformation)
	{
		array<String^>^ kompletteListe = kuchenInformation->Split(';');

		Id = Int32::Parse(kompletteListe[0]);
		Anbieter = kompletteListe[1];
		Sorte = Int32::Parse(kompletteListe[2]);
		Kurzkuchen = kompletteListe[3];
		Beschreibung = kompletteListe[4];
		Abgabedatum = DateTime::Parse(kompletteListe[5]);
		Anzahl = Int32::Parse(kompletteListe[6]);
		Preis = Int32::Parse(kompletteListe[7]);
		Diabetikergeeignet = Boolean::Parse(kompletteListe[8]);

		//beim Laden sollte der Timestamp absichtlich nicht erneuert werden!
		Letzterzugriff = DateTime::Parse(kompletteListe[9]);
	}

	Kuchen()
	{
		Letzterzugriff = DateTime::Now;
	}

	~Kuchen()
	{

	}

	void change(Kuchen^ aktKuchen)
	{
		this->Anbieter = aktKuchen->Anbieter;
		this->Sorte = aktKuchen->Sorte;
		this->Kurzkuchen = aktKuchen->Kurzkuchen;
		this->Beschreibung = aktKuchen->Beschreibung;
		this->Abgabedatum = aktKuchen->Abgabedatum;
		this->Anzahl = aktKuchen->Anzahl;
		this->Preis = aktKuchen->Preis;
		this->Diabetikergeeignet = aktKuchen->Diabetikergeeignet;
		this->Letzterzugriff = DateTime::Now;
	}

	String^ gesamt()
	{
	//1;Frau Schmidt;1;Hefekuchen;selbstgebacken;27.11.2014 00:00:00;29;0.00;False;29.11.2014 17:43:47
		String^ temp;
		temp = Id.ToString() + ";" +
			   Anbieter + ";" +
		       Sorte.ToString() + ";" +
			   Kurzkuchen + ";" +
			   Beschreibung + ";" +
			   Abgabedatum->ToString() + ";" +
			   Anzahl.ToString() + ";" +
			   String::Format("{0:F2}", Preis)->Replace(',','.') + ";" +
			   Diabetikergeeignet.ToString() + ";" +
			   Letzterzugriff->ToString();

		return temp;
	}
};
