using namespace System;
using namespace System::Windows::Forms;

public ref class Bestellung
{
private:
	int id;
	int gaesteid;
	int kuchenid;
	DateTime^ bestelldatum;
	int menge;
	double gesamtpreis;
	bool bezahlt;
	bool geliefert;
	DateTime^ letzterzugriff;

public:
	property int Id
	{
		int get()
		{
			return this->id;
		}

		void set(int id)
		{
			this->id = id;
		}
	}

	property int GaesteId
	{
		int get()
		{
			return this->gaesteid;
		}

		void set(int gaesteid)
		{
			this->gaesteid = gaesteid;
		}
	}

	property int KuchenId
	{
		int get()
		{
			return this->kuchenid;
		}

		void set(int kuchenid)
		{
			this->kuchenid = kuchenid;
		}
	}

	property DateTime^ Bestelldatum
	{
		DateTime^ get()
		{
			return this->bestelldatum;
		}

		void set(DateTime^ bestelldatum)
		{
			this->bestelldatum = bestelldatum;
		}
	}

	property int Menge
	{
		int get()
		{
			return this->menge;
		}

		void set(int menge)
		{
			this->menge = menge;
		}
	}

	property double Gesamtpreis
	{
		double get()
		{
			return this->gesamtpreis;
		}

		void set(double gesamtpreis)
		{
			this->gesamtpreis = gesamtpreis;
		}
	}

	property bool Bezahlt
	{
		bool get()
		{
			return this->bezahlt;
		}

		void set(bool bezahlt)
		{
			this->bezahlt = bezahlt;
		}
	}

	property bool Geliefert
	{
		bool get()
		{
			return this->geliefert;
		}

		void set(bool geliefert)
		{
			this->geliefert = geliefert;
		}
	}

	property DateTime^ Letzterzugriff
	{
		DateTime^ get()
		{
			return this->letzterzugriff;
		}

		void set(DateTime^ letzterzugriff)
		{
			this->letzterzugriff = letzterzugriff;
		}
	}

	Bestellung(int id, int gaesteid, int kuchenid, DateTime^ bestelldatum, int menge, double gesamtpreis, bool bezahlt, bool geliefert)
		:id(id),
		gaesteid(gaesteid),
		kuchenid(kuchenid),
		bestelldatum(bestelldatum),
		menge(menge),
		gesamtpreis(gesamtpreis),
		bezahlt(bezahlt),
		geliefert(geliefert)
	{
		Letzterzugriff = DateTime::Now;
	}

	Bestellung(String^ bestellungInformation)
	{
		array<String^>^ kompletteListe = bestellungInformation->Split(';');

		if (!Int32::TryParse(kompletteListe[0], id))
		{
			id = 0;
		}

		GaesteId = Int32::Parse(kompletteListe[1]);
		KuchenId = Int32::Parse(kompletteListe[2]);
		Bestelldatum = DateTime::Parse(kompletteListe[3]);
		Menge = Int32::Parse(kompletteListe[4]);
		Gesamtpreis = Double::Parse(kompletteListe[5]);
		Bezahlt = Boolean::Parse(kompletteListe[6]);
		Geliefert = Boolean::Parse(kompletteListe[7]);

		//beim Laden sollte der Timestamp absichtlich nicht erneuert werden!
		Letzterzugriff = DateTime::Parse(kompletteListe[8]);
	}

	Bestellung()
	{
		Letzterzugriff = DateTime::Now;
	}

	~Bestellung()
	{

	}

	void change(Bestellung^ aktBestellung)
	{
		this->GaesteId = aktBestellung->GaesteId;
		this->KuchenId = aktBestellung->KuchenId;
		this->Bestelldatum = aktBestellung->Bestelldatum;
		this->Menge = aktBestellung->Menge;
		this->Gesamtpreis = aktBestellung->Gesamtpreis;
		this->Bezahlt = aktBestellung->Bezahlt;
		this->Geliefert = aktBestellung->Geliefert;
		this->Letzterzugriff = DateTime::Now;
	}

	String^ gesamt()
	{
		String^ temp;
		temp = Id.ToString() + ";" +
			GaesteId.ToString() + ";" +
			KuchenId.ToString() + ";" +
			Bestelldatum->ToString() + ";" +
			Menge.ToString() + ";" +
			Gesamtpreis.ToString() + ";" +
			Bezahlt.ToString() + ";" +
			Geliefert.ToString() + ";" +
			Letzterzugriff->ToString();

		return temp;
	}
};
