using namespace System;
using namespace System::Data;
using namespace System::Data::SqlClient;

public ref class GaesteDB
{
private:
	SqlCommand^ sqlAbfrage;

public:
	GaesteDB(SqlCommand^ sqlAbfrage)
		: sqlAbfrage(sqlAbfrage)
	{
		init();
	}

	GaesteDB()
	{
		init();
	}
	
	~GaesteDB()
	{
	}
	
	void init()
	{
		gaesteliste = gcnew List<String^>;
		isChanged = true;
		dictIndexFromId = gcnew Dictionary<int, int>;
		dictIdFromIndex = gcnew Dictionary<int, int>;
	}

	//Liste wird nach Insert/Delete gelscht
	//Liste wird am Anfang sowie bei Bedarf neu aufgebaut
	List<String^>^ gaesteliste;
	bool isChanged;
	
	Dictionary<int, int>^ dictIndexFromId;
	Dictionary<int, int>^ dictIdFromIndex;

	void erzwingeListenaufbau()
	{
		isChanged = true;
		gaesteliste->Clear();
		dictIndexFromId->Clear();
		dictIdFromIndex->Clear();
	}

	List<String^>^ getList()
	{
		isChanged = false;
		int counter = 0;
		
		if (gaesteliste->Count == 0)
		{
			sqlAbfrage->CommandText = "SELECT ID, kurzgast, einrichtung " +
				"FROM GaesteView ORDER BY 1 ASC";

			SqlDataReader^ aktCursor = sqlAbfrage->ExecuteReader();

			while (aktCursor->Read())
			{
				String^ tempgast = aktCursor->GetString(1);
				String^ tempeinrichtung = aktCursor->GetString(2);
				int tempID = aktCursor->GetInt32(0);

				isChanged = false;

				if (tempID > 0)
				{
					gaesteliste->Add(tempgast + ", " + tempeinrichtung);
				}
				else
				{
					gaesteliste->Add(tempgast);
				}

				dictIndexFromId->Add(tempID, counter);
				dictIdFromIndex->Add(counter, tempID);
				counter++;
			}

			aktCursor->Close();
		}
	
		return gaesteliste;
	}

	int getIdFromIndex(int index)
	{
		if (dictIdFromIndex->ContainsKey(index))
		{
			int tempId = dictIdFromIndex[index];
			return tempId;
		}
		else
		{
			return 0;
		}
	}

	int getIndexFromId(int id)
	{
		if (dictIndexFromId->ContainsKey(id))
		{
			int tempIndex = dictIndexFromId[id];
			return tempIndex;
		}
		else
		{
			return 0;
		}
	}

	void update(Gast^ aktgast)
	{
		aktgast->Letzterzugriff = DateTime::Now;
				
		sqlAbfrage->CommandText =
			"UPDATE Gaeste SET " +
			"gastname = " + "'" + aktgast->Gastname + "'" + ", " +
			"vorname = " + "'" + aktgast->Vorname + "'" + ", " +
			"kurzgast = " + "'" + aktgast->Kurzname + "'" + ", " +
			"einrichtung = " + aktgast->Einrichtung.ToString() + ", " +
			"telefon = " + "'" + aktgast->Telefon + "'" + ", " +
			"letzterzugriff =  " + "cast('" + aktgast->Letzterzugriff->ToString() + "' as datetime) " +
			"WHERE id = " + aktgast->Id.ToString() + ";";

		sqlAbfrage->ExecuteNonQuery();
	}

	int insert(Gast^ neugast)
	{
		neugast->Letzterzugriff = DateTime::Now;

		sqlAbfrage->CommandText =
			"INSERT INTO Gaeste " +
			"(gastname, vorname, kurzgast, einrichtung, telefon, letzterzugriff) " +
			"VALUES (" +
			"'" + neugast->Gastname + "'" + ", " +
			"'" + neugast->Vorname + "'" + ", " +
			"'" + neugast->Kurzname + "'" + ", " +
			neugast->Einrichtung.ToString() + ", " +
			"'" + neugast->Telefon + "'" + ", " +
			"cast('" + neugast->Letzterzugriff->ToString() + "' as datetime)" +
			");";

		sqlAbfrage->ExecuteNonQuery();

		//Lsche die gaesteliste und die dictionary, sie werden gleich wieder aufgebaut :-)
		erzwingeListenaufbau();

		int neueID = 0;

		sqlAbfrage->CommandText =
			"SELECT id FROM Gaeste " +
			"WHERE kurzgast = " + "'" + neugast->Kurzname->ToString() + "'" +
			" AND  letzterzugriff = " + "cast('" + neugast->Letzterzugriff->ToString() + "' as datetime);";

		Object^ aktSQL = sqlAbfrage->ExecuteScalar();
		if (aktSQL != nullptr)
		{
			neueID = Convert::ToInt32(aktSQL);
		}

		return neueID;
	}

	void del(int aktid)
	{
		sqlAbfrage->CommandText =
			"DELETE " +
			"FROM Gaeste " +
			"WHERE id = @id;";

		sqlAbfrage->Parameters->Clear();
		sqlAbfrage->Parameters->AddWithValue("@id", aktid);

		sqlAbfrage->ExecuteNonQuery();

		//Lsche die gaesteliste und die dictionary, sie werden gleich wieder aufgebaut :-)
		erzwingeListenaufbau();
	}

	Gast^ get(int aktid)
	{
		Gast^ aktGast = gcnew Gast();

		aktGast->Id = aktid;

		sqlAbfrage->CommandText =
			"SELECT gastname, vorname, kurzgast, einrichtung, telefon " +
			"FROM Gaeste " +
			"WHERE id = @id;";

		sqlAbfrage->Parameters->Clear();
		sqlAbfrage->Parameters->AddWithValue("@id", aktid);

        SqlDataReader^ aktCursor = sqlAbfrage->ExecuteReader();

		aktCursor->Read();

		aktGast->Gastname = aktCursor->GetString(0);
		aktGast->Kurzname = aktCursor->GetString(2);
		aktGast->Einrichtung = aktCursor->GetInt32(3);
	
		Object^ tempvorname = aktCursor->GetValue(1);
		if (tempvorname != DBNull::Value)
		{
			aktGast->Vorname = aktCursor->GetString(1);
		}
		Object^ temptelefon = aktCursor->GetValue(4);
		if (temptelefon != DBNull::Value)
		{
			aktGast->Telefon = aktCursor->GetString(4);
		}

		aktCursor->Close();

		return aktGast;
	}

	DataTable^ getTable()
	{
		DataTable^ gaesteTabelle = gcnew DataTable();

		gaesteTabelle->Columns->Add("ID", Type::GetType("System.Int32"));
		gaesteTabelle->Columns->Add("Kurzname", Type::GetType("System.String"));
		gaesteTabelle->Columns->Add("Einrichtung", Type::GetType("System.String"));
		gaesteTabelle->Columns->Add("LetzterZugriff", Type::GetType("System.DateTime"));

		sqlAbfrage->CommandText =
			"SELECT ID, KurzGast, Einrichtung, Letzterzugriff " +
			"FROM GaesteView WHERE id > 0;";

		SqlDataReader^ aktCursor = sqlAbfrage->ExecuteReader();

		while (aktCursor->Read())
		{
			DataRow^ zeile = gaesteTabelle->NewRow();

			zeile["ID"] = aktCursor->GetInt32(0);
			zeile["Kurzname"] = aktCursor->GetString(1);
			zeile["Einrichtung"] = aktCursor->GetString(2);
			zeile["LetzterZugriff"] = aktCursor->GetDateTime(3);

			gaesteTabelle->Rows->Add(zeile);
		}

		aktCursor->Close();

		return gaesteTabelle;
	}

	DataTable^ getTable(String^ suchmaske)
	{
		DataTable^ gaesteTabelle = gcnew DataTable();
		String^ suchstring;

		gaesteTabelle->Columns->Add("ID", Type::GetType("System.Int32"));
		gaesteTabelle->Columns->Add("Kurzname", Type::GetType("System.String"));
		gaesteTabelle->Columns->Add("Einrichtung", Type::GetType("System.String"));
		gaesteTabelle->Columns->Add("LetzterZugriff", Type::GetType("System.DateTime"));

		sqlAbfrage->CommandText =
			"SELECT ID, KurzGast, Einrichtung, Letzterzugriff, Gastname, Vorname, Telefon " +
			"FROM GaesteView WHERE id > 0;";

		SqlDataReader^ aktCursor = sqlAbfrage->ExecuteReader();

		while (aktCursor->Read())
		{
			Object^ temp1 = aktCursor->GetValue(5);
			String^ tempvorname = "";
			if (temp1 != DBNull::Value)
			{
				tempvorname = aktCursor->GetString(5);
			}
			Object^ temp2 = aktCursor->GetValue(6);
			String^ temptelefon = "";
			if (temp2 != DBNull::Value)
			{
				temptelefon = aktCursor->GetString(6);
			}
			suchstring = aktCursor->GetString(1) +
				aktCursor->GetString(2) +
				aktCursor->GetString(4) +
				tempvorname +
				temptelefon;
			
			// wenn der Suchstring irgendwie vorkommt?
			// das schliet einen leeren Suchstring implizit mit ein
			if (suchstring->Contains(suchmaske))
			{
				DataRow^ zeile = gaesteTabelle->NewRow();

				zeile["ID"] = aktCursor->GetInt32(0);
				zeile["Kurzname"] = aktCursor->GetString(1);
				zeile["Einrichtung"] = aktCursor->GetString(2);
				zeile["LetzterZugriff"] = aktCursor->GetDateTime(3);

				gaesteTabelle->Rows->Add(zeile);
			}
		}

		aktCursor->Close();

		return gaesteTabelle;
	}
};