using namespace System::Data;
using namespace System::Data::SqlClient;
using namespace System;
using namespace System::Collections::Generic;

#include "KuchenDB.h"
#include "SortenDB.h"

public ref class DBAssistent
{
private:
	SqlConnection^ verbindung;

	SqlCommand^ sqlabfrage;

	KuchenDB^ kuchenDB;
	SortenDB^ sortenDB;

	void initVerbindung()
	{
		verbindung = gcnew SqlConnection();
		verbindung->ConnectionString = "Data Source=HRO-023-201;Initial Catalog=kuchenbasar;Integrated Security=True";
		//verbindung->ConnectionString = "Data Source=DINO-2;Initial Catalog=kuchenbasar;Integrated Security=True";
		verbindung->Open();

		sqlabfrage = gcnew SqlCommand();
		sqlabfrage->Connection = verbindung;
	}

public:
	DBAssistent()
	{
		initVerbindung();

		kuchenDB = gcnew KuchenDB(sqlabfrage);
		sortenDB = gcnew SortenDB(sqlabfrage);
	}

	~DBAssistent()
	{
	}

	DataTable^ getKuchenTabelle()
	{
		return kuchenDB->getTable();
	}

	List<String^>^ getSortenList()
	{
		return sortenDB->getList();
	}

	String^ getSortenname(int kuchenid)
	{
		int fkId = kuchenDB->getSorte(kuchenid);
		return sortenDB->getBackwarenSorte(fkId);
	}

	void closeDataBase()
	{
		verbindung->Close();
	}

	void updateKuchen(Kuchen^ aktkuchen)
	{
		kuchenDB->update(aktkuchen);
	}

	void getKuchen(Kuchen^ aktkuchen)
	{
		kuchenDB->get(aktkuchen);
	}

private:
};