/////////////////////////////////////////90////////////////////////////////////////////
#pragma once
#include "Kuchen.h"
#include "DBAssistent.h"

namespace KuchenSQL {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
	using namespace System::Data::OleDb;     // Access
	using namespace System::Data::SqlClient; // ADO.NET DbServer wie MSSQL MYSQL
	
	public ref class FormMain : public System::Windows::Forms::Form
	{
	private:
		Kuchen^ aktKuchen;

	public:
		
		DBAssistent^ dbAssistent = gcnew DBAssistent();

		FormMain(void)
		{
			InitializeComponent();
			dataGridViewKuchen->DataSource = dbAssistent->getKuchenTabelle(); 
		}

	protected:

		~FormMain()
		{
			if (components)
			{
				delete components;
			}
		}

	private: System::Windows::Forms::TabControl^  tabControl1;
	private: System::Windows::Forms::TabPage^  tabPage1;
	private: System::Windows::Forms::SplitContainer^  splitContainer1;
	private: System::Windows::Forms::DataGridView^  dataGridViewKuchen;
	private: System::Windows::Forms::TableLayoutPanel^  tableLayoutPanel1;

	private: System::Windows::Forms::TextBox^  textBoxID;
	private: System::Windows::Forms::TextBox^  textBoxAnbieter;
	private: System::Windows::Forms::TextBox^  textBoxBeschreibung;
	private: System::Windows::Forms::ComboBox^  comboBoxSorte;
	private: System::Windows::Forms::CheckBox^  checkBoxDiabetiker;

	private: System::Windows::Forms::DateTimePicker^  dateTimePickerAbgabe;
	private: System::Windows::Forms::NumericUpDown^  numericUpDownAnzahl;

	private: System::Windows::Forms::Label^  labelID;
	private: System::Windows::Forms::Label^  labelAnbieter;
	private: System::Windows::Forms::Label^  labelBeschreibung;
	private: System::Windows::Forms::Label^  labelSorte;
	private: System::Windows::Forms::Label^  labelAbgabedatum;
	private: System::Windows::Forms::Label^  labelAnzahl;
	private: System::Windows::Forms::Label^  labelDiabetiker;

	private: System::Windows::Forms::Button^  buttonSpeichern;

	private: System::ComponentModel::IContainer^  components;

	private:
		/// <summary>
		/// Erforderliche Designervariable.
		/// </summary>


#pragma region Windows Form Designer generated code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung.
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		void InitializeComponent(void)
		{
			System::Windows::Forms::DataGridViewCellStyle^  dataGridViewCellStyle1 = (gcnew System::Windows::Forms::DataGridViewCellStyle());
			this->tabControl1 = (gcnew System::Windows::Forms::TabControl());
			this->tabPage1 = (gcnew System::Windows::Forms::TabPage());
			this->splitContainer1 = (gcnew System::Windows::Forms::SplitContainer());
			this->dataGridViewKuchen = (gcnew System::Windows::Forms::DataGridView());
			this->tableLayoutPanel1 = (gcnew System::Windows::Forms::TableLayoutPanel());
			this->labelID = (gcnew System::Windows::Forms::Label());
			this->textBoxID = (gcnew System::Windows::Forms::TextBox());
			this->textBoxAnbieter = (gcnew System::Windows::Forms::TextBox());
			this->textBoxBeschreibung = (gcnew System::Windows::Forms::TextBox());
			this->labelAnbieter = (gcnew System::Windows::Forms::Label());
			this->labelBeschreibung = (gcnew System::Windows::Forms::Label());
			this->labelSorte = (gcnew System::Windows::Forms::Label());
			this->labelAbgabedatum = (gcnew System::Windows::Forms::Label());
			this->labelAnzahl = (gcnew System::Windows::Forms::Label());
			this->comboBoxSorte = (gcnew System::Windows::Forms::ComboBox());
			this->numericUpDownAnzahl = (gcnew System::Windows::Forms::NumericUpDown());
			this->labelDiabetiker = (gcnew System::Windows::Forms::Label());
			this->dateTimePickerAbgabe = (gcnew System::Windows::Forms::DateTimePicker());
			this->checkBoxDiabetiker = (gcnew System::Windows::Forms::CheckBox());
			this->buttonSpeichern = (gcnew System::Windows::Forms::Button());
			this->tabControl1->SuspendLayout();
			this->tabPage1->SuspendLayout();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->splitContainer1))->BeginInit();
			this->splitContainer1->Panel1->SuspendLayout();
			this->splitContainer1->Panel2->SuspendLayout();
			this->splitContainer1->SuspendLayout();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->dataGridViewKuchen))->BeginInit();
			this->tableLayoutPanel1->SuspendLayout();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownAnzahl))->BeginInit();
			this->SuspendLayout();
			// 
			// tabControl1
			// 
			this->tabControl1->Controls->Add(this->tabPage1);
			this->tabControl1->Dock = System::Windows::Forms::DockStyle::Fill;
			this->tabControl1->Location = System::Drawing::Point(0, 0);
			this->tabControl1->Name = L"tabControl1";
			this->tabControl1->SelectedIndex = 0;
			this->tabControl1->Size = System::Drawing::Size(661, 340);
			this->tabControl1->TabIndex = 0;
			// 
			// tabPage1
			// 
			this->tabPage1->Controls->Add(this->splitContainer1);
			this->tabPage1->Location = System::Drawing::Point(4, 22);
			this->tabPage1->Name = L"tabPage1";
			this->tabPage1->Padding = System::Windows::Forms::Padding(3);
			this->tabPage1->Size = System::Drawing::Size(653, 314);
			this->tabPage1->TabIndex = 0;
			this->tabPage1->Text = L"Kuchen";
			this->tabPage1->UseVisualStyleBackColor = true;
			// 
			// splitContainer1
			// 
			this->splitContainer1->Dock = System::Windows::Forms::DockStyle::Fill;
			this->splitContainer1->Location = System::Drawing::Point(3, 3);
			this->splitContainer1->Name = L"splitContainer1";
			// 
			// splitContainer1.Panel1
			// 
			this->splitContainer1->Panel1->Controls->Add(this->dataGridViewKuchen);
			// 
			// splitContainer1.Panel2
			// 
			this->splitContainer1->Panel2->Controls->Add(this->tableLayoutPanel1);
			this->splitContainer1->Size = System::Drawing::Size(647, 308);
			this->splitContainer1->SplitterDistance = 405;
			this->splitContainer1->TabIndex = 0;
			// 
			// dataGridViewKuchen
			// 
			dataGridViewCellStyle1->BackColor = System::Drawing::Color::Gainsboro;
			this->dataGridViewKuchen->AlternatingRowsDefaultCellStyle = dataGridViewCellStyle1;
			this->dataGridViewKuchen->AutoSizeColumnsMode = System::Windows::Forms::DataGridViewAutoSizeColumnsMode::Fill;
			this->dataGridViewKuchen->AutoSizeRowsMode = System::Windows::Forms::DataGridViewAutoSizeRowsMode::AllCells;
			this->dataGridViewKuchen->ColumnHeadersHeightSizeMode = System::Windows::Forms::DataGridViewColumnHeadersHeightSizeMode::AutoSize;
			this->dataGridViewKuchen->Dock = System::Windows::Forms::DockStyle::Fill;
			this->dataGridViewKuchen->EditMode = System::Windows::Forms::DataGridViewEditMode::EditProgrammatically;
			this->dataGridViewKuchen->Location = System::Drawing::Point(0, 0);
			this->dataGridViewKuchen->MultiSelect = false;
			this->dataGridViewKuchen->Name = L"dataGridViewKuchen";
			this->dataGridViewKuchen->SelectionMode = System::Windows::Forms::DataGridViewSelectionMode::FullRowSelect;
			this->dataGridViewKuchen->Size = System::Drawing::Size(405, 308);
			this->dataGridViewKuchen->TabIndex = 0;
			this->dataGridViewKuchen->SelectionChanged += gcnew System::EventHandler(this, &FormMain::selectionChanged);
			// 
			// tableLayoutPanel1
			// 
			this->tableLayoutPanel1->ColumnCount = 2;
			this->tableLayoutPanel1->ColumnStyles->Add((gcnew System::Windows::Forms::ColumnStyle()));
			this->tableLayoutPanel1->ColumnStyles->Add((gcnew System::Windows::Forms::ColumnStyle()));
			this->tableLayoutPanel1->Controls->Add(this->labelID, 0, 0);
			this->tableLayoutPanel1->Controls->Add(this->textBoxID, 1, 0);
			this->tableLayoutPanel1->Controls->Add(this->textBoxAnbieter, 1, 1);
			this->tableLayoutPanel1->Controls->Add(this->textBoxBeschreibung, 1, 2);
			this->tableLayoutPanel1->Controls->Add(this->labelAnbieter, 0, 1);
			this->tableLayoutPanel1->Controls->Add(this->labelBeschreibung, 0, 2);
			this->tableLayoutPanel1->Controls->Add(this->labelSorte, 0, 3);
			this->tableLayoutPanel1->Controls->Add(this->labelAbgabedatum, 0, 4);
			this->tableLayoutPanel1->Controls->Add(this->labelAnzahl, 0, 5);
			this->tableLayoutPanel1->Controls->Add(this->comboBoxSorte, 1, 3);
			this->tableLayoutPanel1->Controls->Add(this->numericUpDownAnzahl, 1, 5);
			this->tableLayoutPanel1->Controls->Add(this->labelDiabetiker, 0, 7);
			this->tableLayoutPanel1->Controls->Add(this->dateTimePickerAbgabe, 1, 4);
			this->tableLayoutPanel1->Controls->Add(this->checkBoxDiabetiker, 1, 7);
			this->tableLayoutPanel1->Controls->Add(this->buttonSpeichern, 1, 9);
			this->tableLayoutPanel1->Dock = System::Windows::Forms::DockStyle::Fill;
			this->tableLayoutPanel1->Location = System::Drawing::Point(0, 0);
			this->tableLayoutPanel1->Name = L"tableLayoutPanel1";
			this->tableLayoutPanel1->RowCount = 10;
			this->tableLayoutPanel1->RowStyles->Add((gcnew System::Windows::Forms::RowStyle()));
			this->tableLayoutPanel1->RowStyles->Add((gcnew System::Windows::Forms::RowStyle()));
			this->tableLayoutPanel1->RowStyles->Add((gcnew System::Windows::Forms::RowStyle()));
			this->tableLayoutPanel1->RowStyles->Add((gcnew System::Windows::Forms::RowStyle()));
			this->tableLayoutPanel1->RowStyles->Add((gcnew System::Windows::Forms::RowStyle()));
			this->tableLayoutPanel1->RowStyles->Add((gcnew System::Windows::Forms::RowStyle()));
			this->tableLayoutPanel1->RowStyles->Add((gcnew System::Windows::Forms::RowStyle()));
			this->tableLayoutPanel1->RowStyles->Add((gcnew System::Windows::Forms::RowStyle()));
			this->tableLayoutPanel1->RowStyles->Add((gcnew System::Windows::Forms::RowStyle()));
			this->tableLayoutPanel1->RowStyles->Add((gcnew System::Windows::Forms::RowStyle(System::Windows::Forms::SizeType::Absolute, 20)));
			this->tableLayoutPanel1->Size = System::Drawing::Size(238, 308);
			this->tableLayoutPanel1->TabIndex = 0;
			// 
			// labelID
			// 
			this->labelID->Anchor = System::Windows::Forms::AnchorStyles::Left;
			this->labelID->AutoSize = true;
			this->labelID->Location = System::Drawing::Point(3, 6);
			this->labelID->Name = L"labelID";
			this->labelID->Size = System::Drawing::Size(18, 13);
			this->labelID->TabIndex = 0;
			this->labelID->Text = L"ID";
			// 
			// textBoxID
			// 
			this->textBoxID->Enabled = false;
			this->textBoxID->Location = System::Drawing::Point(82, 3);
			this->textBoxID->Name = L"textBoxID";
			this->textBoxID->Size = System::Drawing::Size(142, 20);
			this->textBoxID->TabIndex = 1;
			// 
			// textBoxAnbieter
			// 
			this->textBoxAnbieter->Location = System::Drawing::Point(82, 29);
			this->textBoxAnbieter->Name = L"textBoxAnbieter";
			this->textBoxAnbieter->Size = System::Drawing::Size(142, 20);
			this->textBoxAnbieter->TabIndex = 1;
			// 
			// textBoxBeschreibung
			// 
			this->textBoxBeschreibung->Location = System::Drawing::Point(82, 55);
			this->textBoxBeschreibung->Name = L"textBoxBeschreibung";
			this->textBoxBeschreibung->Size = System::Drawing::Size(142, 20);
			this->textBoxBeschreibung->TabIndex = 1;
			// 
			// labelAnbieter
			// 
			this->labelAnbieter->Anchor = System::Windows::Forms::AnchorStyles::Left;
			this->labelAnbieter->AutoSize = true;
			this->labelAnbieter->Location = System::Drawing::Point(3, 32);
			this->labelAnbieter->Name = L"labelAnbieter";
			this->labelAnbieter->Size = System::Drawing::Size(46, 13);
			this->labelAnbieter->TabIndex = 0;
			this->labelAnbieter->Text = L"Anbieter";
			// 
			// labelBeschreibung
			// 
			this->labelBeschreibung->Anchor = System::Windows::Forms::AnchorStyles::Left;
			this->labelBeschreibung->AutoSize = true;
			this->labelBeschreibung->Location = System::Drawing::Point(3, 58);
			this->labelBeschreibung->Name = L"labelBeschreibung";
			this->labelBeschreibung->Size = System::Drawing::Size(72, 13);
			this->labelBeschreibung->TabIndex = 0;
			this->labelBeschreibung->Text = L"Beschreibung";
			// 
			// labelSorte
			// 
			this->labelSorte->Anchor = System::Windows::Forms::AnchorStyles::Left;
			this->labelSorte->AutoSize = true;
			this->labelSorte->Location = System::Drawing::Point(3, 85);
			this->labelSorte->Name = L"labelSorte";
			this->labelSorte->Size = System::Drawing::Size(32, 13);
			this->labelSorte->TabIndex = 0;
			this->labelSorte->Text = L"Sorte";
			// 
			// labelAbgabedatum
			// 
			this->labelAbgabedatum->Anchor = System::Windows::Forms::AnchorStyles::Left;
			this->labelAbgabedatum->AutoSize = true;
			this->labelAbgabedatum->Location = System::Drawing::Point(3, 111);
			this->labelAbgabedatum->Name = L"labelAbgabedatum";
			this->labelAbgabedatum->Size = System::Drawing::Size(73, 13);
			this->labelAbgabedatum->TabIndex = 0;
			this->labelAbgabedatum->Text = L"Abgabedatum";
			// 
			// labelAnzahl
			// 
			this->labelAnzahl->Anchor = System::Windows::Forms::AnchorStyles::Left;
			this->labelAnzahl->AutoSize = true;
			this->labelAnzahl->Location = System::Drawing::Point(3, 137);
			this->labelAnzahl->Name = L"labelAnzahl";
			this->labelAnzahl->Size = System::Drawing::Size(39, 13);
			this->labelAnzahl->TabIndex = 0;
			this->labelAnzahl->Text = L"Anzahl";
			// 
			// comboBoxSorte
			// 
			this->comboBoxSorte->FormattingEnabled = true;
			this->comboBoxSorte->Location = System::Drawing::Point(82, 81);
			this->comboBoxSorte->Name = L"comboBoxSorte";
			this->comboBoxSorte->Size = System::Drawing::Size(142, 21);
			this->comboBoxSorte->TabIndex = 2;
			// 
			// numericUpDownAnzahl
			// 
			this->numericUpDownAnzahl->Location = System::Drawing::Point(82, 134);
			this->numericUpDownAnzahl->Name = L"numericUpDownAnzahl";
			this->numericUpDownAnzahl->Size = System::Drawing::Size(142, 20);
			this->numericUpDownAnzahl->TabIndex = 6;
			// 
			// labelDiabetiker
			// 
			this->labelDiabetiker->Anchor = System::Windows::Forms::AnchorStyles::Left;
			this->labelDiabetiker->AutoSize = true;
			this->labelDiabetiker->Location = System::Drawing::Point(3, 162);
			this->labelDiabetiker->Name = L"labelDiabetiker";
			this->labelDiabetiker->Size = System::Drawing::Size(73, 13);
			this->labelDiabetiker->TabIndex = 7;
			this->labelDiabetiker->Text = L"Fr Diabetiker";
			// 
			// dateTimePickerAbgabe
			// 
			this->dateTimePickerAbgabe->Format = System::Windows::Forms::DateTimePickerFormat::Custom;
			this->dateTimePickerAbgabe->Location = System::Drawing::Point(82, 108);
			this->dateTimePickerAbgabe->Name = L"dateTimePickerAbgabe";
			this->dateTimePickerAbgabe->Size = System::Drawing::Size(142, 20);
			this->dateTimePickerAbgabe->TabIndex = 5;
			// 
			// checkBoxDiabetiker
			// 
			this->checkBoxDiabetiker->AutoSize = true;
			this->checkBoxDiabetiker->Location = System::Drawing::Point(82, 160);
			this->checkBoxDiabetiker->Name = L"checkBoxDiabetiker";
			this->checkBoxDiabetiker->Size = System::Drawing::Size(67, 17);
			this->checkBoxDiabetiker->TabIndex = 4;
			this->checkBoxDiabetiker->Text = L"geeignet";
			this->checkBoxDiabetiker->UseVisualStyleBackColor = true;
			// 
			// buttonSpeichern
			// 
			this->buttonSpeichern->Anchor = System::Windows::Forms::AnchorStyles::None;
			this->buttonSpeichern->Location = System::Drawing::Point(122, 232);
			this->buttonSpeichern->Name = L"buttonSpeichern";
			this->buttonSpeichern->Size = System::Drawing::Size(72, 23);
			this->buttonSpeichern->TabIndex = 3;
			this->buttonSpeichern->Text = L"Speichern";
			this->buttonSpeichern->UseVisualStyleBackColor = true;
			this->buttonSpeichern->Click += gcnew System::EventHandler(this, &FormMain::update);
			// 
			// FormMain
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->BackColor = System::Drawing::SystemColors::Window;
			this->BackgroundImageLayout = System::Windows::Forms::ImageLayout::None;
			this->ClientSize = System::Drawing::Size(661, 340);
			this->Controls->Add(this->tabControl1);
			this->Name = L"FormMain";
			this->Text = L"Kuchen SQL Server Test";
			this->FormClosing += gcnew System::Windows::Forms::FormClosingEventHandler(this, &FormMain::formWirdGeschlossen);
			this->tabControl1->ResumeLayout(false);
			this->tabPage1->ResumeLayout(false);
			this->splitContainer1->Panel1->ResumeLayout(false);
			this->splitContainer1->Panel2->ResumeLayout(false);
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->splitContainer1))->EndInit();
			this->splitContainer1->ResumeLayout(false);
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->dataGridViewKuchen))->EndInit();
			this->tableLayoutPanel1->ResumeLayout(false);
			this->tableLayoutPanel1->PerformLayout();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownAnzahl))->EndInit();
			this->ResumeLayout(false);

		}
#pragma endregion

		
private: 
	Void formWirdGeschlossen(System::Object^  sender, System::Windows::Forms::FormClosingEventArgs^  e) 
	{
		dbAssistent->closeDataBase();
	}

private: 
	Void selectionChanged(System::Object^  sender, System::EventArgs^  e) 
	{
		int kuchenID;
		aktKuchen = gcnew Kuchen();

		if (dataGridViewKuchen->SelectedRows->Count > 0)
		{
			Object^ idobj =	dataGridViewKuchen->SelectedRows[0]->Cells["ID"]->Value;

			if (idobj != DBNull::Value)
			{
				kuchenID = Convert::ToInt32(idobj->ToString());
				textBoxID->Text = kuchenID.ToString();
				aktKuchen->id = kuchenID;
			}
			else
			{
				textBoxID->Text = "DBNull";
			}
			
			dbAssistent->getKuchen(aktKuchen);

			comboBoxSorte->DataSource = dbAssistent->getSortenList();
			comboBoxSorte->SelectedIndex = aktKuchen->sorte;

			textBoxAnbieter->Text = aktKuchen->anbieter;
			textBoxBeschreibung->Text = aktKuchen->beschreibung;
			
			numericUpDownAnzahl->Value = aktKuchen->anzahl;

			dateTimePickerAbgabe->CustomFormat = "dd.MMM.yyy HH:mm:ss";
			dateTimePickerAbgabe->Value = Convert::ToDateTime(aktKuchen->abgabedatum);

			checkBoxDiabetiker->Checked = aktKuchen->diabetikergeeignet;
		}
	}

	private: System::Void update(System::Object^  sender, System::EventArgs^  e)
	{
		 aktKuchen = gcnew Kuchen;

		 aktKuchen->id = Convert::ToInt32(dataGridViewKuchen->SelectedRows[0]->Cells["ID"]->Value->ToString());

		 aktKuchen->anbieter = textBoxAnbieter->Text;
		 aktKuchen->beschreibung = textBoxBeschreibung->Text;

		 aktKuchen->sorte = comboBoxSorte->SelectedIndex;

		 aktKuchen->anzahl = Convert::ToInt32(numericUpDownAnzahl->Value);
		 aktKuchen->abgabedatum = Convert::ToDateTime(dateTimePickerAbgabe->Value);

		 aktKuchen->diabetikergeeignet = checkBoxDiabetiker->Checked;
		 
		 dbAssistent->updateKuchen(aktKuchen);

		 dataGridViewKuchen->DataSource = dbAssistent->getKuchenTabelle(); 
	}
};
}