using namespace System;
using namespace System::Windows::Forms;

public ref class Bestellung
{
private:
	int id;
	int gaesteid;
	int kuchenid;
	DateTime^ datum;
	int menge;
	bool bezahlt;
	DateTime^ timestamp;

public:
	property int Id
	{
		int get()
		{
			return this->id;
		}

		void set(int id)
		{
			this->id = id;
		}
	}

	property int GaesteId
	{
		int get()
		{
			return this->gaesteid;
		}

		void set(int gaesteid)
		{
			this->gaesteid = gaesteid;
		}
	}

	property int KuchenId
	{
		int get()
		{
			return this->kuchenid;
		}

		void set(int kuchenid)
		{
			this->kuchenid = kuchenid;
		}
	}

	property DateTime^ Datum
	{
		DateTime^ get()
		{
			return this->datum;
		}

		void set(DateTime^ datum)
		{
			this->datum = datum;
		}
	}

	property int Menge
	{
		int get()
		{
			return this->menge;
		}

		void set(int menge)
		{
			this->menge = menge;
		}
	}

	property bool Bezahlt
	{
		bool get()
		{
			return this->bezahlt;
		}

		void set(bool bezahlt)
		{
			this->bezahlt = bezahlt;
		}
	}

	property DateTime^ Timestamp
	{
		DateTime^ get()
		{
			return this->timestamp;
		}
	}

	Bestellung(int id, int gaesteid, int kuchenid, DateTime^ datum, int menge, bool bezahlt)
		:id(id),
		gaesteid(gaesteid),
		kuchenid(kuchenid),
		datum(datum),
		menge(menge),
		bezahlt(bezahlt)
	{
		this->timestamp = DateTime::Now;
	}

	Bestellung(String^ bestellungInformation)
	{
		array<String^>^ kompletteListe = bestellungInformation->Split(';');

		if (!Int32::TryParse(kompletteListe[0], id))
		{
			id = 0;
		}

		GaesteId = Int32::Parse(kompletteListe[1]);
		KuchenId = Int32::Parse(kompletteListe[2]);
		Datum = DateTime::Parse(kompletteListe[3]);
		Menge = Int32::Parse(kompletteListe[4]);
		Bezahlt = Boolean::Parse(kompletteListe[5]);

		//beim Laden sollte der Timestamp absichtlich nicht erneuert werden!
		timestamp = DateTime::Parse(kompletteListe[6]);
	}

	Bestellung()
	{
		this->timestamp = DateTime::Now;
	}

	~Bestellung()
	{

	}

	void change(Bestellung^ aktBestellung)
	{
		this->GaesteId = aktBestellung->GaesteId;
		this->KuchenId = aktBestellung->KuchenId;
		this->Datum = aktBestellung->Datum;
		this->Menge = aktBestellung->Menge;
		this->Bezahlt = aktBestellung->Bezahlt;
		this->timestamp = DateTime::Now;
	}

	String^ gesamt()
	{
		String^ temp;
		temp = Id.ToString() + ";" +
			GaesteId.ToString() + ";" +
			KuchenId.ToString() + ";" +
			Datum->ToString() + ";" +
			Menge.ToString() + ";" +
			Bezahlt.ToString() + ";" +
			Timestamp->ToString();

		return temp;
	}
};
