using namespace System;
using namespace System::Collections;
using namespace System::Collections::Generic;
using namespace System::IO;
using namespace System::Text;
using namespace System::Data;
#include "Bestellung.h"

public ref class BestellungenM
{
private:
	List<Bestellung^>^ bestellungenListe;
	String^ eingabeDateiname = "bestellungen.csv";
	String^ ausgabeDateiname = "bestellungen.csv";

	int getAutoID()
	{
		int id = 1;
		for each (Bestellung^ tempbestellung in bestellungenListe)
		{
			if (tempbestellung->Id >= id)
			{
				id = tempbestellung->Id + 1;
			}
		}
		return id;
	}

public:
	BestellungenM()
	{
		bestellungenListe = gcnew List<Bestellung^>;

		lesen();
	}

	~BestellungenM()
	{
		speichern();
	}

	void setInfos(Bestellung^ aktbestellung)
	{
		for each (Bestellung^ tempbestellung in bestellungenListe)
		{
			if (tempbestellung->Id == aktbestellung->Id)
			{
				tempbestellung->change(aktbestellung);
				break;
			}
		}
	}

	Bestellung^ getInfos(int aktid)
	{
		for each (Bestellung^ tempbestellung in bestellungenListe)
		{
			if (tempbestellung->Id == aktid)
			{
				return tempbestellung;
			}
		}
		return nullptr;
	}

	DataTable^ getTabelle()
	{
		DataTable^ bestellungenTabelle = gcnew DataTable();

		bestellungenTabelle->Columns->Add("ID", Type::GetType("System.Int32"));
		bestellungenTabelle->Columns->Add("gaesteID", Type::GetType("System.Int32"));
		bestellungenTabelle->Columns->Add("kuchenID", Type::GetType("System.Int32"));
		bestellungenTabelle->Columns->Add("datum", Type::GetType("System.DateTime"));
		bestellungenTabelle->Columns->Add("timestamp", Type::GetType("System.DateTime"));

		DataRow^ tabellenZeile;

		for each (Bestellung^ tempbestellung in bestellungenListe)
		{
			tabellenZeile = bestellungenTabelle->NewRow();
			tabellenZeile["ID"] = tempbestellung->Id;
			tabellenZeile["gaesteID"] = tempbestellung->GaesteId;
			tabellenZeile["kuchenID"] = tempbestellung->KuchenId;
			tabellenZeile["datum"] = tempbestellung->Datum;
			tabellenZeile["timestamp"] = tempbestellung->Timestamp;

			bestellungenTabelle->Rows->Add(tabellenZeile);
		}

		return bestellungenTabelle;
	}

	DataTable^ getTabelle(String^ suchmaske)
	{
		DataTable^ bestellungenTabelle = gcnew DataTable();

		bestellungenTabelle->Columns->Add("ID", Type::GetType("System.Int32"));
		bestellungenTabelle->Columns->Add("gaesteID", Type::GetType("System.Int32"));
		bestellungenTabelle->Columns->Add("kuchenID", Type::GetType("System.Int32"));
		bestellungenTabelle->Columns->Add("datum", Type::GetType("System.DateTime"));
		bestellungenTabelle->Columns->Add("timestamp", Type::GetType("System.DateTime"));

		DataRow^ tabellenZeile;

		for each (Bestellung^ tempbestellung in bestellungenListe)
		{
			// wenn der Suchstring irgendwie vorkommt?
			// das schliet einen leeren Suchstring implizit mit ein
			if (tempbestellung->gesamt()->Contains(suchmaske))
			{
				tabellenZeile = bestellungenTabelle->NewRow();
				tabellenZeile["ID"] = tempbestellung->Id;
				tabellenZeile["gaesteID"] = tempbestellung->GaesteId;
				tabellenZeile["kuchenID"] = tempbestellung->KuchenId;
				tabellenZeile["datum"] = tempbestellung->Datum;
				tabellenZeile["timestamp"] = tempbestellung->Timestamp;

				bestellungenTabelle->Rows->Add(tabellenZeile);
			}
		}

		return bestellungenTabelle;
	}

	property List<Bestellung^>^ BestellungenListe
	{
		List<Bestellung^>^ get()
		{
			return bestellungenListe;
		}
	}

	void add(Bestellung^ aktbestellung)
	{
		bestellungenListe->Add(aktbestellung);
	}

	void del(int aktid)
	{
		Bestellung^ loeschbestellung;
		bool existbestellung = false;

		for each (Bestellung^ tempbestellung in bestellungenListe)
		{
			if (tempbestellung->Id == aktid)
			{
				existbestellung = true;
				loeschbestellung = tempbestellung;
				break;
			}
		}
		if (existbestellung)
		{
			bestellungenListe->Remove(loeschbestellung);
		}
	}

	void neu(Bestellung^ aktbestellung)
	{
		//da das Feld ID "zu" ist, kommt bewut keine ID aus der Maske
		aktbestellung->Id = getAutoID();
		//die anderen Felder werden leer initialisiert
		aktbestellung->GaesteId = 0;
		aktbestellung->KuchenId = 0;
		aktbestellung->Datum = DateTime(2000, 1, 1);
		aktbestellung->Menge = 0;
		aktbestellung->Bezahlt = false;

		bestellungenListe->Add(aktbestellung);
	}

	void lesen()
	{
		StreamReader^ streamreader;
		String^ zeile;
		Bestellung^ tempbestellung;

		bestellungenListe->Clear();

		try
		{
			streamreader = gcnew StreamReader(eingabeDateiname);

			while (zeile = streamreader->ReadLine())
			{
				if (zeile->Length > 0)
				{
					tempbestellung = gcnew Bestellung(zeile);
					add(tempbestellung);
				}
			}

			streamreader->Close();
		}

		catch (Exception^ e)
		{
			MessageBox::Show(e->Message);
		}

		finally
		{
			delete streamreader;
		}
	}

	void speichern()
	{
		StreamWriter^ streamwriter;
		String^ zeile;

		try
		{
			streamwriter = gcnew StreamWriter(ausgabeDateiname);

			for each(Bestellung^ tempbestellung in bestellungenListe)
			{
				zeile = tempbestellung->gesamt();
				streamwriter->WriteLine(zeile);
			}

			streamwriter->Close();
		}

		catch (Exception^ e)
		{
			MessageBox::Show(e->Message);
		}

		finally
		{
			delete streamwriter;
		}
	}
};