using namespace System;
using namespace System::Collections;
using namespace System::Collections::Generic;
using namespace System::IO;
using namespace System::Text;
using namespace System::Data;
#include "Gast.h"

public ref class GaesteM
{
private:
	List<Gast^>^ gaesteListe;
	String^ eingabeDateiname = "gaeste.csv";
	String^ ausgabeDateiname = "gaeste.csv";

	int getAutoID()
	{
		int id = 1;
		for each (Gast^ tempgast in gaesteListe)
		{
			if (tempgast->Id >= id)
			{
				id = tempgast->Id + 1;
			}
		}
		return id;
	}

public:
	GaesteM()
	{
		gaesteListe = gcnew List<Gast^>;

		lesen();
	}

	~GaesteM()
	{
		speichern();
	}

	void setInfos(Gast^ aktGast)
	{
		for each (Gast^ tempgast in gaesteListe)
		{
			if (tempgast->Id == aktGast->Id)
			{
				tempgast->change(aktGast);
				break;
			}
		}
	}

	Gast^ getInfos(int aktid)
	{
		for each (Gast^ tempgast in gaesteListe)
		{
			if (tempgast->Id == aktid)
			{
				return tempgast;
			}
		}
		return nullptr;
	}

	DataTable^ getTabelle()
	{
		DataTable^ gaesteTabelle = gcnew DataTable();

		gaesteTabelle->Columns->Add("ID", Type::GetType("System.Int32"));
		gaesteTabelle->Columns->Add("name", Type::GetType("System.String"));
		gaesteTabelle->Columns->Add("vorname", Type::GetType("System.String"));
		gaesteTabelle->Columns->Add("timestamp", Type::GetType("System.DateTime"));

		DataRow^ tabellenZeile;

		for each (Gast^ tempgast in gaesteListe)
		{
			tabellenZeile = gaesteTabelle->NewRow();
			tabellenZeile["ID"] = tempgast->Id;
			tabellenZeile["name"] = tempgast->Name;
			tabellenZeile["vorname"] = tempgast->Vorname;
			tabellenZeile["timestamp"] = tempgast->Timestamp;

			gaesteTabelle->Rows->Add(tabellenZeile);
		}

		return gaesteTabelle;
	}

	DataTable^ getTabelle(String^ suchmaske)
	{
		DataTable^ gaesteTabelle = gcnew DataTable();

		gaesteTabelle->Columns->Add("ID", Type::GetType("System.Int32"));
		gaesteTabelle->Columns->Add("name", Type::GetType("System.String"));
		gaesteTabelle->Columns->Add("vorname", Type::GetType("System.String"));
		gaesteTabelle->Columns->Add("timestamp", Type::GetType("System.DateTime"));

		DataRow^ tabellenZeile;

		for each (Gast^ tempgast in gaesteListe)
		{
			// wenn der Suchstring irgendwie vorkommt?
			// das schliet einen leeren Suchstring implizit mit ein
			if (tempgast->gesamt()->Contains(suchmaske))
			{
				tabellenZeile = gaesteTabelle->NewRow();
				tabellenZeile["ID"] = tempgast->Id;
				tabellenZeile["name"] = tempgast->Name;
				tabellenZeile["vorname"] = tempgast->Vorname;
				tabellenZeile["timestamp"] = tempgast->Timestamp;

				gaesteTabelle->Rows->Add(tabellenZeile);
			}
		}

		return gaesteTabelle;
	}

	property List<Gast^>^ GaesteListe
	{
		List<Gast^>^ get()
		{
			return gaesteListe;
		}
	}

	void add(Gast^ aktgast)
	{
		gaesteListe->Add(aktgast);
	}

	void del(int aktid)
	{
		Gast^ loeschenGast;
		bool existGast = false;

		for each (Gast^ tempgast in gaesteListe)
		{
			if (tempgast->Id == aktid)
			{
				existGast = true;
				loeschenGast = tempgast;
				break;
			}
		}
		if (existGast)
		{
			gaesteListe->Remove(loeschenGast);
		}
	}

	void neu(Gast^ aktGast)
	{
		//da das Feld ID "zu" ist, kommt bewut keine ID aus der Maske
		aktGast->Id = getAutoID();
		gaesteListe->Add(aktGast);
	}

	void lesen()
	{
		StreamReader^ streamreader;
		String^ zeile;
		Gast^ tempGast;

		gaesteListe->Clear();

		try
		{
			streamreader = gcnew StreamReader(eingabeDateiname);

			while (zeile = streamreader->ReadLine())
			{
				if (zeile->Length > 0)
				{
					tempGast = gcnew Gast(zeile);
					add(tempGast);
				}
			}

			streamreader->Close();
		}

		catch (Exception^ e)
		{
			MessageBox::Show(e->Message);
		}

		finally
		{
			delete streamreader;
		}
	}

	void speichern()
	{
		StreamWriter^ streamwriter;
		String^ zeile;

		try
		{
			streamwriter = gcnew StreamWriter(ausgabeDateiname);

			for each(Gast^ tempgast in gaesteListe)
			{
				zeile = tempgast->gesamt();
				streamwriter->WriteLine(zeile);
			}

			streamwriter->Close();
		}

		catch (Exception^ e)
		{
			MessageBox::Show(e->Message);
		}

		finally
		{
			delete streamwriter;
		}
	}
};
