using namespace System;
using namespace System::Windows::Forms;

public ref class Kuchen
{
private:
	int id;
	String^ anbieter;
	String^ sorte;
	String^ beschreibung;
	int anzahl;
	DateTime^ abgabedatum;
	bool diabetikergeeignet;
	DateTime^ timestamp;

public:
	property int Id
	{
		int get()
		{
			return this->id;
		}

		void set(int id)
		{
			this->id = id;
		}
	}

	property String^ Anbieter
	{
		String^ get()
		{
			return this->anbieter;
		}

		void set(String^ anbieter)
		{
			this->anbieter = anbieter;
		}
	}

	property String^ Sorte
	{
		String^ get()
		{
			return this->sorte;
		}

		void set(String^ sorte)
		{
			this->sorte = sorte;
		}
	}

	property String^ Beschreibung
	{
		String^ get()
		{
			return this->beschreibung;
		}

		void set(String^ beschreibung)
		{
			this->beschreibung = beschreibung;
		}
	}

	property int Anzahl
	{
		int get()
		{
			return this->anzahl;
		}

		void set(int anzahl)
		{
			this->anzahl = anzahl;
		}
	}

	property DateTime^ Abgabedatum
	{
		DateTime^ get()
		{
			return this->abgabedatum;
		}

		void set(DateTime^ abgabedatum)
		{
			this->abgabedatum = abgabedatum;
		}
	}

	property bool Diabetikergeeignet
	{
		bool get()
		{
			return this->diabetikergeeignet;
		}

		void set(bool diabetikergeeignet)
		{
			this->diabetikergeeignet = diabetikergeeignet;
		}
	}

	property DateTime^ Timestamp
	{
		DateTime^ get()
		{
			return this->timestamp;
		}
	}

	Kuchen(int id, String^ anbieter, String^ sorte, String^ beschreibung, int anzahl, DateTime^ abgabedatum, bool diabetikergeeignet)
		:id(id),
		anbieter(anbieter),
		sorte(sorte),
		beschreibung(beschreibung),
		anzahl(anzahl),
		abgabedatum(abgabedatum),
		diabetikergeeignet(diabetikergeeignet)
	{
		this->timestamp = DateTime::Now;
	}

	Kuchen(String^ kuchenInformation)
	{
		array<String^>^ kompletteListe = kuchenInformation->Split(';');

		if (!Int32::TryParse(kompletteListe[0], id))
		{
			id = 0;
		}

		Anbieter = kompletteListe[1];
		Sorte = kompletteListe[2];
		Beschreibung = kompletteListe[3];
		Anzahl = Int32::Parse(kompletteListe[4]);
		Abgabedatum = DateTime::Parse(kompletteListe[5]);
		Diabetikergeeignet = Boolean::Parse(kompletteListe[6]);

		//beim Laden sollte der Timestamp absichtlich nicht erneuert werden!
		timestamp = DateTime::Parse(kompletteListe[7]);
	}

	Kuchen()
	{
		this->timestamp = DateTime::Now;
	}

	~Kuchen()
	{

	}

	void change(Kuchen^ aktKuchen)
	{
		this->Anbieter = aktKuchen->Anbieter;
		this->Sorte = aktKuchen->Sorte;
		this->Beschreibung = aktKuchen->Beschreibung;
		this->Anzahl = aktKuchen->Anzahl;
		this->Abgabedatum = aktKuchen->Abgabedatum;
		this->Diabetikergeeignet = aktKuchen->Diabetikergeeignet;
		this->timestamp = DateTime::Now;
	}

	String^ gesamt()
	{
		String^ temp;
		temp = Id.ToString() + ";" +
			Anbieter + ";" +
			Sorte + ";" +
			Beschreibung + ";" +
			Anzahl.ToString() + ";" +
			Abgabedatum->ToString() + ";" +
			Diabetikergeeignet.ToString() + ";" +
			Timestamp->ToString();

		return temp;
	}
};
