#pragma once
#ifndef _IKUCHENBASAR
#include "IKuchenBasar.h"
#endif

namespace KuchenBasar {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;

	public ref class KuchenWerte : public System::Windows::Forms::Form
	{
	private:
		IKuchenBasar^ kuchenBasarIntern;
		KuchenM^ kuchenVerwaltungIntern;
		Kuchen^ aktKuchen;

	public:
		KuchenWerte(IKuchenBasar^ kuchenbasar, KuchenM^ kuchenverwaltung)
		{
			InitializeComponent();

			kuchenBasarIntern = kuchenbasar;
			kuchenVerwaltungIntern = kuchenverwaltung;

			aktKuchen = kuchenVerwaltungIntern->getInfos(kuchenbasar->AktKuchenID);

			textBoxAnbieter->Text = aktKuchen->Anbieter;
			textBoxSorte->Text = aktKuchen->Sorte;
			textBoxBeschreibung->Text = aktKuchen->Beschreibung;
	
			numericUpDownAnzahl->Value = Convert::ToInt32(aktKuchen->Anzahl);

			dateTimePickerAbgabedatum->CustomFormat = "dd.MMM.yyyy, HH:mm:ss";
			dateTimePickerAbgabedatum->Value = Convert::ToDateTime(aktKuchen->Abgabedatum);

			checkBoxDiabetikergeeignet->Checked = aktKuchen->Diabetikergeeignet;
		}

	protected:
		/// <summary>
		/// Verwendete Ressourcen bereinigen.
		/// </summary>
		~KuchenWerte()
		{
			if (components)
			{
				delete components;
			}
		}

	private: System::Windows::Forms::Button^  buttonSpeichern;
	private: System::Windows::Forms::Button^  buttonAbbruch;
	private: System::Windows::Forms::NumericUpDown^  numericUpDownAnzahl;
	private: System::Windows::Forms::Label^  labelAnzahl;
	private: System::Windows::Forms::TextBox^  textBoxAnbieter;

	private: System::Windows::Forms::TextBox^  textBoxSorte;
	private: System::Windows::Forms::TextBox^  textBoxBeschreibung;
	private: System::Windows::Forms::DateTimePicker^  dateTimePickerAbgabedatum;
	private: System::Windows::Forms::CheckBox^  checkBoxDiabetikergeeignet;

	private: System::Windows::Forms::Label^  labelAnbieter;
	private: System::Windows::Forms::Label^  labelSorte;
	private: System::Windows::Forms::Label^  labelBeschreibung;
	private: System::Windows::Forms::Label^  labelAbgabedatum;

	private:
		/// <summary>
		/// Erforderliche Designervariable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung.
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		void InitializeComponent(void)
		{
			this->buttonSpeichern = (gcnew System::Windows::Forms::Button());
			this->buttonAbbruch = (gcnew System::Windows::Forms::Button());
			this->numericUpDownAnzahl = (gcnew System::Windows::Forms::NumericUpDown());
			this->labelAnzahl = (gcnew System::Windows::Forms::Label());
			this->textBoxAnbieter = (gcnew System::Windows::Forms::TextBox());
			this->textBoxSorte = (gcnew System::Windows::Forms::TextBox());
			this->textBoxBeschreibung = (gcnew System::Windows::Forms::TextBox());
			this->dateTimePickerAbgabedatum = (gcnew System::Windows::Forms::DateTimePicker());
			this->labelAnbieter = (gcnew System::Windows::Forms::Label());
			this->labelSorte = (gcnew System::Windows::Forms::Label());
			this->labelBeschreibung = (gcnew System::Windows::Forms::Label());
			this->labelAbgabedatum = (gcnew System::Windows::Forms::Label());
			this->checkBoxDiabetikergeeignet = (gcnew System::Windows::Forms::CheckBox());
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownAnzahl))->BeginInit();
			this->SuspendLayout();
			// 
			// buttonSpeichern
			// 
			this->buttonSpeichern->Location = System::Drawing::Point(540, 59);
			this->buttonSpeichern->Name = L"buttonSpeichern";
			this->buttonSpeichern->Size = System::Drawing::Size(165, 43);
			this->buttonSpeichern->TabIndex = 0;
			this->buttonSpeichern->Text = L"Speichern";
			this->buttonSpeichern->UseVisualStyleBackColor = true;
			this->buttonSpeichern->Click += gcnew System::EventHandler(this, &KuchenWerte::buttonSpeichern_Click);
			// 
			// buttonAbbruch
			// 
			this->buttonAbbruch->Location = System::Drawing::Point(540, 264);
			this->buttonAbbruch->Name = L"buttonAbbruch";
			this->buttonAbbruch->Size = System::Drawing::Size(165, 40);
			this->buttonAbbruch->TabIndex = 1;
			this->buttonAbbruch->Text = L"Abbruch";
			this->buttonAbbruch->UseVisualStyleBackColor = true;
			this->buttonAbbruch->Click += gcnew System::EventHandler(this, &KuchenWerte::buttonAbbruch_Click);
			// 
			// numericUpDownAnzahl
			// 
			this->numericUpDownAnzahl->Location = System::Drawing::Point(164, 276);
			this->numericUpDownAnzahl->Name = L"numericUpDownAnzahl";
			this->numericUpDownAnzahl->Size = System::Drawing::Size(203, 20);
			this->numericUpDownAnzahl->TabIndex = 2;
			// 
			// labelAnzahl
			// 
			this->labelAnzahl->AutoSize = true;
			this->labelAnzahl->Location = System::Drawing::Point(62, 283);
			this->labelAnzahl->Name = L"labelAnzahl";
			this->labelAnzahl->Size = System::Drawing::Size(39, 13);
			this->labelAnzahl->TabIndex = 5;
			this->labelAnzahl->Text = L"Anzahl";
			// 
			// textBoxAnbieter
			// 
			this->textBoxAnbieter->Location = System::Drawing::Point(164, 31);
			this->textBoxAnbieter->Name = L"textBoxAnbieter";
			this->textBoxAnbieter->Size = System::Drawing::Size(203, 20);
			this->textBoxAnbieter->TabIndex = 6;
			// 
			// textBoxSorte
			// 
			this->textBoxSorte->Location = System::Drawing::Point(165, 100);
			this->textBoxSorte->Name = L"textBoxSorte";
			this->textBoxSorte->Size = System::Drawing::Size(202, 20);
			this->textBoxSorte->TabIndex = 7;
			// 
			// textBoxBeschreibung
			// 
			this->textBoxBeschreibung->Location = System::Drawing::Point(164, 160);
			this->textBoxBeschreibung->Name = L"textBoxBeschreibung";
			this->textBoxBeschreibung->Size = System::Drawing::Size(201, 20);
			this->textBoxBeschreibung->TabIndex = 8;
			// 
			// dateTimePickerAbgabedatum
			// 
			this->dateTimePickerAbgabedatum->CustomFormat = L"dd.MMM.yyyy, HH:mm:ss";
			this->dateTimePickerAbgabedatum->Format = System::Windows::Forms::DateTimePickerFormat::Custom;
			this->dateTimePickerAbgabedatum->Location = System::Drawing::Point(162, 219);
			this->dateTimePickerAbgabedatum->Name = L"dateTimePickerAbgabedatum";
			this->dateTimePickerAbgabedatum->Size = System::Drawing::Size(203, 20);
			this->dateTimePickerAbgabedatum->TabIndex = 9;
			// 
			// labelAnbieter
			// 
			this->labelAnbieter->AutoSize = true;
			this->labelAnbieter->Location = System::Drawing::Point(54, 38);
			this->labelAnbieter->Name = L"labelAnbieter";
			this->labelAnbieter->Size = System::Drawing::Size(46, 13);
			this->labelAnbieter->TabIndex = 10;
			this->labelAnbieter->Text = L"Anbieter";
			// 
			// labelSorte
			// 
			this->labelSorte->AutoSize = true;
			this->labelSorte->Location = System::Drawing::Point(68, 103);
			this->labelSorte->Name = L"labelSorte";
			this->labelSorte->Size = System::Drawing::Size(32, 13);
			this->labelSorte->TabIndex = 11;
			this->labelSorte->Text = L"Sorte";
			// 
			// labelBeschreibung
			// 
			this->labelBeschreibung->AutoSize = true;
			this->labelBeschreibung->Location = System::Drawing::Point(28, 167);
			this->labelBeschreibung->Name = L"labelBeschreibung";
			this->labelBeschreibung->Size = System::Drawing::Size(72, 13);
			this->labelBeschreibung->TabIndex = 12;
			this->labelBeschreibung->Text = L"Beschreibung";
			// 
			// labelAbgabedatum
			// 
			this->labelAbgabedatum->AutoSize = true;
			this->labelAbgabedatum->Location = System::Drawing::Point(28, 226);
			this->labelAbgabedatum->Name = L"labelAbgabedatum";
			this->labelAbgabedatum->Size = System::Drawing::Size(73, 13);
			this->labelAbgabedatum->TabIndex = 13;
			this->labelAbgabedatum->Text = L"Abgabedatum";
			// 
			// checkBoxDiabetikergeeignet
			// 
			this->checkBoxDiabetikergeeignet->AutoSize = true;
			this->checkBoxDiabetikergeeignet->Location = System::Drawing::Point(162, 326);
			this->checkBoxDiabetikergeeignet->Name = L"checkBoxDiabetikergeeignet";
			this->checkBoxDiabetikergeeignet->Size = System::Drawing::Size(118, 17);
			this->checkBoxDiabetikergeeignet->TabIndex = 14;
			this->checkBoxDiabetikergeeignet->Text = L"Diabetiker geeignet";
			this->checkBoxDiabetikergeeignet->UseVisualStyleBackColor = true;
			// 
			// KuchenWerte
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->BackColor = System::Drawing::SystemColors::Window;
			this->ClientSize = System::Drawing::Size(806, 388);
			this->Controls->Add(this->checkBoxDiabetikergeeignet);
			this->Controls->Add(this->labelAbgabedatum);
			this->Controls->Add(this->labelBeschreibung);
			this->Controls->Add(this->labelSorte);
			this->Controls->Add(this->labelAnbieter);
			this->Controls->Add(this->dateTimePickerAbgabedatum);
			this->Controls->Add(this->textBoxBeschreibung);
			this->Controls->Add(this->textBoxSorte);
			this->Controls->Add(this->textBoxAnbieter);
			this->Controls->Add(this->labelAnzahl);
			this->Controls->Add(this->numericUpDownAnzahl);
			this->Controls->Add(this->buttonAbbruch);
			this->Controls->Add(this->buttonSpeichern);
			this->Name = L"KuchenWerte";
			this->Text = L"KuchenWerte";
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownAnzahl))->EndInit();
			this->ResumeLayout(false);
			this->PerformLayout();

		}
#pragma endregion
	private:
		Void buttonAbbruch_Click(Object^  sender, EventArgs^  e)
		{
			this->Close();
		}

		Void buttonSpeichern_Click(Object^  sender, EventArgs^  e)
		{
			aktKuchen->Id = kuchenBasarIntern->AktKuchenID;
			
			aktKuchen->Anbieter = textBoxAnbieter->Text;
			aktKuchen->Sorte = textBoxSorte->Text;
			aktKuchen->Beschreibung = textBoxBeschreibung->Text;
			aktKuchen->Anzahl = Convert::ToInt32(numericUpDownAnzahl->Value);
		
			//wieder Entfernen des Custom Format Kommas
			String^ tempAbgabedatum = dateTimePickerAbgabedatum->Text->Replace(',', ' ');
			aktKuchen->Abgabedatum = Convert::ToDateTime(tempAbgabedatum);

			aktKuchen->Diabetikergeeignet = checkBoxDiabetikergeeignet->Checked;

			kuchenVerwaltungIntern->setInfos(aktKuchen);

			this->Close();
		}
	};
}
