using System.Data;
using System.Data.OleDb;
using System.Data.SqlClient;
using System;
using System.Collections.Generic;

public class DBAssistent
{
	OleDbConnection verbindung;
//	SqlConnection verbindungSQL;

	OleDbCommand sqlabfrage;
//	SqlCommand sqlabfrageSQL;

	KuchenDB kuchenDB;
	SortenDB sortenDB;

	void initVerbindung()
	{
		verbindung = new OleDbConnection();
		verbindung.ConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source = Kuchenbasar.mdb";
		verbindung.Open();

		sqlabfrage = new OleDbCommand();
		sqlabfrage.Connection = verbindung;
	}

    /*	void initVerbindungSQL()
	{
		verbindungSQL = new SqlConnection();
		verbindungSQL.ConnectionString = "";
		verbindungSQL.Open();

		sqlabfrageSQL = new SqlCommand();
		sqlabfrageSQL.Connection = verbindung;
	}
    */

	public DBAssistent()
	{
		initVerbindung();

		kuchenDB = new KuchenDB(sqlabfrage);
		sortenDB = new SortenDB(sqlabfrage);
	}

	~DBAssistent()
	{
	}

	public DataTable getKuchenTabelle()
	{
		return kuchenDB.getTable();
	}

    public List<String> getSortenList()
	{
		return sortenDB.getList();
	}

    public String getSortenname(int kuchenid)
	{
		int fkId = kuchenDB.getSorte(kuchenid);
		return sortenDB.getBackwarenSorte(fkId);
	}

    public void closeDataBase()
	{
		verbindung.Close();
//		verbindungSQL.Close();
	}

    public void updateKuchen(Kuchen aktkuchen)
	{
		kuchenDB.update(aktkuchen);
	}

    public void getKuchen(Kuchen aktkuchen)
	{
		kuchenDB.get(aktkuchen);
	}
};