using System;
using System.Windows.Forms;

public class Bestellung
{
	int id;
	int gaesteid;
	int kuchenid;
	DateTime bestelldatum;
	int menge;
	double gesamtpreis;
	bool bezahlt;
	bool geliefert;
	DateTime letzterzugriff;

    public int Id
    {
        get
        {
            return id;
        }

        set
        {
            id = value;
        }
    }

    public int GaesteId
    {
        get
        {
            return gaesteid;
        }

        set
        {
            gaesteid = value;
        }
    }
    
    public int KuchenId
    {
        get
        {
            return kuchenid;
        }

        set
        {
            kuchenid = value;
        }
    }

	public DateTime Bestelldatum
	{
        get
        {
			return bestelldatum;
		}

		set
		{
			bestelldatum = value;
		}
	}

	public int Menge
	{
		get
        {
			return menge;
		}

		set
		{
			menge = value;
		}
	}

	public double Gesamtpreis
	{
		get
		{
			return gesamtpreis;
		}

		set
		{
			gesamtpreis = value;
		}
	}

	public bool Bezahlt
	{
		get
		{
			return bezahlt;
		}

		set
		{
			bezahlt = value;
		}
	}

	public bool Geliefert
	{
		get
		{
			return geliefert;
		}

		set
		{
			geliefert = value;
		}
	}

	public DateTime Letzterzugriff
	{
		get
        {
			return letzterzugriff;
		}

		set
		{
			letzterzugriff = value;
		}
	}

	public Bestellung(int id, int gaesteid, int kuchenid, DateTime bestelldatum, int menge, double gesamtpreis, bool bezahlt, bool geliefert)
    {
        this.id = id;
        this.gaesteid = gaesteid;
        this.kuchenid = kuchenid;
        this.bestelldatum = bestelldatum;
        this.menge = menge;
        this.gesamtpreis = gesamtpreis;
        this.bezahlt = bezahlt;
        this.geliefert = geliefert;
		Letzterzugriff = DateTime.Now;
	}

	public Bestellung(String bestellungInformation)
	{
		String[] kompletteListe = bestellungInformation.Split(';');

		if (! Int32.TryParse(kompletteListe[0],out id))
		{
			id = 0;
		}

		GaesteId = Int32.Parse(kompletteListe[1]);
		KuchenId = Int32.Parse(kompletteListe[2]);
		Bestelldatum = DateTime.Parse(kompletteListe[3]);
		Menge = Int32.Parse(kompletteListe[4]);
		Gesamtpreis = Double.Parse(kompletteListe[5]);
		Bezahlt = Boolean.Parse(kompletteListe[6]);
		Geliefert = Boolean.Parse(kompletteListe[7]);

		//beim Laden sollte der Timestamp absichtlich nicht erneuert werden!
		Letzterzugriff = DateTime.Parse(kompletteListe[8]);
	}

	public Bestellung()
	{
		Letzterzugriff = DateTime.Now;
	}

	~Bestellung()
	{

	}

	void change(Bestellung aktBestellung)
	{
		this.GaesteId = aktBestellung.GaesteId;
		this.KuchenId = aktBestellung.KuchenId;
		this.Bestelldatum = aktBestellung.Bestelldatum;
		this.Menge = aktBestellung.Menge;
		this.Gesamtpreis = aktBestellung.Gesamtpreis;
		this.Bezahlt = aktBestellung.Bezahlt;
		this.Geliefert = aktBestellung.Geliefert;
		this.Letzterzugriff = DateTime.Now;
	}

	String gesamt()
	{
		String temp;
		temp = Id.ToString() + ";" +
			GaesteId.ToString() + ";" +
			KuchenId.ToString() + ";" +
			Bestelldatum.ToString() + ";" +
			Menge.ToString() + ";" +
			Gesamtpreis.ToString() + ";" +
			Bezahlt.ToString() + ";" +
			Geliefert.ToString() + ";" +
			Letzterzugriff.ToString();

		return temp;
	}
};
