﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace KuchenAccess11
{
    public partial class KuchenWerte : Form
    {
		IKuchenBasar kuchenBasar;
		DBAssistent dbAssistent;
        Kuchen aktKuchen;

    	public KuchenWerte(IKuchenBasar kuchenBasarForm, DBAssistent dbAssistentForm)
		{
			InitializeComponent();

			kuchenBasar = kuchenBasarForm;
			dbAssistent = dbAssistentForm;

			if (kuchenBasar.AktKuchenID < 0)
			{
				aktKuchen = new Kuchen(-1, "", 0, "neuer Kuchen", "", DateTime.Now, 0, 0.0, false);
			}
			else
			{
				aktKuchen = dbAssistent.getKuchen(kuchenBasar.AktKuchenID);
			}

			textBoxAnbieter.Text = aktKuchen.Anbieter;
			textBoxKurzName.Text = aktKuchen.Kurzkuchen;
			textBoxBeschreibung.Text = aktKuchen.Beschreibung;

			comboBoxSorte.DataSource = dbAssistent.getSortenList();
			comboBoxSorte.SelectedIndex = aktKuchen.Sorte;

			numericUpDownAnzahl.Value = Convert.ToInt32(aktKuchen.Anzahl);
			numericUpDownPreis.Value = Convert.ToDecimal(aktKuchen.Preis);

			dateTimePickerAbgabedatum.CustomFormat = "dd.MMM.yyyy, HH:mm:ss";
			dateTimePickerAbgabedatum.Value = Convert.ToDateTime(aktKuchen.Abgabedatum);

			checkBoxDiabetikergeeignet.Checked = aktKuchen.Diabetikergeeignet;
		}

        public KuchenWerte()
        {
            InitializeComponent();
        }

        bool komplexePlausis()
		{
			if (textBoxAnbieter.Text.Length == 0)
			{
				MessageBox.Show("Anbieter muß gefüllt werden");
				return false;
			}

			if (textBoxKurzName.Text.Length == 0)
			{
				MessageBox.Show("Kurzname muß gefüllt werden");
				return false;
			}

			if (comboBoxSorte.SelectedIndex == 0)
			{
				MessageBox.Show("keine gültige Kuchensorte");
				return false;
			}

			if (numericUpDownAnzahl.Value == 0)
			{
				MessageBox.Show("Anzahl darf nicht 0 sein");
				return false;
			}

			if (Convert.ToDouble(numericUpDownPreis.Value) < 0.1)
			{
				MessageBox.Show("Preis darf nicht 0.00 sein");
				return false;
			}

			return true;
		}

		public void buttonAbbruch_Click(Object  sender, EventArgs e)
		{
			this.Close();
		}

		public void buttonSpeichern_Click(Object  sender, EventArgs e)
		{
			if (! komplexePlausis())
			{
				//MessageBox.Show("mind. ein Feld war nicht korrekt gefüllt");
			}
			else
			{
				aktKuchen.Anbieter = textBoxAnbieter.Text;
				aktKuchen.Beschreibung = textBoxBeschreibung.Text;
				aktKuchen.Kurzkuchen = textBoxKurzName.Text;

				aktKuchen.Sorte = comboBoxSorte.SelectedIndex;

				aktKuchen.Anzahl = Convert.ToInt32(numericUpDownAnzahl.Value);
				aktKuchen.Preis = Convert.ToDouble(numericUpDownPreis.Value);

				//wieder Entfernen des Custom Format Kommas
				String tempAbgabedatum = dateTimePickerAbgabedatum.Text.Replace(',', ' ');
				aktKuchen.Abgabedatum = Convert.ToDateTime(tempAbgabedatum);

				aktKuchen.Diabetikergeeignet = checkBoxDiabetikergeeignet.Checked;

				if (kuchenBasar.AktKuchenID < 0)
				{
					int neuKuchenID = dbAssistent.insertKuchen(aktKuchen);
					kuchenBasar.AktKuchenID = neuKuchenID;
				}
				else
				{
					aktKuchen.Id = kuchenBasar.AktKuchenID;
					dbAssistent.updateKuchen(aktKuchen);
				}

				this.Close();
			}
		}

    
    }
}

/*
			this->buttonSpeichern->Click += gcnew System::EventHandler(this, &KuchenWerte::buttonSpeichern_Click);
	
            this->buttonAbbruch->Click += gcnew System::EventHandler(this, &KuchenWerte::buttonAbbruch_Click);

  */
