﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace KuchenBasar
{
    public partial class FormMain : Form , IKuchenBasar
    {
        int aktGaesteID;
        int aktKuchenID;
        int aktBestellungenID;

        DBAssistent dbAssistent;

        public virtual int AktGaesteID
        {
            get
            {
                return aktGaesteID;
            }

            set
            {
                aktGaesteID = value;
            }
        }

        public virtual int AktKuchenID
        {
            get
            {
                return aktKuchenID;
            }

            set
            {
                aktKuchenID = value;
            }
        }

        public virtual int AktBestellungenID
        {
            get
            {
                return aktBestellungenID;
            }

            set
            {
                aktBestellungenID = value;
            }
        }

        public FormMain()
        {
			InitializeComponent();

			dbAssistent = new DBAssistent();

			aktGaesteID = 0;
			aktKuchenID = 0;
			aktBestellungenID = 0;

			refreshGaesteDaten();
			refreshKuchenDaten();
			refreshBestellungenDaten();
        }

        int bestimmeDataGridViewZeile(DataGridView aktDataGridView, int aktID)
		{
			Object tempObjID;
			int tempID;

			//aktID == 0 heißt, es ist keine ID aktiv, soll aber die erste aktiviert werden
			if (aktID == 0)
			{
				return 0;
			}

			//aktID == -1 heißt, es ist keine ID aktiv, soll aber die letzte aktiviert werden
			int anzahl = aktDataGridView.Rows.Count;

			if (aktID < 0)
			{
				return anzahl - 1;
			}

			//Suche die Zeile, wo die ID drin steht
			for (int i = 0; i < anzahl; i++)
			{
				tempObjID = aktDataGridView.Rows[i].Cells["ID"].Value;
				if (tempObjID != null)
				{
					tempID = Convert.ToInt32(tempObjID.ToString());
					if (tempID == aktID)
					{
						return i;
					}
				}
			}

			//nicht gefunden . erste Zeile
			return 0;
		}

		int bestimmeDataGridViewIndex(DataGridView aktDataGridView)
		{
			int tempID = 0;
			Object tempObjID = aktDataGridView.SelectedRows[0].Cells["ID"].Value;
			if (tempObjID != null)
			{
				tempID = Convert.ToInt32(tempObjID.ToString());
			}
			
			return tempID;
		}
	
		//Bestellungen
		void refreshBestellungenDaten()
		{
			int retteMich = aktBestellungenID;

			if (checkBoxBestellungenFiltern.Checked)
			{
				String suchmaske = textBoxBestellungenFiltern.Text;
				dataGridViewBestellungen.DataSource = dbAssistent.getBestellungenTabelle(suchmaske);
			}
			else
			{
				dataGridViewBestellungen.DataSource = dbAssistent.getBestellungenTabelle();
			}

			dataGridViewBestellungen.Columns["ID"].Visible = false;

			aktBestellungenID = retteMich;

			int aktZeile = bestimmeDataGridViewZeile(dataGridViewBestellungen, aktBestellungenID);

			if (dataGridViewBestellungen.RowCount > 0)
			{
				//da Cells[0] = ID unsichtbar ist, nehmen wir die nächste
				dataGridViewBestellungen.CurrentCell = dataGridViewBestellungen.Rows[aktZeile].Cells[1];
			}
			else
			{
				schliessenBestellungenBoxen();
			}
		}

		void oeffnenBestellungenBoxen()
		{
			comboBoxBestellungenGaesteID.Enabled = true;
			comboBoxBestellungenKuchenID.Enabled = true;
			numericUpDownBestellungenMenge.ReadOnly = false;
			numericUpDownBestellungenPreis.ReadOnly = false;
			dateTimePickerBestellungenDatum.Enabled = true;
			checkBoxBestellungenBezahlt.Enabled = true;
			checkBoxBestellungenGeliefert.Enabled = true;

			buttonBestellungenSpeichern.Enabled = true;
			buttonBestellungenLoeschen.Enabled = true;
		}

		void schliessenBestellungenBoxen()
		{
			comboBoxBestellungenGaesteID.SelectedIndex = 0;
			comboBoxBestellungenKuchenID.SelectedIndex = 0;
			numericUpDownBestellungenMenge.Value = 0;
			numericUpDownBestellungenPreis.Value = 0;
			dateTimePickerBestellungenDatum.Value = new DateTime(2000, 1, 1);
			checkBoxBestellungenBezahlt.Checked = false;
			checkBoxBestellungenGeliefert.Checked = false;

			comboBoxBestellungenGaesteID.Enabled = false;
			comboBoxBestellungenKuchenID.Enabled = false;
			numericUpDownBestellungenMenge.ReadOnly = true;
			numericUpDownBestellungenPreis.ReadOnly = true;
			dateTimePickerBestellungenDatum.Enabled = false;
			checkBoxBestellungenBezahlt.Enabled = false;
			checkBoxBestellungenGeliefert.Enabled = false;

			buttonBestellungenSpeichern.Enabled = false;
			buttonBestellungenLoeschen.Enabled = false;
		}

		void selectBestellungenElement_Click(Object sender, EventArgs e)
		{
			if (dataGridViewBestellungen.SelectedRows.Count > 0)
			{
				aktBestellungenID = bestimmeDataGridViewIndex(dataGridViewBestellungen);

				Bestellung tempBestellung = dbAssistent.getBestellung(aktBestellungenID);
				if (tempBestellung != null)
				{
					if (dbAssistent.changedKuchenList())
					{
						//Die Liste kann sich ändern, die Combobox bekommt das aber sonst nicht mit
						comboBoxBestellungenKuchenID.DataSource = null;
						comboBoxBestellungenKuchenID.DataSource = dbAssistent.getKuchenList();
					}

					//Wenn die KuchenListe aktuell ist, ist (jetzt erst) auch das Dictionary aktuell
					//Da im Key(ID) der Access Datenbank wegen des Autowertes Lücken sein können,
					//beim Index der Combobox aber natürlich nicht, wird das hier und in der Speichern-Methode
					//repariert (umgesetzt durch eben zwei spiegelbildlichen Dictionary)

					int tempKuchenID = tempBestellung.KuchenId;
					int tempKuchenIndex = dbAssistent.IndexFromIdKuchen(tempKuchenID);

					if (comboBoxBestellungenKuchenID.SelectedIndex != tempKuchenIndex)
					{
						comboBoxBestellungenKuchenID.SelectedIndex = tempKuchenIndex;
					}

					if (dbAssistent.changedGaesteList())
					{
						//Die Liste kann sich ändern, die Combobox bekommt das aber sonst nicht mit
						comboBoxBestellungenGaesteID.DataSource = null;
						comboBoxBestellungenGaesteID.DataSource = dbAssistent.getGaesteList();
					}
		
					//Da auch im Key(ID) der Gaeste Lücken sein können,
					//gilt hier das gleiche Verfahren mit der Umsetzung ID.Index
					
					int tempGaesteID = tempBestellung.GaesteId;
					int tempGaesteIndex = dbAssistent.IndexFromIdGaeste(tempGaesteID);

					if (comboBoxBestellungenGaesteID.SelectedIndex != tempGaesteIndex)
					{
						comboBoxBestellungenGaesteID.SelectedIndex = tempGaesteIndex;
					}

					dateTimePickerBestellungenDatum.CustomFormat = "dd.MMM.yyyy, HH:mm:ss";
					dateTimePickerBestellungenDatum.Text = tempBestellung.Bestelldatum.ToString();

					//Lese erstmal aus der Bestellung, setze die Box zurück von eventuell anderen Kuchen
					numericUpDownBestellungenMenge.Maximum = 10000000;
					numericUpDownBestellungenMenge.Value = Convert.ToInt32(tempBestellung.Menge);
		
					//aktualisiere ggf. mit dem Vorrat, kein Kuchenwechsel
					setzeBestellungenMenge(tempKuchenID, false);

					numericUpDownBestellungenPreis.Value = Convert.ToDecimal(tempBestellung.Gesamtpreis);

					checkBoxBestellungenBezahlt.Checked = tempBestellung.Bezahlt;
					checkBoxBestellungenGeliefert.Checked = tempBestellung.Geliefert;
				}

				oeffnenBestellungenBoxen();
			}
		}

		bool komplexePlausisBestellungen()
		{
			if (comboBoxBestellungenGaesteID.SelectedIndex == 0)
			{
				MessageBox.Show("kein gültiger Gast");
				return false;
			}

			if (comboBoxBestellungenKuchenID.SelectedIndex == 0)
			{
				MessageBox.Show("kein gültiger Kuchen");
				return false;
			}

			//Daß an dieser Stelle gültige GaesteID/KuchenID existieren, können wir annehmen, weil die ComboBoxen den Test schon bestanden haben
			int tempGaesteIndex = comboBoxBestellungenGaesteID.SelectedIndex;
			int tempKuchenIndex = comboBoxBestellungenKuchenID.SelectedIndex;
			int tempGaesteID = dbAssistent.IdFromIndexGaeste(tempGaesteIndex);
			int tempKuchenID = dbAssistent.IdFromIndexKuchen(tempKuchenIndex);
	
			String tempGaesteName = comboBoxBestellungenGaesteID.SelectedItem.ToString();
			String tempKuchenName = comboBoxBestellungenKuchenID.SelectedItem.ToString();

			bool isVorhanden = false;
	
			//hier prüfen wir ob es sich um eine erstmalige Bestellung handelt (sonst würden wir uns selbst auch finden)
			//Die Werte in erstmaligeBestellung sind die gespeicherten, nicht die eingegebenen und zu prüfenden!
			Bestellung erstmaligeBestellung = dbAssistent.getBestellung(aktBestellungenID);
			if (erstmaligeBestellung.GaesteId == 0 || erstmaligeBestellung.KuchenId == 0)
			{
				isVorhanden = dbAssistent.vorhandenBestellung(tempGaesteID, tempKuchenID);
		    }

			if (isVorhanden)
			{
				MessageBox.Show("Gast: " + tempGaesteName + "\nhat schon den\nKuchen: " + tempKuchenName + " bestellt.\n\nBitte diese Bestellung ändern.");
				return false;
			}

			if (numericUpDownBestellungenMenge.Value == 0)
			{
				MessageBox.Show("Menge darf nicht 0 sein");
				return false;
			}

			if (numericUpDownBestellungenMenge.Value > numericUpDownBestellungenMenge.Maximum)
			{
				MessageBox.Show("Es sind nur noch " + numericUpDownBestellungenMenge.Maximum + " Stücke da");
				return false;
			}

			if (Convert.ToDouble(numericUpDownBestellungenPreis.Value) < 0.1)
			{
				MessageBox.Show("Preis darf nicht 0.00 sein");
				return false;
			}

			return true;
		}

		void setzeBestellungenMenge(int kuchenID, bool isKuchenWechsel)
		{
			int vorrat = dbAssistent.getVorratKuchen(kuchenID);
			int bisher = Convert.ToInt32(numericUpDownBestellungenMenge.Value);

			//es sind soviele möglich, wie vorrätig sind vom neuen oder gleichen Kuchen.
			int moeglich = vorrat;

			//plus, soviele wie wir jetzt schon haben, wenn der Kuchen gleich bleibt
			//(das Ausgleichen berücksichtigt das dann)
			if (! isKuchenWechsel)
			{
				moeglich = vorrat + bisher;
			}

			//der neue Kuchen erlaubt die Menge nicht
			if (bisher > moeglich)
			{
				bisher = moeglich;
			}

			//Setzen der aktuellen Werte, die auf jeden Fall gültig sind 
			//Damit die ComboBox nicht platzt, erst das Maximum, dann den Wert
			numericUpDownBestellungenMenge.Maximum = moeglich;
			numericUpDownBestellungenMenge.Value = bisher;
		}

		void comboBoxBestellungenKuchenID_SelectedIndexChanged(Object sender, EventArgs e)
		{
			if (comboBoxBestellungenKuchenID.SelectedIndex > 0)
			{
				int tempIndex = comboBoxBestellungenKuchenID.SelectedIndex;
				int tempID = dbAssistent.IdFromIndexKuchen(tempIndex);

				setzeBestellungenMenge(tempID, true);

				double preis = dbAssistent.getPreisKuchen(tempID);
				int anzahl = Convert.ToInt32(numericUpDownBestellungenMenge.Value);

				numericUpDownBestellungenPreis.Value = Convert.ToDecimal(anzahl * preis);
			}
		}

		void numericUpDownBestellungenMenge_ValueChanged(Object sender, EventArgs e)
		{
			int tempIndex = comboBoxBestellungenKuchenID.SelectedIndex;
			int tempID = dbAssistent.IdFromIndexKuchen(tempIndex);

			int anzahl = Convert.ToInt32(numericUpDownBestellungenMenge.Value);
			double preis = dbAssistent.getPreisKuchen(tempID);

			numericUpDownBestellungenPreis.Value = Convert.ToDecimal(anzahl * preis);
		}

		void buttonBestellungenSpeichern_Click(Object sender, EventArgs e)
		{
			if (!komplexePlausisBestellungen())
			{
				//MessageBox.Show("mind. ein Wert war nicht korrekt");
			}
			else
			{
				aktBestellungenID = bestimmeDataGridViewIndex(dataGridViewBestellungen);

				Bestellung aktBestellung = dbAssistent.getBestellung(aktBestellungenID);

				int tempKuchenIndex = comboBoxBestellungenKuchenID.SelectedIndex;
				int tempKuchenID = dbAssistent.IdFromIndexKuchen(tempKuchenIndex);

				int tempAlterKuchenID = aktBestellung.KuchenId;
				int tempAlterKuchenMenge = aktBestellung.Menge;

				aktBestellung.KuchenId = tempKuchenID;

				int tempGaesteIndex = comboBoxBestellungenGaesteID.SelectedIndex;
				int tempGaesteID = dbAssistent.IdFromIndexGaeste(tempGaesteIndex);

				aktBestellung.GaesteId = tempGaesteID;

				//wieder Entfernen des Custom Format Kommas
				String tempDatum = dateTimePickerBestellungenDatum.Text.Replace(',', ' ');
				aktBestellung.Bestelldatum = Convert.ToDateTime(tempDatum);

				aktBestellung.Menge = Convert.ToInt32(numericUpDownBestellungenMenge.Value);
				aktBestellung.Gesamtpreis = Convert.ToDouble(numericUpDownBestellungenPreis.Value);

				aktBestellung.Bezahlt = checkBoxBestellungenBezahlt.Checked;
				aktBestellung.Geliefert = checkBoxBestellungenGeliefert.Checked;

				//Der dbAssistent ruft hier neben dem Update auf die Bestellungen
				//intern noch die Aktualisierung der Vorratsmenge beim Kuchen auf!
				//Da mir aber für eine komplexe Umbuchung von altem Kuchen auf neuen Kuchen 
				//mit Trigger, in Access etwas die Ideen fehlen, habe ich auch aus Zeitgründen
				//die etwas komisch aussehende Steuerung über die FormMain akzeptiert 
				//dbAssistent.updateBestellung(aktBestellung);
				dbAssistent.updateBestellung(aktBestellung, tempAlterKuchenID, tempAlterKuchenMenge);

				refreshBestellungenDaten();
			}
		}

		void buttonBestellungenLoeschen_Click(Object sender, EventArgs e)
		{
			aktBestellungenID = bestimmeDataGridViewIndex(dataGridViewBestellungen);

			dbAssistent.deleteBestellung(aktBestellungenID);

			aktBestellungenID = 0;

			refreshBestellungenDaten();
		}

		void buttonBestellungenNeu_Click(Object sender, EventArgs e)
		{
			//Access zählt Autowerte standardmäßig ab 1, C++ hat als Indexbeginn 0
			//Beides scheint irgendwie sinnvoll
			//Um die Zusammenarbeit zu vereinfachen, wurden in den Basistabellen Zeilen mit Index 0
			//angelegt, die jedoch nur technische Inhalte haben und nicht angezeigt werden
			Bestellung aktBestellung = new Bestellung(-1, 0, 0, DateTime.Now, 0, 0.0, false, false);

			//Der dbAssistent ruft neben dem Insert auf die Bestellungen
			//intern noch die Aktualisierung der Vorratsmenge beim Kuchen auf!
			aktBestellungenID = dbAssistent.insertBestellung(aktBestellung);

			//das muß leider sein, weil sonst neue Sätze verloren gehen
			checkBoxBestellungenFiltern.Checked = false;
			AktBestellungenID = -1;
	
			refreshBestellungenDaten();
		}

		void checkBoxBestellungenFiltern_CheckedChanged(Object sender, EventArgs e)
		{
			//leider müssen wir hier die aktuellen Keys aufgeben, da die Suchmaske alles verändern kann
			aktBestellungenID = 0;

			if (checkBoxBestellungenFiltern.Checked)
			{
				textBoxBestellungenFiltern.Enabled = true;
			}
			else
			{
				textBoxBestellungenFiltern.Enabled = false;
			}

			refreshBestellungenDaten();
		}

		void textBoxBestellungenFiltern_TextChanged(Object sender, EventArgs e)
		{
			//leider müssen wir hier die aktuellen Keys aufgeben, da die Suchmaske alles verändern kann
			aktBestellungenID = 0;

			if (textBoxBestellungenFiltern.Text.Length == 0)
			{
				checkBoxBestellungenFiltern.Checked = false;
			}

			refreshBestellungenDaten();
		}

		//Kuchen
		void refreshKuchenDaten()
		{
			//int berndK1 = aktKuchenID;
			//int berndG1 = aktGaesteID;

			int retteMich = aktKuchenID;

			if (checkBoxKuchenFiltern.Checked)
			{
				String suchmaske = textBoxKuchenFiltern.Text;
				dataGridViewKuchen.DataSource = dbAssistent.getKuchenTabelle(suchmaske);
			}
			else
			{
				dataGridViewKuchen.DataSource = dbAssistent.getKuchenTabelle();
			}

			dataGridViewKuchen.Columns["ID"].Visible = false;

			//nach Löschen/Speichern/Neu soll möglichst auf dem aktuellen Satz positioniert sein
			//nach Löschen: am besten der erste
			//nach Neu: der letzte
			//nach Speichern: die gleiche ID
			//wegen des Filters ist aber erst jetzt klar, welche Zeile das sein kann...

			//ich habe keine Erklärung dafür, aber die aktGaesteID geht hier kapputt??? 
			//möglicherweise überschreibt das DataSource der dataGridView 
			//beim Modulwechsel die einfachen Variablen
			//int berndK2 = aktKuchenID;
			//int berndG2 = aktGaesteID;

			aktKuchenID = retteMich;

			int aktZeile = bestimmeDataGridViewZeile(dataGridViewKuchen, aktKuchenID);

			if (dataGridViewKuchen.RowCount > 0)
			{
				//da Cells[0] = ID unsichtbar ist, nehmen wir die nächste
				dataGridViewKuchen.CurrentCell = dataGridViewKuchen.Rows[aktZeile].Cells[1];
			}
			else
			{
				schliessenKuchenBoxen();
			}
		}

		void oeffnenKuchenBoxen()
		{
			buttonKuchenAendern.Enabled = true;
			buttonKuchenLoeschen.Enabled = true;
		}

		void schliessenKuchenBoxen()
		{
			textBoxKuchenAnbieter.Clear();
			textBoxKuchenSorte.Clear();
			textBoxKuchenKurzName.Clear();
			textBoxKuchenBeschreibung.Clear();
			textBoxKuchenAbgabedatum.Clear();
			textBoxKuchenAnzahl.Clear();
			textBoxKuchenPreis.Clear();
			textBoxKuchenBestellt.Clear();
			textBoxKuchenDiabetikergeeignet.Clear();

			buttonKuchenAendern.Enabled = false;
			buttonKuchenLoeschen.Enabled = false;
		}

		void selectKuchenElement_Click(Object sender, EventArgs e)
		{
			if (dataGridViewKuchen.SelectedRows.Count > 0)
			{
				aktKuchenID = bestimmeDataGridViewIndex(dataGridViewKuchen);

				Kuchen tempKuchen = dbAssistent.getKuchen(aktKuchenID);
				if (tempKuchen != null)
				{
					textBoxKuchenAnbieter.Text = tempKuchen.Anbieter;
					textBoxKuchenSorte.Text = dbAssistent.getSorte(aktKuchenID);
					textBoxKuchenKurzName.Text = tempKuchen.Kurzkuchen;
					textBoxKuchenBeschreibung.Text = tempKuchen.Beschreibung;
					textBoxKuchenAbgabedatum.Text = tempKuchen.Abgabedatum.ToString();
					textBoxKuchenAnzahl.Text = tempKuchen.Anzahl.ToString();
					textBoxKuchenBestellt.Text = Convert.ToString(dbAssistent.getKuchenBestellungenGesamt(AktKuchenID));
					textBoxKuchenPreis.Text = String.Format("{0:F2}", tempKuchen.Preis) + " €";
					if (tempKuchen.Diabetikergeeignet)
					{
						textBoxKuchenDiabetikergeeignet.Text = "Ja";
					}
					else
					{
						textBoxKuchenDiabetikergeeignet.Text = "Nein";
					}
				}

				oeffnenKuchenBoxen();
			}
		}

		void buttonKuchenAendern_Click(Object sender, EventArgs e)
		{
			aktKuchenID = bestimmeDataGridViewIndex(dataGridViewKuchen);

			KuchenWerte kuchenAendern = new KuchenWerte(this, dbAssistent);
			kuchenAendern.ShowDialog();

			refreshKuchenDaten();
		}

		void buttonKuchenLoeschen_Click(Object sender, EventArgs e)
		{
			aktKuchenID = bestimmeDataGridViewIndex(dataGridViewKuchen);

			dbAssistent.deleteKuchen(aktKuchenID);

			aktKuchenID = 0;

			refreshKuchenDaten();

			//Löschen von Kuchen könnte Auswirkungen auf bereits bestehende Bestellungen haben
			aktBestellungenID = 0;

			refreshBestellungenDaten();
		}

		void buttonKuchenNeu_Click(Object sender, EventArgs e)
		{
			//aktKuchenID = -1 heißt, daß die KuchenWerte Form einen neuen Kuchen anlegen soll
			aktKuchenID = -1;

			KuchenWerte kuchenNeu = new KuchenWerte(this, dbAssistent);
			kuchenNeu.ShowDialog();

			//das muß leider sein, weil sonst neue Sätze verloren gehen
			checkBoxKuchenFiltern.Checked = false;

			refreshKuchenDaten();
		}

		void checkBoxKuchenFiltern_CheckedChanged(Object sender, EventArgs e)
		{
			//leider müssen wir hier die aktuellen Keys aufgeben, da die Suchmaske alles verändern kann
			aktKuchenID = 0;

			if (checkBoxKuchenFiltern.Checked)
			{
				textBoxKuchenFiltern.Enabled = true;
			}
			else
			{
				textBoxKuchenFiltern.Enabled = false;
			}

			refreshKuchenDaten();
		}

		void textBoxKuchenFiltern_TextChanged(Object sender, EventArgs e)
		{
			//leider müssen wir hier die aktuellen Keys aufgeben, da die Suchmaske alles verändern kann
			aktKuchenID = 0;

			if (textBoxKuchenFiltern.Text.Length == 0)
			{
				checkBoxKuchenFiltern.Checked = false;
			}

			refreshKuchenDaten();
		}

		//Gaeste
		void refreshGaesteDaten()
		{
			int retteMich = aktGaesteID;

			if (checkBoxGaesteFiltern.Checked)
			{
				String suchmaske = textBoxGaesteFiltern.Text;
				dataGridViewGaeste.DataSource = dbAssistent.getGaesteTabelle(suchmaske);
			}
			else
			{
				dataGridViewGaeste.DataSource = dbAssistent.getGaesteTabelle();
			}

			dataGridViewGaeste.Columns["ID"].Visible = false;

			aktGaesteID = retteMich;

			int aktZeile = bestimmeDataGridViewZeile(dataGridViewGaeste, aktGaesteID);

			if (dataGridViewGaeste.RowCount > 0)
			{
				//da Cells[0] = ID unsichtbar ist, nehmen wir die nächste
				dataGridViewGaeste.CurrentCell = dataGridViewGaeste.Rows[aktZeile].Cells[1];
			}
			else
			{
				schliessenGaesteBoxen();
			}
		}

		void oeffnenGaesteBoxen()
		{
			buttonGaesteAendern.Enabled = true;
			buttonGaesteLoeschen.Enabled = true;
		}

		void schliessenGaesteBoxen()
		{
			textBoxGaesteName.Clear();
			textBoxGaesteVorname.Clear();
			textBoxGaesteKurzName.Clear();
			textBoxGaesteTelefon.Clear();
			textBoxGaesteEinrichtung.Clear();
		
			buttonGaesteAendern.Enabled = false;
			buttonGaesteLoeschen.Enabled = false;
		}

		void selectGaesteElement_Click(Object sender, EventArgs e)
		{
			if (dataGridViewGaeste.SelectedRows.Count > 0)
			{
				aktGaesteID = bestimmeDataGridViewIndex(dataGridViewGaeste);

				Gast tempGast = dbAssistent.getGaeste(aktGaesteID);
				if (tempGast != null)
				{
					textBoxGaesteName.Text = tempGast.Gastname;
					textBoxGaesteVorname.Text = tempGast.Vorname;
					textBoxGaesteKurzName.Text = tempGast.Kurzname;
					textBoxGaesteEinrichtung.Text = dbAssistent.getEinrichtung(aktGaesteID);
					textBoxGaesteTelefon.Text = tempGast.Telefon;
					textBoxGaesteBestellungen.Text = Convert.ToString(dbAssistent.getGaesteBestellungenGesamt(AktGaesteID));
				}

				oeffnenGaesteBoxen();
			}
		}

		void buttonGaesteAendern_Click(Object sender, EventArgs e)
		{
			aktGaesteID = bestimmeDataGridViewIndex(dataGridViewGaeste);

			GaesteWerte gaesteAendern = new GaesteWerte(this, dbAssistent);
			gaesteAendern.ShowDialog();

			refreshGaesteDaten();
		}

		void buttonGaesteLoeschen_Click(Object sender, EventArgs e)
		{
			aktGaesteID = bestimmeDataGridViewIndex(dataGridViewGaeste);

			dbAssistent.deleteGaeste(aktGaesteID);

			aktGaesteID = 0;

			refreshGaesteDaten();

			//Löschen von Gästen könnte Auswirkungen auf bereits bestehende Bestellungen haben
			aktBestellungenID = 0;

			refreshBestellungenDaten();
		}

		void buttonGaesteNeu_Click(Object sender, EventArgs e)
		{
			//aktGaesteID = -1 heißt, daß die GaesteWerte Form einen neuen Gast anlegen soll
			aktGaesteID = -1;

			GaesteWerte gaesteNeu = new GaesteWerte(this, dbAssistent);
			gaesteNeu.ShowDialog();

			//das muß leider sein, weil sonst neue Sätze verloren gehen
			checkBoxGaesteFiltern.Checked = false;

			refreshGaesteDaten();
		}

		void checkBoxGaesteFiltern_CheckedChanged(Object sender, EventArgs e)
		{
			//leider müssen wir hier die aktuellen Keys aufgeben, da die Suchmaske alles verändern kann
			aktGaesteID = 0;

			if (checkBoxGaesteFiltern.Checked)
			{
				textBoxGaesteFiltern.Enabled = true;
			}
			else
			{
				textBoxGaesteFiltern.Enabled = false;
			}

			refreshGaesteDaten();
		}

		void textBoxGaesteFiltern_TextChanged(Object sender, EventArgs e)
		{
			//leider müssen wir hier die aktuellen Keys aufgeben, da die Suchmaske alles verändern kann
			aktGaesteID = 0;

			if (textBoxGaesteFiltern.Text.Length == 0)
			{
				checkBoxGaesteFiltern.Checked = false;
			}

			refreshGaesteDaten();
		}

		//Menue
		void beendenToolStripMenuItem_Click(Object sender, EventArgs e)
		{
			Application.Exit();
		}

		void listeToolStripMenuItem_Click(Object sender, EventArgs e) 
		{
			KuchenBasarListe basarListe = new KuchenBasarListe(this, dbAssistent);
			basarListe.ShowDialog();
		}

		void FormMain_FormClosing(Object  sender, FormClosingEventArgs  e) 
		{
			 dbAssistent.closeDataBase();
		}

		void tabControl1_SelectedIndexChanged(Object sender, EventArgs e) 
		{
			switch (tabControl1.SelectedIndex)
			{
			case 0: 
				selectBestellungenElement_Click(new Object(), new EventArgs());
				refreshBestellungenDaten();
				break;
			case 1: 
				selectKuchenElement_Click(new Object(), new EventArgs());
				refreshKuchenDaten();
				break;
			case 2: 			
				selectGaesteElement_Click(new Object(), new EventArgs());
				refreshGaesteDaten();
				break;
			default:
				break;
			}
		}

		void infoToolStripMenuItem_Click(Object sender, EventArgs e) 
		{
			MessageBox.Show("Kuchen Basar\n\nAbschlußprojekt für den C++ Visual .NET Kurs\n\nBernd Schubert, Alfatraining Rostock\n\n24.11.-05.12.2014");
		}

    }
}