using System;
using System.Windows.Forms;

public class Gast
{
	int id;
	String gastname;
	String vorname;
	String kurzname;
	int einrichtung;
	String telefon;
	DateTime letzterzugriff;

	public int Id
	{
		get
		{
			return this.id;
		}

		set
		{
			this.id = value;
		}
	}

	public String Gastname
	{
		get
		{
			return this.gastname;
		}

		set
		{
            this.gastname = value;
		}
	}

	public String Vorname
	{
		get
		{
			return this.vorname;
		}

		set
		{
            this.vorname = value;
		}
	}
	public String Kurzname
	{
		get
		{
			return this.kurzname;
		}

		set
		{
            this.kurzname = value;
		}
	}

	public int Einrichtung
	{
		get
		{
			return this.einrichtung;
		}

		set
		{
            this.einrichtung = value;
		}
	}

	public String Telefon
	{
		get
		{
			return this.telefon;
		}

        set
		{
            this.telefon = value;
		}
	}

	public DateTime Letzterzugriff
	{
		get
		{
			return this.letzterzugriff;
		}
		
		set
		{
            this.letzterzugriff = value;
		}
	}

	public Gast(int id, String gastname, String vorname, String kurzname, int einrichtung, String telefon)
	{
		Id = id;
		Gastname = gastname;
		Vorname = vorname;
		Kurzname = kurzname;
		Einrichtung = einrichtung;
		Telefon = telefon;
		this.letzterzugriff = DateTime.Now;
	}

    Gast(String gastInformation)
	{
		String[] kompletteListe = gastInformation.Split(';');

		if (! Int32.TryParse(kompletteListe[0], out id))
		{
			id = 0;
		}

		Id = Int32.Parse(kompletteListe[1]);
		Gastname = kompletteListe[2];
		Vorname = kompletteListe[3];
		Kurzname = kompletteListe[4];
		Einrichtung = Int32.Parse(kompletteListe[5]);
		Telefon = kompletteListe[6];

		//beim Laden sollte der Timestamp absichtlich nicht erneuert werden!
		Letzterzugriff = DateTime.Parse(kompletteListe[7]);
	}


	public Gast()
	{
		this.letzterzugriff = DateTime.Now;
	}

	~Gast()
	{

	}

	void change(Gast aktGast)
	{
		this.Id = aktGast.Id;
		this.Gastname = aktGast.Gastname;
		this.Vorname = aktGast.Vorname;
		this.Kurzname = aktGast.Kurzname;
		this.Einrichtung = aktGast.Einrichtung;
		this.Telefon = aktGast.Telefon;
		this.Letzterzugriff = DateTime.Now;
	}

	String gesamt()
	{
		String temp;
		temp = Id.ToString() + ";" +
			Gastname + ";" +
			Vorname + ";" +
			Kurzname + ";" +
			Einrichtung.ToString() + ";" +
			Telefon + ";" +
			Letzterzugriff.ToString();

		return temp;
	}
};