﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace KuchenTest4
{
    public partial class FormMain : Form , IKuchenBasar
    {
		int aktGaesteID;
		int aktKuchenID;
		int aktBestellungenID;

		GaesteM gaesteverwaltung;
		KuchenM kuchenverwaltung;
        BestellungenM bestellungenverwaltung;
        
        public virtual int AktGaesteID
        {
            get
            {
                return aktGaesteID;
            }

            set
            {
                aktGaesteID = value;
            }

        }

        public virtual int AktKuchenID
        {
            get
            {
                return aktKuchenID;
            }

            set
            {
                aktKuchenID = value;
            }

        }

        public virtual int AktBestellungenID
        {
            get
            {
                return aktBestellungenID;
            }

            set
            {
                aktBestellungenID = value;
            }

        }
        
        public FormMain()
        {
			InitializeComponent();
			gaesteverwaltung = new GaesteM();
			kuchenverwaltung = new KuchenM();
			bestellungenverwaltung = new BestellungenM();

			aktGaesteID = 0;
			aktKuchenID = 0;
			aktBestellungenID = 0;

			initBestellungenBoxen();

			refreshGaesteDaten();
			refreshKuchenDaten();
			refreshBestellungenDaten();
        }

        int bestimmeDataGridViewZeile(DataGridView aktDataGridView, int aktID)
		{
			Object tempObjID;
			int tempID;

			//aktID == 0 heißt, es ist keine ID aktiv, soll aber die erste aktiviert werden
			if (aktID == 0)
			{
				return 0;
			}

			//aktID == -1 heißt, es ist keine ID aktiv, soll aber die letzte aktiviert werden
			int anzahl = aktDataGridView.Rows.Count;

			if (aktID < 0)
			{
				return anzahl - 1;
			}

			//Suche die Zeile, wo die ID drin steht
			for (int i = 0; i < anzahl; i++)
			{
				tempObjID = aktDataGridView.Rows[i].Cells["ID"].Value;
				if (tempObjID != null)
				{
					tempID = Convert.ToInt32(tempObjID.ToString());
					if (tempID == aktID)
					{
						return i;
					}
				}
			}

			//nicht gefunden . erste Zeile
			return 0;
		}

		//Kuchen
		void refreshKuchenDaten()
		{
			//int berndM1 = aktKuchenID;
			//int berndK1 = aktGaesteID;

			int retteMich = aktKuchenID;

			if (checkBoxKuchenFiltern.Checked)
			{
				String suchmaske = textBoxKuchenFiltern.Text;
				dataGridViewKuchen.DataSource = kuchenverwaltung.getTabelle(suchmaske);
			}
			else
			{
				dataGridViewKuchen.DataSource = kuchenverwaltung.getTabelle();
			}

			//nach Löschen/Speichern/Neu soll möglichst auf dem aktuellen Satz positioniert sein
			//nach Löschen: am besten der erste
			//nach Neu: der letzte
			//nach Speichern: die gleiche ID
			//wegen des Filters ist aber erst jetzt klar, welche Zeile das sein kann...

			//ich habe keine Erklärung dafür, aber die aktGaesteID geht hier kapputt??? 
			//möglicherweise überschreibt das DataSource der dataGridView 
			//beim Modulwechsel die einfachen Variablen
			//int berndM2 = aktKuchenID;
			//int berndK2 = aktGaesteID;

			aktKuchenID = retteMich;

			int aktZeile = bestimmeDataGridViewZeile(dataGridViewKuchen, aktKuchenID);

			if (aktZeile > 0 || aktKuchenID > 0 || dataGridViewKuchen.RowCount == 1)
			{
				dataGridViewKuchen.CurrentCell = dataGridViewKuchen.Rows[aktZeile].Cells[0];
			}
			else
			{
				schliessenKuchenBoxen();
			}
		}

		void oeffnenKuchenBoxen()
		{
			buttonKuchenAendern.Enabled = true;
			buttonKuchenLoeschen.Enabled = true;
		}

		void schliessenKuchenBoxen()
		{
			textBoxKuchenID.Clear();
			textBoxKuchenAnbieter.Clear();
			textBoxKuchenSorte.Clear();
			textBoxKuchenBeschreibung.Clear();
			textBoxKuchenAnzahl.Clear();
			textBoxKuchenAbgabedatum.Clear();
			checkBoxKuchenDiabetikergeeignet.Checked = false;

			buttonKuchenAendern.Enabled = false;
			buttonKuchenLoeschen.Enabled = false;
		}

		void selectKuchenElement_Click(Object sender, EventArgs e)
		{
			if (dataGridViewKuchen.SelectedRows.Count > 0)
			{
				Object tempID = dataGridViewKuchen.SelectedRows[0].Cells["ID"].Value;

				if (tempID != null)
				{
					aktKuchenID = Convert.ToInt32(tempID.ToString());
					textBoxKuchenID.Text = aktKuchenID.ToString();
				}

				Kuchen tempKuchen = kuchenverwaltung.getInfos(aktKuchenID);
				if (tempKuchen != null)
				{
					textBoxKuchenAnbieter.Text = tempKuchen.Anbieter;
					textBoxKuchenSorte.Text = tempKuchen.Sorte;
					textBoxKuchenBeschreibung.Text = tempKuchen.Beschreibung;
					textBoxKuchenAbgabedatum.Text = tempKuchen.Abgabedatum.ToString();
					textBoxKuchenAnzahl.Text = tempKuchen.Anzahl.ToString();
					checkBoxKuchenDiabetikergeeignet.Checked = tempKuchen.Diabetikergeeignet;
				}

				oeffnenKuchenBoxen();
			}
		}

		void buttonKuchenAendern_Click(Object sender, EventArgs e)
		{
			String tempID = textBoxKuchenID.Text;
			if (tempID.Length > 0)
			{
				aktKuchenID = Convert.ToInt32(tempID.ToString());

				KuchenWerte kuchenAendern = new KuchenWerte(this, kuchenverwaltung);
				kuchenAendern.ShowDialog();

				refreshKuchenDaten();
			}
		}

		void buttonKuchenLoeschen_Click(Object sender, EventArgs e)
		{
			String tempID = textBoxKuchenID.Text;
			if (tempID.Length > 0)
			{
				aktKuchenID = Convert.ToInt32(tempID.ToString());

				kuchenverwaltung.del(aktKuchenID);

				aktKuchenID = 0;

				refreshKuchenDaten();
			}
		}

		void buttonKuchenNeu_Click(Object sender, EventArgs e)
		{
			Kuchen tempKuchen = new Kuchen();

			kuchenverwaltung.neu(tempKuchen);

			//tempkuchen hält schon die aktuelle ID
			aktKuchenID = tempKuchen.Id;

			KuchenWerte kuchenNeu = new KuchenWerte(this, kuchenverwaltung);
			kuchenNeu.ShowDialog();

			//das muß leider sein, weil sonst neue Sätze verloren gehen
			checkBoxKuchenFiltern.Checked = false;
			aktKuchenID = -1;

			refreshKuchenDaten();
		}

		void checkBoxKuchenFiltern_CheckedChanged(Object sender, EventArgs e)
		{
			//leider müssen wir hier die aktuellen Keys aufgeben, da die Suchmaske alles verändern kann
			aktKuchenID = 0;

			if (checkBoxKuchenFiltern.Checked)
			{
				textBoxKuchenFiltern.Enabled = true;
			}
			else
			{
				textBoxKuchenFiltern.Enabled = false;
			}

			refreshKuchenDaten();
		}

		void textBoxKuchenFiltern_TextChanged(Object sender, EventArgs e)
		{
			//leider müssen wir hier die aktuellen Keys aufgeben, da die Suchmaske alles verändern kann
			aktKuchenID = 0;

			if (textBoxKuchenFiltern.Text.Length == 0)
			{
				checkBoxKuchenFiltern.Checked = false;
			}

			refreshKuchenDaten();
		}

		//Gast
		void refreshGaesteDaten()
		{
			int retteMich = aktGaesteID;
			
			if (checkBoxGaesteFiltern.Checked)
			{
				String suchmaske = textBoxGaesteFiltern.Text;
				dataGridViewGaeste.DataSource = gaesteverwaltung.getTabelle(suchmaske);
			}
			else
			{
				dataGridViewGaeste.DataSource = gaesteverwaltung.getTabelle();
			}

			aktGaesteID = retteMich;

			int aktZeile = bestimmeDataGridViewZeile(dataGridViewGaeste, aktGaesteID);

			if (aktZeile > 0 || aktGaesteID > 0 || dataGridViewGaeste.RowCount == 1)
			{
				dataGridViewGaeste.CurrentCell = dataGridViewGaeste.Rows[aktZeile].Cells[0];
			}
			else
			{
				schliessenGaesteBoxen();
			}
		}

		void oeffnenGaesteBoxen()
		{
			buttonGaesteAendern.Enabled = true;
			buttonGaesteLoeschen.Enabled = true;
		}

		void schliessenGaesteBoxen()
		{
			textBoxGaesteID.Clear();
			textBoxGaesteName.Clear();
			textBoxGaesteVorname.Clear();
			textBoxGaesteFirma.Clear();
			textBoxGaesteMobile.Clear();
			textBoxGaesteEmail.Clear();

			buttonGaesteAendern.Enabled = false;
			buttonGaesteLoeschen.Enabled = false;
		}

		void selectGaesteElement_Click(Object sender, EventArgs e)
		{
			if (dataGridViewGaeste.SelectedRows.Count > 0)
			{
				Object tempID = dataGridViewGaeste.SelectedRows[0].Cells["ID"].Value;

				if (tempID != null)
				{
					aktGaesteID = Convert.ToInt32(tempID.ToString());
					textBoxGaesteID.Text = aktGaesteID.ToString();
				}

				Gast tempGast = gaesteverwaltung.getInfos(aktGaesteID);
				if (tempGast != null)
				{
					textBoxGaesteName.Text = tempGast.Name;
					textBoxGaesteVorname.Text = tempGast.Vorname;
					textBoxGaesteFirma.Text = tempGast.Firma;
					textBoxGaesteMobile.Text = tempGast.Mobile;
					textBoxGaesteEmail.Text = tempGast.Email;
					textBoxGaesteName.Text = tempGast.Name;
				}

				oeffnenGaesteBoxen();
			}
		}

		void buttonGaesteAendern_Click(Object sender, EventArgs e)
		{
			String tempID = textBoxGaesteID.Text;
			if (tempID.Length > 0)
			{
				aktGaesteID = Convert.ToInt32(tempID.ToString());

				GaesteWerte gaesteAendern = new GaesteWerte(this, gaesteverwaltung);
				gaesteAendern.ShowDialog();

				refreshGaesteDaten();
			}
		}

		void buttonGaesteLoeschen_Click(Object sender, EventArgs e)
		{
			String tempID = textBoxGaesteID.Text;
			if (tempID.Length > 0)
			{
				aktGaesteID = Convert.ToInt32(tempID.ToString());
	
				gaesteverwaltung.del(aktGaesteID);

				aktGaesteID = 0;

				refreshGaesteDaten();
			}
		}

		void buttonGaesteNeu_Click(Object sender, EventArgs e)
		{
			Gast tempGast = new Gast();

			gaesteverwaltung.neu(tempGast);

			aktGaesteID = tempGast.Id;

			GaesteWerte gaesteNeu = new GaesteWerte(this, gaesteverwaltung);
			gaesteNeu.ShowDialog();

			checkBoxGaesteFiltern.Checked = false;
			aktGaesteID = -1;

			refreshGaesteDaten();
		}

		void checkBoxGaesteFiltern_CheckedChanged(Object sender, EventArgs e)
		{
			aktGaesteID = 0;

			if (checkBoxGaesteFiltern.Checked)
			{
				textBoxGaesteFiltern.Enabled = true;
			}
			else
			{
				textBoxGaesteFiltern.Enabled = false;
			}

			refreshGaesteDaten();
		}

		void textBoxGaesteFiltern_TextChanged(Object sender, EventArgs e)
		{
			aktGaesteID = 0;

			if (textBoxGaesteFiltern.Text.Length == 0)
			{
				checkBoxGaesteFiltern.Checked = false;
			}

			refreshGaesteDaten();
		}

		//Bestellungen
		void refreshBestellungenDaten()
		{
			int retteMich = aktBestellungenID;

			if (checkBoxBestellungenFiltern.Checked)
			{
				String suchmaske = textBoxBestellungenFiltern.Text;
				dataGridViewBestellungen.DataSource = bestellungenverwaltung.getTabelle(suchmaske);
			}
			else
			{
				dataGridViewBestellungen.DataSource = bestellungenverwaltung.getTabelle();
			}

			aktBestellungenID = retteMich;

			int aktZeile = bestimmeDataGridViewZeile(dataGridViewBestellungen, aktBestellungenID);

			if (aktZeile > 0 || aktBestellungenID > 0 || dataGridViewBestellungen.RowCount == 1)
			{
				dataGridViewBestellungen.CurrentCell = dataGridViewBestellungen.Rows[aktZeile].Cells[0];
			}
			else
			{
				schliessenBestellungenBoxen();
			}
		}

		void initBestellungenBoxen()
		{
			comboBoxBestellungenGaesteID.Items.Clear();
			comboBoxBestellungenKuchenID.Items.Clear();
			for (int i = 0; i <= 100; i++)
			{
				comboBoxBestellungenGaesteID.Items.Add(i.ToString());
				comboBoxBestellungenKuchenID.Items.Add(i.ToString());
			}
		}

		void oeffnenBestellungenBoxen()
		{
			comboBoxBestellungenGaesteID.Enabled = true;
			comboBoxBestellungenKuchenID.Enabled = true;
			numericUpDownBestellungenMenge.ReadOnly = false;
			dateTimePickerBestellungenDatum.Enabled = true;
			checkBoxBestellungenBezahlt.Enabled = true;

			buttonBestellungenSpeichern.Enabled = true;
			buttonBestellungenLoeschen.Enabled = true;
		}

		void schliessenBestellungenBoxen()
		{
			textBoxBestellungenID.Clear();
			comboBoxBestellungenGaesteID.SelectedIndex = 0;
			comboBoxBestellungenKuchenID.SelectedIndex = 0;
			numericUpDownBestellungenMenge.Value = 0;
			dateTimePickerBestellungenDatum.Value = new DateTime(2000, 1, 1);
			checkBoxBestellungenBezahlt.Checked = false;

			comboBoxBestellungenGaesteID.Enabled = false;
			comboBoxBestellungenKuchenID.Enabled = false;
			numericUpDownBestellungenMenge.ReadOnly = true;
			dateTimePickerBestellungenDatum.Enabled = false;
			checkBoxBestellungenBezahlt.Enabled = false;

			buttonBestellungenSpeichern.Enabled = false;
			buttonBestellungenLoeschen.Enabled = false;
		}

		void selectBestellungenElement_Click(Object sender, EventArgs e)
		{
			if (dataGridViewBestellungen.SelectedRows.Count > 0)
			{
				Object tempID = dataGridViewBestellungen.SelectedRows[0].Cells["ID"].Value;

				if (tempID != null)
				{
					aktBestellungenID = Convert.ToInt32(tempID.ToString());
					textBoxBestellungenID.Text = aktBestellungenID.ToString();
				}

				Bestellung tempBestellung = bestellungenverwaltung.getInfos(aktBestellungenID);
				if (tempBestellung != null)
				{
					comboBoxBestellungenGaesteID.SelectedIndex = tempBestellung.GaesteId;
					comboBoxBestellungenKuchenID.SelectedIndex = tempBestellung.KuchenId;

					dateTimePickerBestellungenDatum.CustomFormat = "dd.MMM.yyyy, HH:mm:ss";
					dateTimePickerBestellungenDatum.Text = tempBestellung.Datum.ToString();
	
					numericUpDownBestellungenMenge.Value = tempBestellung.Menge;
					
					checkBoxBestellungenBezahlt.Checked = tempBestellung.Bezahlt;
				}

				oeffnenBestellungenBoxen();
			}
		}

		void buttonBestellungenSpeichern_Click(Object sender, EventArgs e)
		{
			String tempID = textBoxBestellungenID.Text;
			if (tempID.Length > 0)
			{
				Bestellung tempBestellung = new Bestellung();

				aktBestellungenID = Convert.ToInt32(tempID.ToString());
				tempBestellung.Id = aktBestellungenID;

				tempBestellung.GaesteId = comboBoxBestellungenGaesteID.SelectedIndex;
				tempBestellung.KuchenId = comboBoxBestellungenKuchenID.SelectedIndex;

				//wieder Entfernen des Custom Format Kommas
				String tempDatum = dateTimePickerBestellungenDatum.Text.Replace(',', ' ');
				tempBestellung.Datum = Convert.ToDateTime(tempDatum);

				tempBestellung.Menge = Convert.ToInt32(numericUpDownBestellungenMenge.Value);

				tempBestellung.Bezahlt = checkBoxBestellungenBezahlt.Checked;

				bestellungenverwaltung.setInfos(tempBestellung);

				refreshBestellungenDaten();
			}
		}

		void buttonBestellungenLoeschen_Click(Object sender, EventArgs e)
		{
			String tempID = textBoxBestellungenID.Text;
			if (tempID.Length > 0)
			{
				aktBestellungenID = Convert.ToInt32(tempID.ToString());

				bestellungenverwaltung.del(aktBestellungenID);

				aktBestellungenID = 0;

				refreshBestellungenDaten();
			}
		}

		void buttonBestellungenNeu_Click(Object sender, EventArgs e)
		{
			Bestellung tempBestellung = new Bestellung();

			bestellungenverwaltung.neu(tempBestellung);

			checkBoxBestellungenFiltern.Checked = false;
			aktBestellungenID = -1;

			refreshBestellungenDaten();
		}

		void checkBoxBestellungenFiltern_CheckedChanged(Object sender, EventArgs e)
		{
			aktBestellungenID = 0;

			if (checkBoxBestellungenFiltern.Checked)
			{
				textBoxBestellungenFiltern.Enabled = true;
			}
			else
			{
				textBoxBestellungenFiltern.Enabled = false;
			}

			refreshBestellungenDaten();
		}

		void textBoxBestellungenFiltern_TextChanged(Object sender, EventArgs e)
		{
			aktBestellungenID = 0;

			if (textBoxBestellungenFiltern.Text.Length == 0)
			{
				checkBoxBestellungenFiltern.Checked = false;
			}

			refreshBestellungenDaten();
		}

		//Menue
		void lesenGaesteToolStripMenuItem_Click(Object sender, EventArgs e)
		{
			aktGaesteID = 0;

			gaesteverwaltung.lesen();
			refreshGaesteDaten();
		}

		void sichernGaesteToolStripMenuItem_Click(Object sender, EventArgs e)
		{
			gaesteverwaltung.speichern();
			schliessenGaesteBoxen();
		}

		void lesenKuchenToolStripMenuItem_Click(Object sender, EventArgs e)
		{
			aktKuchenID = 0;

			kuchenverwaltung.lesen();
			refreshKuchenDaten();
		}

		void sichernKuchenToolStripMenuItem_Click(Object sender, EventArgs e)
		{
			kuchenverwaltung.speichern();
			schliessenKuchenBoxen();
		}
	
		void lesenBestellungenToolStripMenuItem_Click(Object sender, EventArgs e)
		{
			aktBestellungenID = 0;

			bestellungenverwaltung.lesen();
			refreshBestellungenDaten();
		}

		void sichernBestellungenToolStripMenuItem_Click(Object sender, EventArgs e)
		{
			bestellungenverwaltung.speichern();
			schliessenBestellungenBoxen();
		}

		void beendenToolStripMenuItem_Click(Object sender, EventArgs e)
		{
			Application.Exit();
		}

		void listeToolStripMenuItem_Click(Object sender, EventArgs e) 
		{
			KuchenBasarListe basarListe = new KuchenBasarListe(this);
			basarListe.ShowDialog();
		}

    }
}