using System;
using System.Windows.Forms;

public class Gast
{
	int id;
	String name;
	String vorname;
	String firma;
	String mobile;
	String email;
	DateTime timestamp;

	public int Id
	{
		get
		{
			return id;
		}

		set
		{
			id = value;
		}
	}

	public String Name
	{
		get
		{
			return name;
		}

		set
		{
			name = value;
		}
	}

	public String Vorname
	{
		get
		{
			return vorname;
		}

		set
		{
			vorname = value;
		}
	}
	
    public String Firma
	{
		get
        {
			return firma;
		}

		set
		{
			firma = value;
		}
	}

	public String Mobile
	{
		get
		{
			return mobile;
		}

		set
		{
			mobile = value;
		}
	}

	public String Email
	{
		get
		{
			return email;
		}

		set
		{
			email = value;
		}
	}

	public DateTime Timestamp
	{
		get
		{
			return timestamp;
		}
		
		set
		{
			timestamp = value;
		}
	}

	public Gast(int id, String name, String vorname, String firma, String mobile, String email)
	{
		Id = id;
		Name = name;
		Vorname = vorname;
		Firma = firma;
        Mobile = mobile;
		Email = email;
		timestamp = DateTime.Now;
	}

	public Gast()
	{
		timestamp = DateTime.Now;
	}

    public Gast(String gaesteInformation)
	{
		String[] kompletteListe = gaesteInformation.Split(';');

		if (! Int32.TryParse(kompletteListe[0], out id))
		{
			id = 0;
		}

		Name = kompletteListe[1];
		Vorname = kompletteListe[2];
		Firma = kompletteListe[3];
		Mobile = kompletteListe[4];
		Email = kompletteListe[5];

		//beim Laden sollte der Timestamp absichtlich nicht erneuert werden!
		timestamp = DateTime.Parse(kompletteListe[6]);
	}

    public void change(Gast aktGast)
	{
		Name = aktGast.Name;
		Vorname = aktGast.Vorname;
		Firma = aktGast.Firma;
		Mobile = aktGast.Mobile;
		Email = aktGast.Email;
		timestamp = DateTime.Now;
	}

    public String gesamt()
	{
		String temp;
		temp = Id.ToString() + ";" + Name + ";" + Vorname + ";" + Firma + ";" + Mobile + ";" + Email + ";" + Timestamp.ToString();

		return temp;
	}
};



