using System;
using System.Windows.Forms;

public class Kuchen
{
	int id;
	String anbieter;
	String sorte;
	String beschreibung;
	int anzahl;
	DateTime abgabedatum;
	bool diabetikergeeignet;
	DateTime timestamp;

    public int Id
	{
		get
		{
			return id;
		}

		set
		{
            this.id = value;
		}
	}

	public String Anbieter
	{
		get
		{
			return anbieter;
		}

		set
		{
            this.anbieter = value;
		}
	}

	public String Sorte
	{
		get
		{
			return sorte;
		}

		set
		{
            this.sorte = value;
		}
	}

	public String Beschreibung
	{
		get
		{
			return beschreibung;
		}

		set
		{
            this.beschreibung = value;
		}
	}

	public int Anzahl
	{
		get
		{
			return anzahl;
		}

		set
		{
            this.anzahl = value;
		}
	}

	public DateTime Abgabedatum
	{
		get
		{
			return abgabedatum;
		}

		set
		{
            this.abgabedatum = value;
		}
	}

	public bool Diabetikergeeignet
	{
		get
		{
			return diabetikergeeignet;
		}

		set
		{
            this.diabetikergeeignet = value;
		}
	}

	public DateTime Timestamp
	{
		get
		{
			return timestamp;
		}
	}

	public Kuchen(int id, String anbieter, String sorte, String beschreibung, int anzahl, DateTime abgabedatum, bool diabetikergeeignet)
    {
        this.id = id;
		this.anbieter = anbieter;
		this.sorte = sorte;
		this.beschreibung = beschreibung;
		this.anzahl = anzahl;
		this.abgabedatum = abgabedatum;
		this.diabetikergeeignet = diabetikergeeignet;
		this.timestamp = DateTime.Now;
	}

    public Kuchen(String kuchenInformation)
	{
		String[] kompletteListe = kuchenInformation.Split(';');

		if (! Int32.TryParse(kompletteListe[0], out id))
		{
			id = 0;
		}

		Anbieter = kompletteListe[1];
		Sorte = kompletteListe[2];
		Beschreibung = kompletteListe[3];
		Anzahl = Int32.Parse(kompletteListe[4]);
		Abgabedatum = DateTime.Parse(kompletteListe[5]);
		Diabetikergeeignet = Boolean.Parse(kompletteListe[6]);

		//beim Laden sollte der Timestamp absichtlich nicht erneuert werden!
		timestamp = DateTime.Parse(kompletteListe[7]);
	}

    public Kuchen()
	{
		this.timestamp = DateTime.Now;
	}

    public void change(Kuchen aktKuchen)
	{
		this.Anbieter = aktKuchen.Anbieter;
		this.Sorte = aktKuchen.Sorte;
		this.Beschreibung = aktKuchen.Beschreibung;
		this.Anzahl = aktKuchen.Anzahl;
		this.Abgabedatum = aktKuchen.Abgabedatum;
		this.Diabetikergeeignet = aktKuchen.Diabetikergeeignet;
		this.timestamp = DateTime.Now;
	}

    public String gesamt()
	{
		String temp;
		temp = Id.ToString() + ";" +
			Anbieter + ";" +
			Sorte + ";" +
			Beschreibung + ";" +
			Anzahl.ToString() + ";" +
			Abgabedatum.ToString() + ";" +
			Diabetikergeeignet.ToString() + ";" +
			Timestamp.ToString();

		return temp;
	}
};