using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Data;
using System.Windows.Forms;

public class KuchenM
{
	List<Kuchen> kuchenListe;
	String eingabeDateiname;
	String ausgabeDateiname;

	int getAutoID()
	{
		int id = 1;
		foreach (Kuchen tempkuchen in kuchenListe)
		{
			if (tempkuchen.Id >= id)
			{
				id = tempkuchen.Id + 1;
			}
		}
		return id;
	}

    public KuchenM()
	{
		kuchenListe = new List<Kuchen>();
		eingabeDateiname = "kuchen.csv";
		ausgabeDateiname = "kuchen.csv";

		lesen();
	}

	~KuchenM()
	{
		speichern();
	}

	public void setInfos(Kuchen aktKuchen)
	{
		foreach (Kuchen tempkuchen in kuchenListe)
		{
			if (tempkuchen.Id == aktKuchen.Id)
			{
				tempkuchen.change(aktKuchen);
				break;
			}
		}
	}

	public Kuchen getInfos(int aktid)
	{
		foreach (Kuchen tempkuchen in kuchenListe)
		{
			if (tempkuchen.Id == aktid)
			{
				return tempkuchen;
			}
		}
		return null;
	}

    public DataTable getTabelle()
	{
		DataTable kuchenTabelle = new DataTable();

		kuchenTabelle.Columns.Add("ID", Type.GetType("System.Int32"));
		kuchenTabelle.Columns.Add("Anbieter", Type.GetType("System.String"));
		kuchenTabelle.Columns.Add("Sorte", Type.GetType("System.String"));
		kuchenTabelle.Columns.Add("Aktuell", Type.GetType("System.DateTime"));

		DataRow tabellenZeile;

		foreach (Kuchen tempkuchen in kuchenListe)
		{
			tabellenZeile = kuchenTabelle.NewRow();
			tabellenZeile["ID"] = tempkuchen.Id;
			tabellenZeile["Anbieter"] = tempkuchen.Anbieter;
			tabellenZeile["Sorte"] = tempkuchen.Sorte;
			tabellenZeile["Aktuell"] = tempkuchen.Timestamp;

			kuchenTabelle.Rows.Add(tabellenZeile);
		}

		return kuchenTabelle;
	}

    public DataTable getTabelle(String suchmaske)
	{
		DataTable kuchenTabelle = new DataTable();

		kuchenTabelle.Columns.Add("ID", Type.GetType("System.Int32"));
		kuchenTabelle.Columns.Add("Anbieter", Type.GetType("System.String"));
		kuchenTabelle.Columns.Add("Sorte", Type.GetType("System.String"));
		kuchenTabelle.Columns.Add("Aktuell", Type.GetType("System.DateTime"));

		DataRow tabellenZeile;

		foreach (Kuchen tempkuchen in kuchenListe)
		{
			// wenn der Suchstring irgendwie vorkommt?
			// das schliet einen leeren Suchstring implizit mit ein
			if (tempkuchen.gesamt().Contains(suchmaske))
			{
				tabellenZeile = kuchenTabelle.NewRow();
				tabellenZeile["ID"] = tempkuchen.Id;
				tabellenZeile["Anbieter"] = tempkuchen.Anbieter;
				tabellenZeile["Sorte"] = tempkuchen.Sorte;
				tabellenZeile["Aktuell"] = tempkuchen.Timestamp;

				kuchenTabelle.Rows.Add(tabellenZeile);
			}
		}

		return kuchenTabelle;
	}

	public List<Kuchen> KuchenListe
	{
		get
		{
			return kuchenListe;
		}
	}

    public void add(Kuchen aktkuchen)
	{
		kuchenListe.Add(aktkuchen);
	}

    public void del(int aktid)
	{
		Kuchen loeschkuchen = null;
		bool existKuchen = false;

		foreach (Kuchen tempkuchen in kuchenListe)
		{
			if (tempkuchen.Id == aktid)
			{
				existKuchen = true;
				loeschkuchen = tempkuchen;
				break;
			}
		}
		if (existKuchen)
		{
			kuchenListe.Remove(loeschkuchen);
		}
	}

    public void neu(Kuchen aktkuchen)
	{
		aktkuchen.Id = getAutoID();
		//die anderen Felder werden leer initialisiert
		aktkuchen.Anbieter = "";
		aktkuchen.Sorte = "";
		aktkuchen.Beschreibung = "";
		aktkuchen.Anzahl = 0;
		aktkuchen.Abgabedatum = new DateTime(2000, 1, 1);
		aktkuchen.Diabetikergeeignet = false;

		kuchenListe.Add(aktkuchen);
	}

    public void lesen()
	{
		StreamReader streamreader;
		String zeile;
		Kuchen tempKuchen;

		kuchenListe.Clear();
        streamreader = new StreamReader(eingabeDateiname);

		try
		{
			while ((zeile = streamreader.ReadLine()) != null)
			{
				if (zeile.Length > 0)
				{
					tempKuchen = new Kuchen(zeile);
					add(tempKuchen);
				}
			}

		}

		catch (Exception e)
		{
			MessageBox.Show(e.Message);
		}

		finally
		{
            streamreader.Close();
        }
	}

    public void speichern()
	{
		StreamWriter streamwriter;
		String zeile;

        streamwriter = new StreamWriter(ausgabeDateiname);
        
        try
		{
			foreach(Kuchen tempKuchen in KuchenListe)
			{
				zeile = tempKuchen.gesamt();
				streamwriter.WriteLine(zeile);
			}
		}

		catch (Exception e)
		{
			MessageBox.Show(e.Message);
		}

		finally
		{
            streamwriter.Close();
        }
	}
};