﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace KuchenAccess1
{
    public partial class Form1 : Form
    {
        Kuchen aktKuchen;

        DBAssistent dbAssistent;

        public Form1()
        {
            InitializeComponent();

            dbAssistent = new DBAssistent();
            dataGridViewKuchen.DataSource = dbAssistent.getKuchenTabelle();
        }

        void formWirdGeschlossen(Object sender, FormClosingEventArgs e)
        {
            dbAssistent.closeDataBase();
        }

        void selectionChanged(Object sender, EventArgs e)
        {
            int kuchenID;
            aktKuchen = new Kuchen();

            if (dataGridViewKuchen.SelectedRows.Count > 0)
            {
                Object idobj = dataGridViewKuchen.SelectedRows[0].Cells["ID"].Value;

                if (idobj != DBNull.Value)
                {
                    kuchenID = Convert.ToInt32(idobj.ToString());
                    textBoxID.Text = kuchenID.ToString();
                    aktKuchen.id = kuchenID;
                }
                else
                {
                    textBoxID.Text = "DBNull";
                }

                dbAssistent.getKuchen(aktKuchen);

                comboBoxSorte.DataSource = dbAssistent.getSortenList();
                comboBoxSorte.SelectedIndex = aktKuchen.sorte;

                textBoxAnbieter.Text = aktKuchen.anbieter;
                textBoxBeschreibung.Text = aktKuchen.beschreibung;

                numericUpDownAnzahl.Value = aktKuchen.anzahl;

                dateTimePickerAbgabe.CustomFormat = "dd.MMM.yyy HH:mm:ss";
                dateTimePickerAbgabe.Value = Convert.ToDateTime(aktKuchen.abgabedatum);

                checkBoxDiabetiker.Checked = aktKuchen.diabetikergeeignet;
            }
        }

        void update(Object sender, EventArgs e)
        {
            aktKuchen = new Kuchen();

            aktKuchen.id = Convert.ToInt32(dataGridViewKuchen.SelectedRows[0].Cells["ID"].Value.ToString());

            aktKuchen.anbieter = textBoxAnbieter.Text;
            aktKuchen.beschreibung = textBoxBeschreibung.Text;

            aktKuchen.sorte = comboBoxSorte.SelectedIndex;

            aktKuchen.anzahl = Convert.ToInt32(numericUpDownAnzahl.Value);
            aktKuchen.abgabedatum = Convert.ToDateTime(dateTimePickerAbgabe.Value);

            aktKuchen.diabetikergeeignet = checkBoxDiabetiker.Checked;

            dbAssistent.updateKuchen(aktKuchen);

            dataGridViewKuchen.DataSource = dbAssistent.getKuchenTabelle();
        }
    }
}