using System.Data;
using System.Data.OleDb;
using System.Data.SqlClient;
using System;
using System.Collections.Generic;

public class DBAssistent
{
	OleDbConnection verbindung;

	OleDbCommand sqlabfrage;

	BestellungenDB bestellungenDB;
	KuchenDB kuchenDB;
	SortenDB sortenDB;
	GaesteDB gaesteDB;
	EinrichtungenDB einrichtungenDB;

	void initVerbindung()
	{
		verbindung = new OleDbConnection();
		verbindung.ConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source = Kuchenbasar.mdb";
		verbindung.Open();

		sqlabfrage = new OleDbCommand();
		sqlabfrage.Connection = verbindung;
	}

    public DBAssistent()
	{
		initVerbindung();

		bestellungenDB = new BestellungenDB(sqlabfrage);
		kuchenDB = new KuchenDB(sqlabfrage);
		sortenDB = new SortenDB(sqlabfrage);
		gaesteDB = new GaesteDB(sqlabfrage);
		einrichtungenDB = new EinrichtungenDB(sqlabfrage);
	}

	~DBAssistent()
	{
	}

    public void closeDataBase()
	{
		verbindung.Close();
	}

	//BestellungenDB
	public DataTable getBestellungenTabelle()
	{
		return bestellungenDB.getTable();
	}

    public DataTable getBestellungenTabelle(String suchstring)
	{
		return bestellungenDB.getTable(suchstring);
	}

    public Bestellung getBestellung(int aktid)
	{
		return bestellungenDB.get(aktid);
	}

    public DataTable getBestellungenKomplettTabelle()
	{
		return bestellungenDB.getKomplettTable();
	}

    public void updateBestellung(Bestellung aktbestellung)
	{
		bestellungenDB.update(aktbestellung);

		int tempKuchenID = aktbestellung.KuchenId;
		int tempKuchenVeraenderung = -1 * aktbestellung.Menge;

		kuchenDB.setVorrat(tempKuchenID, tempKuchenVeraenderung);
	}

    public void updateBestellung(Bestellung aktbestellung, int alterKuchenID, int alterKuchenMenge)
	{
		bestellungenDB.update(aktbestellung);

		int tempKuchenID = aktbestellung.KuchenId;
		int tempKuchenVeraenderung = -1 * aktbestellung.Menge;

		kuchenDB.setVorrat(tempKuchenID, tempKuchenVeraenderung);

		kuchenDB.setVorrat(alterKuchenID, alterKuchenMenge);
	}

    public int insertBestellung(Bestellung neubestellung)
	{
		int tempNeuID = bestellungenDB.insert(neubestellung);

		int tempKuchenID = neubestellung.KuchenId;
		int tempKuchenVeraenderung = -1 * neubestellung.Menge;
	
		kuchenDB.setVorrat(tempKuchenID, tempKuchenVeraenderung);
	
		return tempNeuID;
	}

    public void deleteBestellung(int aktid)
	{
		bestellungenDB.del(aktid);
	}

	//KuchenDB
    public List<String> getKuchenList()
	{
		return kuchenDB.getList();
	}

    public bool changedKuchenList()
	{
		return kuchenDB.isChanged;
	}

    public DataTable getKuchenTabelle()
	{
		return kuchenDB.getTable();
	}

    public DataTable getKuchenTabelle(String suchstring)
	{
		return kuchenDB.getTable(suchstring);
	}

    public Kuchen getKuchen(int aktid)
	{
		return kuchenDB.get(aktid);
	}

    public void updateKuchen(Kuchen aktkuchen)
	{
		kuchenDB.update(aktkuchen);
	}

    public int insertKuchen(Kuchen aktkuchen)
	{
		return kuchenDB.insert(aktkuchen);
	}

    public void deleteKuchen(int aktid)
	{
		kuchenDB.del(aktid);
	}

    public int getVorratKuchen(int aktid)
	{
		return kuchenDB.getVorrat(aktid);
	}

    public double getPreisKuchen(int aktid)
	{
		return kuchenDB.getPreis(aktid);
	}

    public int getKuchenBestellungenGesamt(int kuchenid)
	{
		return bestellungenDB.getKuchenGesamt(kuchenid);
	}

	//da die Kuchen in der Access-DB Lcken im Key(Index) haben knnen, 
	//in der Comboxbox aber nicht, wird hier eine Umsetzung in beide Richtungen
	//ber die Dictionary gewhrleistet
    public int number2indexKuchen(int number)
	{
		return kuchenDB.getNumber2Index(number);
	}

    public int index2numberKuchen(int id)
	{
		return kuchenDB.getIndex2Number(id);
	}

	//SortenDB	
    public List<String> getSortenList()
	{
		return sortenDB.getList();
	}

    public String getSorte(int kuchenid)
	{
		List<String> backwaren = sortenDB.getList();
		int fkId = kuchenDB.getSorte(kuchenid);

		return sortenDB.getBackwarenSorte(fkId);
	}
	//GaesteDB
    public List<String> getGaesteList()
	{
		return gaesteDB.getList();
	}

    public bool changedGaesteList()
	{
		return gaesteDB.isChanged;
	}

    public DataTable getGaesteTabelle()
	{
		return gaesteDB.getTable();
	}

    public DataTable getGaesteTabelle(String suchstring)
	{
		return gaesteDB.getTable(suchstring);
	}

    public Gast getGaeste(int aktid)
	{
		return gaesteDB.get(aktid);
	}

    public void updateGaeste(Gast aktgast)
	{
		gaesteDB.update(aktgast);
	}

    public int insertGaeste(Gast aktgast)
	{
		return gaesteDB.insert(aktgast);
	}

    public void deleteGaeste(int aktid)
	{
		gaesteDB.del(aktid);
	}
	
	//da die Gaeste in der Access-DB Lcken im Key(Index) haben knnen, 
	//in der Comboxbox aber nicht, wird hier eine Umsetzung in beide Richtungen
	//ber die Dictionary gewhrleistet
    public int number2indexGaeste(int number)
	{
		return gaesteDB.getNumber2Index(number);
	}

    public int index2numberGaeste(int id)
	{
		return gaesteDB.getIndex2Number(id);
	}

    public int getGaesteBestellungenGesamt(int gaesteid)
	{
		return bestellungenDB.getGaesteGesamt(gaesteid);
	}

	//EinrichtungenDB	
    public List<String> getEinrichtungenList()
	{
		return einrichtungenDB.getList();
	}

    public String getEinrichtung(int gaesteid)
	{
		return einrichtungenDB.getEinrichtung(gaesteid);
	}
};