using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.OleDb;

public class EinrichtungenDB
{
	OleDbCommand sqlAbfrage;

	public EinrichtungenDB(OleDbCommand sqlAbfrage)
    {
        this.sqlAbfrage = sqlAbfrage;
        init();
	}

	EinrichtungenDB()
	{
		init();
	}

	~EinrichtungenDB()
	{
	}

	void init()
	{
		einrichtungenliste = null;
	}

	List<String> einrichtungenliste;
	Dictionary<int, String> dictlist;

    public List<String> getList()
	{
		if (null == einrichtungenliste)
		{
			einrichtungenliste = new List<String>();
			dictlist = new Dictionary<int, String>();

			sqlAbfrage.CommandText = "SELECT ID, einrichtung FROM Einrichtungen ORDER BY 1 ASC";
			OleDbDataReader aktCursor = sqlAbfrage.ExecuteReader();

			while (aktCursor.Read())
			{
				int tempid = aktCursor.GetInt32(0);
				String tempname = aktCursor.GetString(1);

				einrichtungenliste.Add(tempname);
				dictlist.Add(tempid, tempname);
			}

			aktCursor.Close();
		}
		return einrichtungenliste;
	}

    public String getEinrichtung(int gaesteid)
	{
		sqlAbfrage.CommandText =
			"SELECT einrichtung " + 
			"FROM Einrichtungen " +
			"WHERE id IN "+ 
			"      (SELECT einrichtung " +
			"       FROM Gaeste " +
			"       WHERE id = @gaesteid);";

		sqlAbfrage.Parameters.Clear();
		sqlAbfrage.Parameters.AddWithValue("@gaesteid", gaesteid);

		Object aktSQL = sqlAbfrage.ExecuteScalar();
		if (aktSQL != null)
		{
			String tempEinrichtung = Convert.ToString(aktSQL);
			return tempEinrichtung;
		}

		return "";
	}
};