using System;
using System.Data;
using System.Data.OleDb;

public class BestellungenDB
{
	OleDbCommand sqlAbfrage;

    public BestellungenDB(OleDbCommand sqlAbfrage)
    {
        this.sqlAbfrage = sqlAbfrage;
	}

	BestellungenDB()
	{
	}

	~BestellungenDB()
	{
	}

    public void update(Bestellung aktbestellung)
	{
		aktbestellung.Letzterzugriff = DateTime.Now;

		sqlAbfrage.CommandText =
			"UPDATE Bestellungen SET " +
			"gast = " + aktbestellung.GaesteId.ToString() + ", " +
			"kuchen = " + aktbestellung.KuchenId.ToString() + ", " +
			"bestelldatum =  " + "cvdate('" + aktbestellung.Bestelldatum.ToString() + "')" + ", " +
			"menge = " + aktbestellung.Menge.ToString() + ", " +
			"gesamtpreis = " + String.Format("{0:F2}", aktbestellung.Gesamtpreis).Replace(',', '.') + ", " +
			"bezahlt = " + aktbestellung.Bezahlt.ToString() + ", " +
			"geliefert = " + aktbestellung.Geliefert.ToString() + ", " +
			"letzterzugriff =  " + "cvdate('" + aktbestellung.Letzterzugriff.ToString() + "') " +
			"WHERE id = " + aktbestellung.Id.ToString() + ";";

		int ergebnis = sqlAbfrage.ExecuteNonQuery();
	}

    public int insert(Bestellung neubestellung)
	{
		neubestellung.Letzterzugriff = DateTime.Now;

		sqlAbfrage.CommandText =
			"INSERT INTO Bestellungen " +
			"(gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, geliefert, letzterzugriff) " +
			"VALUES (" +
			neubestellung.KuchenId.ToString() + ", " +
			neubestellung.GaesteId.ToString() + ", " +
			neubestellung.Menge.ToString() + ", " +
			"cvdate('" + neubestellung.Bestelldatum.ToString() + "')" + ", " +
			String.Format("{0:F2}", neubestellung.Gesamtpreis).Replace(',', '.') + ", " +
			neubestellung.Bezahlt.ToString() + ", " +
			neubestellung.Geliefert.ToString() + ", " +
			"cvdate('" + neubestellung.Letzterzugriff.ToString() + "')" +
			");";

		sqlAbfrage.ExecuteNonQuery();

		int neueID = 0;

		//da die neuvergebene ID nur fr den Cursor der dataGridView bentigt wird
		//und auch 0 ok wre, machen wir das hier nicht so wissenschaftlich
		//ber alle Attribute, sondern nur ber Erstellung und letzten Zugriff
		sqlAbfrage.CommandText =
			"SELECT id FROM Bestellungen " +
			"WHERE bestelldatum = " + "cvdate('" + neubestellung.Bestelldatum.ToString() + "')" +
			" AND  letzterzugriff = " + "cvdate('" + neubestellung.Letzterzugriff.ToString() + "');";

		Object aktSQL = sqlAbfrage.ExecuteScalar();
		if (aktSQL != null)
		{
			neueID = Convert.ToInt32(aktSQL);
		}

		return neueID;
	}

    public void del(int aktid)
	{
		sqlAbfrage.CommandText =
			"DELETE " +
			"FROM Bestellungen " +
			"WHERE id = @id;";

		sqlAbfrage.Parameters.Clear();
		sqlAbfrage.Parameters.AddWithValue("@id", aktid);

		sqlAbfrage.ExecuteNonQuery();
	}

    public Bestellung get(int aktid)
	{
		Bestellung aktBestellung = new Bestellung();

		aktBestellung.Id = aktid;

		sqlAbfrage.CommandText =
			"SELECT gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, geliefert " +
			"FROM Bestellungen " +
			"WHERE id = @id;";

		sqlAbfrage.Parameters.Clear();
		sqlAbfrage.Parameters.AddWithValue("@id", aktid);

		OleDbDataReader aktCursor = sqlAbfrage.ExecuteReader();

		aktCursor.Read();

		aktBestellung.GaesteId = aktCursor.GetInt32(0);
		aktBestellung.KuchenId = aktCursor.GetInt32(1);
		aktBestellung.Menge= aktCursor.GetInt32(2);
		aktBestellung.Bestelldatum = aktCursor.GetDateTime(3);
		aktBestellung.Gesamtpreis = aktCursor.GetDouble(4);
		aktBestellung.Bezahlt = aktCursor.GetBoolean(5);
		aktBestellung.Geliefert = aktCursor.GetBoolean(6);

		aktCursor.Close();

		return aktBestellung;
	}

	public DataTable getTable()
	{
		DataTable bestellungenTabelle = new DataTable();

		bestellungenTabelle.Columns.Add("ID", Type.GetType("System.Int32"));
		bestellungenTabelle.Columns.Add("Gast", Type.GetType("System.String"));
		bestellungenTabelle.Columns.Add("Kuchen", Type.GetType("System.String"));
		bestellungenTabelle.Columns.Add("Menge", Type.GetType("System.Int32"));
		bestellungenTabelle.Columns.Add("Preis", Type.GetType("System.String"));
		bestellungenTabelle.Columns.Add("LetzterZugriff", Type.GetType("System.DateTime"));

		sqlAbfrage.CommandText =
			"SELECT ID, kurzgast, kurzkuchen, menge, gesamtpreis, letzterzugriff " +
			"FROM BestellungenView;";

		OleDbDataReader aktCursor = sqlAbfrage.ExecuteReader();

		while (aktCursor.Read())
		{
			double tempdouble = aktCursor.GetDouble(4);
			String temppreis = String.Format("{0:F2}", tempdouble).Replace(',', '.');

			DataRow zeile = bestellungenTabelle.NewRow();

			zeile["ID"] = aktCursor.GetInt32(0);
			zeile["Gast"] = aktCursor.GetString(1);
			zeile["Kuchen"] = aktCursor.GetString(2);
			zeile["Menge"] = aktCursor.GetInt32(3);
			zeile["Preis"] = temppreis + " ";
			zeile["LetzterZugriff"] = aktCursor.GetDateTime(5);

			bestellungenTabelle.Rows.Add(zeile);
		}

		aktCursor.Close();

		return bestellungenTabelle;
	}

    public DataTable getTable(String suchmaske)
	{
		DataTable bestellungenTabelle = new DataTable();
		String suchstring;

		bestellungenTabelle.Columns.Add("ID", Type.GetType("System.Int32"));
		bestellungenTabelle.Columns.Add("Gast", Type.GetType("System.String"));
		bestellungenTabelle.Columns.Add("Kuchen", Type.GetType("System.String"));
		bestellungenTabelle.Columns.Add("Menge", Type.GetType("System.Int32"));
		bestellungenTabelle.Columns.Add("Preis", Type.GetType("System.String"));
		bestellungenTabelle.Columns.Add("LetzterZugriff", Type.GetType("System.DateTime"));

		//hier wird die View gelesen, um alles mit in den Suchstring zu bekommen
		//"true" und "false" stren aber beim Filter nur, das Datmer sind bewut verkrzt
		sqlAbfrage.CommandText =
			"SELECT ID, bestelldatum, kurzgast, kurzkuchen, menge, gesamtpreis, bezahlt, geliefert, gastname, " +
			"       vorname, einrichtung, anbieter, beschreibung, backwarensorte, letzterzugriff " +
			"FROM BestellungenView;";

		OleDbDataReader aktCursor = sqlAbfrage.ExecuteReader();

		while (aktCursor.Read())
		{
			//Beschreibung, Vorname knnen NULL Werte sein
			Object tempObj = aktCursor.GetValue(12);
			String tempbeschreibung = "";
			if (tempObj != DBNull.Value)
			{
				tempbeschreibung = aktCursor.GetString(12);
			}
			Object tempObj2 = aktCursor.GetValue(9);
			String tempvorname = "";
			if (tempObj2 != DBNull.Value)
			{
				tempvorname = aktCursor.GetString(9);
			}

			double tempdouble = aktCursor.GetDouble(5);
			String temppreis = String.Format("{0:F2}", tempdouble).Replace(',', '.');

			suchstring = aktCursor.GetString(2) +
				aktCursor.GetString(3) +
				aktCursor.GetString(8) +
				aktCursor.GetString(10) +
				aktCursor.GetString(11) +
				aktCursor.GetString(13) +
				tempbeschreibung +
				tempvorname +
				temppreis +
				Convert.ToString(aktCursor.GetDateTime(1)).Substring(0, 10) +
				Convert.ToString(aktCursor.GetInt32(4));

			// wenn der Suchstring irgendwie vorkommt?
			// das schliet einen leeren Suchstring implizit mit ein
			if (suchstring.Contains(suchmaske))
			{
				DataRow zeile = bestellungenTabelle.NewRow();

				zeile["ID"] = aktCursor.GetInt32(0);
				zeile["Gast"] = aktCursor.GetString(2);
				zeile["Kuchen"] = aktCursor.GetString(3);
				zeile["Menge"] = aktCursor.GetInt32(4);
				zeile["Preis"] = temppreis + " ";
				zeile["LetzterZugriff"] = aktCursor.GetDateTime(14);

				bestellungenTabelle.Rows.Add(zeile);
			}
		}

		aktCursor.Close();

		return bestellungenTabelle;
	}

    public DataTable getKomplettTable()
	{
		DataTable bestellungenTabelle = new DataTable();

		bestellungenTabelle.Columns.Add("Bestelldatum", Type.GetType("System.DateTime"));
		bestellungenTabelle.Columns.Add("Gast", Type.GetType("System.String"));
		bestellungenTabelle.Columns.Add("Einrichtung", Type.GetType("System.String"));
		bestellungenTabelle.Columns.Add("Kuchen", Type.GetType("System.String"));
		bestellungenTabelle.Columns.Add("Anbieter", Type.GetType("System.String"));
		bestellungenTabelle.Columns.Add("Beschreibung", Type.GetType("System.String"));
		bestellungenTabelle.Columns.Add("Kategorie", Type.GetType("System.String"));
		bestellungenTabelle.Columns.Add("Menge", Type.GetType("System.Int32"));
		bestellungenTabelle.Columns.Add("Preis", Type.GetType("System.String"));
		bestellungenTabelle.Columns.Add("Bezahlt", Type.GetType("System.Boolean"));
		bestellungenTabelle.Columns.Add("Geliefert", Type.GetType("System.Boolean"));

		sqlAbfrage.CommandText =
			"SELECT bestelldatum, kurzgast, einrichtung, kurzkuchen, anbieter, beschreibung, " +
			"       backwarensorte, menge, gesamtpreis, bezahlt, geliefert " +
			"FROM BestellungenView;";

		OleDbDataReader aktCursor = sqlAbfrage.ExecuteReader();

		while (aktCursor.Read())
		{
			//Beschreibung, Vorname knnen NULL Werte sein
			Object tempObj = aktCursor.GetValue(5);
			String tempbeschreibung = "";
			if (tempObj != DBNull.Value)
			{
				tempbeschreibung = aktCursor.GetString(5);
			}
		
			double tempdouble = aktCursor.GetDouble(8);
			String temppreis = String.Format("{0:F2}", tempdouble).Replace(',', '.');

			DataRow zeile = bestellungenTabelle.NewRow();

			zeile["Bestelldatum"] = aktCursor.GetDateTime(0);
			zeile["Gast"] = aktCursor.GetString(1);
			zeile["Einrichtung"] = aktCursor.GetString(2);
			zeile["Kuchen"] = aktCursor.GetString(3);
			zeile["Anbieter"] = aktCursor.GetString(4);
			zeile["Beschreibung"] = tempbeschreibung;
			zeile["Kategorie"] = aktCursor.GetString(6);
			zeile["Menge"] = aktCursor.GetInt32(7);
			zeile["Preis"] = temppreis + " ";
			zeile["Bezahlt"] = aktCursor.GetBoolean(9);
			zeile["Geliefert"] = aktCursor.GetBoolean(10);

			bestellungenTabelle.Rows.Add(zeile);
		}

		aktCursor.Close();

		return bestellungenTabelle;
	}

    public int getKuchenGesamt(int kuchenid)
	{
		sqlAbfrage.CommandText =
			"SELECT SUM(Menge) FROM Bestellungen " +
			"WHERE Kuchen = @kuchenid;";

		sqlAbfrage.Parameters.Clear();
		sqlAbfrage.Parameters.AddWithValue("kuchenid", kuchenid);

		Object aktSQL = sqlAbfrage.ExecuteScalar();
		if (aktSQL != null && aktSQL != DBNull.Value)
		{
			int tempanzahl = Convert.ToInt32(aktSQL);
			return tempanzahl;
		}

		return 0;
	}

    public int getGaesteGesamt(int gaesteid)
	{
		sqlAbfrage.CommandText =
			"SELECT COUNT(*) FROM Bestellungen " +
			"WHERE Gast = @gaesteid;";

		sqlAbfrage.Parameters.Clear();
		sqlAbfrage.Parameters.AddWithValue("gaesteid", gaesteid);

		Object aktSQL = sqlAbfrage.ExecuteScalar();
		if (aktSQL != null && aktSQL != DBNull.Value)
		{
			int tempanzahl = Convert.ToInt32(aktSQL);
			return tempanzahl;
		}

		return 0;
	}
};