﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace KuchenBasar
{
    public partial class GaesteWerte : Form
    {
		IKuchenBasar kuchenBasar;
		DBAssistent dbAssistent;
    	Gast aktGast;

        public GaesteWerte(IKuchenBasar kuchenBasarForm, DBAssistent dbAssistentForm)
		{
			InitializeComponent();

			kuchenBasar = kuchenBasarForm;
			dbAssistent = dbAssistentForm;

			if (kuchenBasar.AktGaesteID < 0)
			{
				aktGast = new Gast(-1, "", "", "neuer Gast", 0, "");
			}
			else
			{
				aktGast = dbAssistent.getGaeste(kuchenBasar.AktGaesteID);
			}

			textBoxName.Text = aktGast.Gastname;
			textBoxVorname.Text = aktGast.Vorname;
			textBoxKurzname.Text = aktGast.Kurzname;
			textBoxTelefon.Text = aktGast.Telefon;

			comboBoxEinrichtung.DataSource = dbAssistent.getEinrichtungenList();
			comboBoxEinrichtung.SelectedIndex = aktGast.Einrichtung;
		}

        public GaesteWerte()
        {
            InitializeComponent();
        }
        		bool komplexePlausis()
		{
			if (textBoxName.Text.Length == 0)
			{
				MessageBox.Show("Name muß gefüllt werden");
				return false;
			}

			if (textBoxKurzname.Text.Length == 0)
			{
				MessageBox.Show("Kurzname muß gefüllt werden");
				return false;
			}

			if (comboBoxEinrichtung.SelectedIndex == 0)
			{
				MessageBox.Show("keine gültige Einrichtung");
				return false;
			}

			return true;
		}

		void buttonAbbruch_Click(Object sender, EventArgs e)
		{
			this.Close();
		}

		void buttonSpeichern_Click(Object sender, EventArgs e)
		{
			if (!komplexePlausis())
			{
				//MessageBox::Show("mind. ein Feld war nicht korrekt gefüllt");
			}
			else
			{
				aktGast.Gastname = textBoxName.Text;
				aktGast.Vorname = textBoxVorname.Text;
				aktGast.Kurzname = textBoxKurzname.Text;
				aktGast.Telefon = textBoxTelefon.Text;

				aktGast.Einrichtung = comboBoxEinrichtung.SelectedIndex;

				if (kuchenBasar.AktGaesteID < 0)
				{
					int neuGaesteID = dbAssistent.insertGaeste(aktGast);
					kuchenBasar.AktGaesteID = neuGaesteID;
				}
				else
				{
					aktGast.Id = kuchenBasar.AktGaesteID;
					dbAssistent.updateGaeste(aktGast);
				}

				this.Close();
			}
		}

    }
}