using System;
using System.Windows.Forms;

public class Kuchen
{
	int id;
	String anbieter;
	int sorte;
	String kurzkuchen;
	String beschreibung;
	DateTime abgabedatum;
	int anzahl;
	double preis;
	bool diabetikergeeignet;
	DateTime letzterzugriff;

	public int Id
	{
		get
		{
			return this.id;
		}

		set
		{
			this.id = value;
		}
	}

	public String Anbieter
	{
		get
		{
			return this.anbieter;
		}

		set
		{
			this.anbieter = value;
		}
	}

	public int Sorte
	{
		get
		{
			return this.sorte;
		}

		set
		{
			this.sorte = value;
		}
	}

	public String Kurzkuchen
	{
		get
		{
			return this.kurzkuchen;
		}

		set
		{
			this.kurzkuchen = value;
		}
	}

	public String Beschreibung
	{
		get
		{
			return this.beschreibung;
		}

		set
		{
			this.beschreibung = value;
		}
	}

	public DateTime Abgabedatum
	{
		get
		{
			return this.abgabedatum;
		}

		set
		{
			this.abgabedatum = value;
		}
	}

	public int Anzahl
	{
		get
		{
			return this.anzahl;
		}

		set
		{
			this.anzahl = value;
		}
	}

	public double Preis
	{
		get
		{
			return this.preis;
		}

		set
		{
			this.preis = value;
		}
	}

	public bool Diabetikergeeignet
	{
		get
		{
			return this.diabetikergeeignet;
		}

		set
		{
			this.diabetikergeeignet = value;
		}
	}

	public DateTime Letzterzugriff
	{
		get
		{
			return this.letzterzugriff;
		}

		set
		{
			this.letzterzugriff = value;
		}
	}

	public Kuchen(int id, String anbieter, int sorte, String kurzkuchen, String beschreibung, DateTime abgabedatum, int anzahl, double preis, bool diabetikergeeignet)
    {
        this.id = id;
		this.anbieter = anbieter;
		this.sorte = sorte;
		this.kurzkuchen = kurzkuchen;
		this.beschreibung = beschreibung;
		this.abgabedatum = abgabedatum;
		this.anzahl = anzahl;
		this.preis = preis;
        this.diabetikergeeignet = diabetikergeeignet;
	    this.letzterzugriff = DateTime.Now;
	}

	Kuchen(String kuchenInformation)
	{
		String[] kompletteListe = kuchenInformation.Split(';');

		Id = Int32.Parse(kompletteListe[0]);
		Anbieter = kompletteListe[1];
		Sorte = Int32.Parse(kompletteListe[2]);
		Kurzkuchen = kompletteListe[3];
		Beschreibung = kompletteListe[4];
		Abgabedatum = DateTime.Parse(kompletteListe[5]);
		Anzahl = Int32.Parse(kompletteListe[6]);
		Preis = Int32.Parse(kompletteListe[7]);
		Diabetikergeeignet = Boolean.Parse(kompletteListe[8]);

		//beim Laden sollte der Timestamp absichtlich nicht erneuert werden!
		Letzterzugriff = DateTime.Parse(kompletteListe[9]);
	}

	public Kuchen()
	{
		Letzterzugriff = DateTime.Now;
	}

	~Kuchen()
	{

	}

	void change(Kuchen aktKuchen)
	{
		this.Anbieter = aktKuchen.Anbieter;
		this.Sorte = aktKuchen.Sorte;
		this.Kurzkuchen = aktKuchen.Kurzkuchen;
		this.Beschreibung = aktKuchen.Beschreibung;
		this.Abgabedatum = aktKuchen.Abgabedatum;
		this.Anzahl = aktKuchen.Anzahl;
		this.Preis = aktKuchen.Preis;
		this.Diabetikergeeignet = aktKuchen.Diabetikergeeignet;
		this.Letzterzugriff = DateTime.Now;
	}

	String gesamt()
	{
	//1;Frau Schmidt;1;Hefekuchen;selbstgebacken;27.11.2014 00:00:00;29;0.00;False;29.11.2014 17:43:47
		String temp;
		temp = Id.ToString() + ";" +
			   Anbieter + ";" +
		       Sorte.ToString() + ";" +
			   Kurzkuchen + ";" +
			   Beschreibung + ";" +
			   Abgabedatum.ToString() + ";" +
			   Anzahl.ToString() + ";" +
			   String.Format("{0:F2}", Preis).Replace(',','.') + ";" +
			   Diabetikergeeignet.ToString() + ";" +
			   Letzterzugriff.ToString();

		return temp;
	}
};