using System;
using System.Data;
using System.Data.OleDb;
using System.Collections.Generic;

public class SortenDB
{
	OleDbCommand sqlAbfrage;

    public SortenDB(OleDbCommand sqlAbfrage)
	{
        this.sqlAbfrage = sqlAbfrage;
		init();
	}

	SortenDB()
	{
		init();
	}

	~SortenDB()
	{
	}

	void init()
	{
		backwarenliste = null;
	}

	List<String> backwarenliste;
	Dictionary<int, String> dictlist;

    public List<String> getList()
	{
		if (null == backwarenliste)
		{
			backwarenliste = new List<String>();
			dictlist = new Dictionary<int, String>();

			sqlAbfrage.CommandText = "SELECT ID, backwarensorte FROM Sorten ORDER BY 1 ASC";
			OleDbDataReader aktCursor = sqlAbfrage.ExecuteReader();

			while (aktCursor.Read())
			{
				int tempid = aktCursor.GetInt32(0);
				String tempname = aktCursor.GetString(1);

				backwarenliste.Add(tempname);
				dictlist.Add(tempid, tempname);
			}

			aktCursor.Close();
		}
		return backwarenliste;
	}

    public String getBackwarenSorte(int id)
	{
		if (dictlist.ContainsKey(id))
		{
			String tempname = dictlist[id];
			return tempname;
		}
		else
		{
			return null;
		}
	}
};