using System.Data;
using System.Data.SqlClient;
using System;
using System.Collections.Generic;

public class DBAssistent
{
	SqlConnection verbindung;

	SqlCommand sqlabfrage;

	KuchenDB kuchenDB;
	SortenDB sortenDB;

	void initVerbindung()
	{
		verbindung = new SqlConnection();
		//verbindung.ConnectionString = "Data Source=HRO-023-201;Initial Catalog=kuchenbasar;Integrated Security=True";
		//verbindung.ConnectionString = "Data Source=DINO-2;Initial Catalog=kuchenbasar;Integrated Security=True";
		verbindung.ConnectionString = "Data Source=BERND-HP;Initial Catalog=kuchenbasarvcs;Integrated Security=True";
		verbindung.Open();

		sqlabfrage = new SqlCommand();
		sqlabfrage.Connection = verbindung;
	}

	public DBAssistent()
	{
		initVerbindung();

		kuchenDB = new KuchenDB(sqlabfrage);
		sortenDB = new SortenDB(sqlabfrage);
	}

	~DBAssistent()
	{
	}

    public DataTable getKuchenTabelle()
	{
		return kuchenDB.getTable();
	}

    public List<String> getSortenList()
	{
		return sortenDB.getList();
	}

    public String getSortenname(int kuchenid)
	{
		int fkId = kuchenDB.getSorte(kuchenid);
		return sortenDB.getBackwarenSorte(fkId);
	}

    public void closeDataBase()
	{
		verbindung.Close();
	}

    public void updateKuchen(Kuchen aktkuchen)
	{
		kuchenDB.update(aktkuchen);
	}

    public void getKuchen(Kuchen aktkuchen)
	{
		kuchenDB.get(aktkuchen);
	}
};