using System;
using System.Windows.Forms;

public class Bestellung
{
	int id;
	int gaesteid;
	int kuchenid;
	DateTime datum;
	int menge;
	bool bezahlt;
	DateTime timestamp;

    public int Id
	{
		get
		{
			return id;
		}

		set
		{
			this.id = value;
		}
	}

    public int GaesteId
	{
		get
		{
			return gaesteid;
		}

		set
		{
			this.gaesteid = value;
		}
	}

    public int KuchenId
	{
		get
		{
			return kuchenid;
		}

		set
		{
			this.kuchenid = value;
		}
	}

    public DateTime Datum
	{
		get
		{
			return datum;
		}

		set
		{
			this.datum = value;
		}
	}

    public DateTime TimeStamp
	{
		get
		{
			return timestamp;
		}

		set
		{
			this.timestamp = value;
		}
	}

    public int Menge
	{
		get
		{
            return menge;
		}

		set
		{
			this.menge = value;
		}
	}

    public bool Bezahlt
	{
		get
		{
			return bezahlt;
		}

		set
		{
			this.bezahlt = value;
		}
	}

	public Bestellung(int id, int gaesteid, int kuchenid, DateTime datum, int menge, bool bezahlt)
	{
        this.id = id;
		this.gaesteid = gaesteid;
		this.kuchenid = kuchenid;
		this.datum = datum;
		this.menge = menge;
		this.bezahlt = bezahlt;
		this.timestamp = DateTime.Now;
	}

    public Bestellung(String bestellungInformation)
	{
		String[] kompletteListe = bestellungInformation.Split(';');

		if (! Int32.TryParse(kompletteListe[0], out id))
		{
			id = 0;
		}

		GaesteId = Int32.Parse(kompletteListe[1]);
		KuchenId = Int32.Parse(kompletteListe[2]);
		Datum = DateTime.Parse(kompletteListe[3]);
		Menge = Int32.Parse(kompletteListe[4]);
		Bezahlt = Boolean.Parse(kompletteListe[5]);

		//beim Laden sollte der Timestamp absichtlich nicht erneuert werden!
		timestamp = DateTime.Parse(kompletteListe[6]);
	}

    public Bestellung()
	{
		this.timestamp = DateTime.Now;
	}

	public void change(Bestellung aktBestellung)
	{
		this.GaesteId = aktBestellung.GaesteId;
		this.KuchenId = aktBestellung.KuchenId;
		this.Datum = aktBestellung.Datum;
		this.Menge = aktBestellung.Menge;
		this.Bezahlt = aktBestellung.Bezahlt;
		this.timestamp = DateTime.Now;
	}

	public String gesamt()
	{
		String temp;
		temp = Id.ToString() + ";" +
			GaesteId.ToString() + ";" +
			KuchenId.ToString() + ";" +
			Datum.ToString() + ";" +
			Menge.ToString() + ";" +
			Bezahlt.ToString() + ";" +
			TimeStamp.ToString();

		return temp;
	}
};
