using  System;
using  System.Collections;
using  System.Collections.Generic;
using  System.IO;
using  System.Text;
using  System.Data;
using  System.Windows.Forms;

public class BestellungenM
{
	List<Bestellung> bestellungenListe;
	String eingabeDateiname;
	String ausgabeDateiname;

	int getAutoID()
	{
		int id = 1;
		foreach (Bestellung tempbestellung in bestellungenListe)
		{
			if (tempbestellung.Id >= id)
			{
				id = tempbestellung.Id + 1;
			}
		}
		return id;
	}

    public BestellungenM()
	{
		bestellungenListe = new List<Bestellung>();
		eingabeDateiname = "bestellungen.csv";
		ausgabeDateiname = "bestellungen.csv";

		lesen();
	}

	~BestellungenM()
	{
		speichern();
	}

    public void setInfos(Bestellung aktbestellung)
	{
		foreach (Bestellung tempbestellung in bestellungenListe)
		{
			if (tempbestellung.Id == aktbestellung.Id)
			{
				tempbestellung.change(aktbestellung);
				break;
			}
		}
	}

    public Bestellung getInfos(int aktid)
	{
		foreach (Bestellung tempbestellung in bestellungenListe)
		{
			if (tempbestellung.Id == aktid)
			{
				return tempbestellung;
			}
		}
		return null;
	}

    public DataTable getTabelle()
	{
		DataTable bestellungenTabelle = new DataTable();

		bestellungenTabelle.Columns.Add("ID", Type.GetType("System.Int32"));
		bestellungenTabelle.Columns.Add("gaesteID", Type.GetType("System.Int32"));
		bestellungenTabelle.Columns.Add("kuchenID", Type.GetType("System.Int32"));
		bestellungenTabelle.Columns.Add("datum", Type.GetType("System.DateTime"));
		bestellungenTabelle.Columns.Add("timestamp", Type.GetType("System.DateTime"));

		DataRow tabellenZeile;

		foreach (Bestellung tempbestellung in bestellungenListe)
		{
			tabellenZeile = bestellungenTabelle.NewRow();
			tabellenZeile["ID"] = tempbestellung.Id;
			tabellenZeile["gaesteID"] = tempbestellung.GaesteId;
			tabellenZeile["kuchenID"] = tempbestellung.KuchenId;
			tabellenZeile["datum"] = tempbestellung.Datum;
			tabellenZeile["timestamp"] = tempbestellung.TimeStamp;

			bestellungenTabelle.Rows.Add(tabellenZeile);
		}

		return bestellungenTabelle;
	}

    public DataTable getTabelle(String suchmaske)
	{
		DataTable bestellungenTabelle = new DataTable();

		bestellungenTabelle.Columns.Add("ID", Type.GetType("System.Int32"));
		bestellungenTabelle.Columns.Add("gaesteID", Type.GetType("System.Int32"));
		bestellungenTabelle.Columns.Add("kuchenID", Type.GetType("System.Int32"));
		bestellungenTabelle.Columns.Add("datum", Type.GetType("System.DateTime"));
		bestellungenTabelle.Columns.Add("timestamp", Type.GetType("System.DateTime"));

		DataRow tabellenZeile;

		foreach (Bestellung tempbestellung in bestellungenListe)
		{
			// wenn der Suchstring irgendwie vorkommt?
			// das schliet einen leeren Suchstring implizit mit ein
			if (tempbestellung.gesamt().Contains(suchmaske))
			{
				tabellenZeile = bestellungenTabelle.NewRow();
				tabellenZeile["ID"] = tempbestellung.Id;
				tabellenZeile["gaesteID"] = tempbestellung.GaesteId;
				tabellenZeile["kuchenID"] = tempbestellung.KuchenId;
				tabellenZeile["datum"] = tempbestellung.Datum;
				tabellenZeile["timestamp"] = tempbestellung.TimeStamp;

				bestellungenTabelle.Rows.Add(tabellenZeile);
			}
		}

		return bestellungenTabelle;
	}

	public List<Bestellung> BestellungenListe
	{
		get
		{
			return bestellungenListe;
		}
	}

    public void add(Bestellung aktbestellung)
	{
		bestellungenListe.Add(aktbestellung);
	}

    public void del(int aktid)
	{
        Bestellung loeschbestellung = null;
		bool existbestellung = false;

		foreach (Bestellung tempbestellung in bestellungenListe)
		{
			if (tempbestellung.Id == aktid)
			{
				existbestellung = true;
				loeschbestellung = tempbestellung;
				break;
			}
		}
		if (existbestellung)
		{
			bestellungenListe.Remove(loeschbestellung);
		}
	}

    public void neu(Bestellung aktbestellung)
	{
		//da das Feld ID "zu" ist, kommt bewut keine ID aus der Maske
		aktbestellung.Id = getAutoID();
		//die anderen Felder werden leer initialisiert
		aktbestellung.GaesteId = 0;
		aktbestellung.KuchenId = 0;
		aktbestellung.Datum = new DateTime(2000, 1, 1);
		aktbestellung.Menge = 0;
		aktbestellung.Bezahlt = false;

		bestellungenListe.Add(aktbestellung);
	}

    public void lesen()
	{
		StreamReader streamreader;
		String zeile;
		Bestellung tempbestellung;

		bestellungenListe.Clear();
		
        streamreader = new StreamReader(eingabeDateiname);
        
		try
		{
            while ((zeile = streamreader.ReadLine()) != null)
			{
				if (zeile.Length > 0)
				{
					tempbestellung = new Bestellung(zeile);
					add(tempbestellung);
				}
			}
		}

		catch (Exception e)
		{
			MessageBox.Show(e.Message);
		}

		finally
		{
            streamreader.Close();
        }
	}

    public void speichern()
	{
		StreamWriter streamwriter;
		String zeile;

		streamwriter = new StreamWriter(ausgabeDateiname);
		
        try
		{
            foreach (Bestellung tempbestellung in bestellungenListe)
            {
				zeile = tempbestellung.gesamt();
				streamwriter.WriteLine(zeile);
			}
		}

		catch (Exception e)
		{
			MessageBox.Show(e.Message);
		}

		finally
		{
            streamwriter.Close();
        }
	}
};