using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Data;
using System.Windows.Forms;

public class GaesteM
{
	List<Gast> gaesteListe;
	String eingabeDateiname;
	String ausgabeDateiname;

	int getAutoID()
	{
		int id = 1;
		foreach (Gast tempgast in gaesteListe)
		{
			if (tempgast.Id >= id)
			{
				id = tempgast.Id + 1;
			}
		}
		return id;
	}

    public GaesteM()
	{
		gaesteListe = new List<Gast>();
		eingabeDateiname = "gaeste.csv";
		ausgabeDateiname = "gaeste.csv";

		lesen();
	}

	~GaesteM()
	{
		speichern();
	}

	public void setInfos(Gast aktGast)
	{
		foreach (Gast tempgast in gaesteListe)
		{
			if (tempgast.Id == aktGast.Id)
			{
				tempgast.change(aktGast);
				break;
			}
		}
	}

	public Gast getInfos(int aktid)
	{
		foreach (Gast tempgast in gaesteListe)
		{
			if (tempgast.Id == aktid)
			{
				return tempgast;
			}
		}
		return null;
	}

    public DataTable getTabelle()
	{
		DataTable gaesteTabelle = new DataTable();

		gaesteTabelle.Columns.Add("ID", Type.GetType("System.Int32"));
		gaesteTabelle.Columns.Add("name", Type.GetType("System.String"));
		gaesteTabelle.Columns.Add("vorname", Type.GetType("System.String"));
		gaesteTabelle.Columns.Add("timestamp", Type.GetType("System.DateTime"));

		DataRow tabellenZeile;

		foreach (Gast tempgast in gaesteListe)
		{
			tabellenZeile = gaesteTabelle.NewRow();
			tabellenZeile["ID"] = tempgast.Id;
			tabellenZeile["name"] = tempgast.Name;
			tabellenZeile["vorname"] = tempgast.Vorname;
			tabellenZeile["timestamp"] = tempgast.Timestamp;

			gaesteTabelle.Rows.Add(tabellenZeile);
		}

		return gaesteTabelle;
	}

    public DataTable getTabelle(String suchmaske)
	{
		DataTable gaesteTabelle = new DataTable();

		gaesteTabelle.Columns.Add("ID", Type.GetType("System.Int32"));
		gaesteTabelle.Columns.Add("name", Type.GetType("System.String"));
		gaesteTabelle.Columns.Add("vorname", Type.GetType("System.String"));
		gaesteTabelle.Columns.Add("timestamp", Type.GetType("System.DateTime"));

		DataRow tabellenZeile;

		foreach (Gast tempgast in gaesteListe)
		{
			// wenn der Suchstring irgendwie vorkommt?
			// das schliet einen leeren Suchstring implizit mit ein
			if (tempgast.gesamt().Contains(suchmaske))
			{
				tabellenZeile = gaesteTabelle.NewRow();
				tabellenZeile["ID"] = tempgast.Id;
				tabellenZeile["name"] = tempgast.Name;
				tabellenZeile["vorname"] = tempgast.Vorname;
				tabellenZeile["timestamp"] = tempgast.Timestamp;

				gaesteTabelle.Rows.Add(tabellenZeile);
			}
		}

		return gaesteTabelle;
	}

	public List<Gast> GaesteListe
	{
		get
		{
			return gaesteListe;
		}
	}

    public void add(Gast aktgast)
	{
		gaesteListe.Add(aktgast);
	}

    public void del(int aktid)
	{
        Gast loeschenGast = null;
		bool existGast = false;

		foreach (Gast tempgast in gaesteListe)
		{
			if (tempgast.Id == aktid)
			{
				existGast = true;
				loeschenGast = tempgast;
				break;
			}
		}
		if (existGast)
		{
			gaesteListe.Remove(loeschenGast);
		}
	}

    public void neu(Gast aktGast)
	{
		//da das Feld ID "zu" ist, kommt bewut keine ID aus der Maske
		aktGast.Id = getAutoID();
		gaesteListe.Add(aktGast);
	}

    public void lesen()
	{
		StreamReader streamreader;
		String zeile;
		Gast tempGast;

		gaesteListe.Clear();
        streamreader = new StreamReader(eingabeDateiname);

		try
		{
			while ((zeile = streamreader.ReadLine()) != null)
			{
				if (zeile.Length > 0)
				{
					tempGast = new Gast(zeile);
					add(tempGast);
				}
			}
		}

		catch (Exception e)
		{
			MessageBox.Show(e.Message);
		}

		finally
		{
            streamreader.Close();
        }
	}

    public void speichern()
	{
		StreamWriter streamwriter;
		String zeile;

        streamwriter = new StreamWriter(ausgabeDateiname);
        
		try
		{
			foreach(Gast tempgast in gaesteListe)
			{
				zeile = tempgast.gesamt();
				streamwriter.WriteLine(zeile);
			}
		}

		catch (Exception e)
		{
			MessageBox.Show(e.Message);
		}

		finally
		{
			streamwriter.Close();
		}
	}
};
