﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace KuchenTest4
{
    public partial class KuchenWerte : Form
    {
		IKuchenBasar kuchenBasarIntern;
		KuchenM kuchenVerwaltungIntern;
		Kuchen aktKuchen;

        public KuchenWerte(IKuchenBasar kuchenbasar, KuchenM kuchenverwaltung)
		{
			InitializeComponent();

			kuchenBasarIntern = kuchenbasar;
			kuchenVerwaltungIntern = kuchenverwaltung;

			aktKuchen = kuchenVerwaltungIntern.getInfos(kuchenbasar.AktKuchenID);

			textBoxAnbieter.Text = aktKuchen.Anbieter;
			textBoxSorte.Text = aktKuchen.Sorte;
			textBoxBeschreibung.Text = aktKuchen.Beschreibung;
	
			numericUpDownAnzahl.Value = Convert.ToInt32(aktKuchen.Anzahl);

			dateTimePickerAbgabedatum.CustomFormat = "dd.MMM.yyyy, HH:mm:ss";
			dateTimePickerAbgabedatum.Value = Convert.ToDateTime(aktKuchen.Abgabedatum);

			checkBoxDiabetikergeeignet.Checked = aktKuchen.Diabetikergeeignet;
		}

        public KuchenWerte()
        {
            InitializeComponent();
        }

        void buttonAbbruch_Click(Object sender, EventArgs e)
		{
			this.Close();
		}

		void buttonSpeichern_Click(Object sender, EventArgs e)
		{
			aktKuchen.Id = kuchenBasarIntern.AktKuchenID;
			
			aktKuchen.Anbieter = textBoxAnbieter.Text;
			aktKuchen.Sorte = textBoxSorte.Text;
			aktKuchen.Beschreibung = textBoxBeschreibung.Text;
			aktKuchen.Anzahl = Convert.ToInt32(numericUpDownAnzahl.Value);
		
			//wieder Entfernen des Custom Format Kommas
			String tempAbgabedatum = dateTimePickerAbgabedatum.Text.Replace(',', ' ');
			aktKuchen.Abgabedatum = Convert.ToDateTime(tempAbgabedatum);

			aktKuchen.Diabetikergeeignet = checkBoxDiabetikergeeignet.Checked;

			kuchenVerwaltungIntern.setInfos(aktKuchen);

			this.Close();
		}
    }
}