﻿package util;

import java.text.*;
import java.util.regex.*;

public class DatenPlausi
{
  private static final boolean DEBUG = false;
 
  /**
   * Abstrakte Klasse zum Prüfen 
   * und Konvertieren bestimmter Datentypen
   */
  private DatenPlausi()
  {
  }

  /**
   * 
   * @param testDatum
   * @return das Datum entspricht dem Format DD.MM.YYYY
   */
  public static boolean okDatum(String testDatum)
  {
    boolean retValue = true;
    String ergebnis = pruefenDatum(testDatum);
    
    if ( ergebnis.indexOf( "Fehler" ) > -1 )
    {
      if (DEBUG)
        System.out.println( ergebnis );
      retValue = false;
    }
    else
      if (DEBUG)
        System.out.println( "wird akzeptiert: " + ergebnis );
 
    return retValue;
  }
  
  /**
   * 
   * @param testDouble
   * @return der Betrag ist positiv und mit 2 Dezimalstellen
   */
  public static boolean okGeld(String testDouble)
  {
    boolean retValue = true;
    String ergebnis = pruefenGeld(testDouble);
    
    if ( ergebnis.indexOf( "Fehler" ) > -1 )
    {
      if (DEBUG)
        System.out.println( ergebnis );
      retValue = false;
    }
    else
      if (DEBUG)
        System.out.println( "wird akzeptiert: " + ergebnis );
 
    return retValue;
  }
  
  private static String pruefenDatum( String testDate )
  {
    String retValue = "Fehler allgemein";
    DateFormat df = new SimpleDateFormat( "dd.MM.yyyy" );
 
    if ( testDate.length() != 10 ) 
      return "Fehler falsche Länge (nicht 10)"; 

    Pattern p = Pattern.compile( "\\d{2}\\.\\d{2}\\.\\d{4}" );
    Matcher m = p.matcher( testDate );
    if ( !m.find() )
      return "Fehler Aufbau nicht DD.MM.YYYY"; 

    df.getCalendar().setLenient( false );
    try
    {
      retValue = df.format( df.parse( testDate ) );
    }
    catch ( ParseException e )
    {
      return "Fehler nicht gültiges Datum";
    }

    return retValue;
  }

  private static String pruefenGeld( String testDouble )
  {
    Pattern p = Pattern.compile( "^\\d{1,8}([\\.,]\\d{1,2})?$" );  
    Matcher m = p.matcher( testDouble );
    if ( !m.find() )
      return "Fehler bei der Regex-Prüfung"; 

    try
    {
      Double.parseDouble( testDouble.replace( ',', '.' ) );
    }
    catch ( Exception ex )
    {
      return "Fehler beim Parsen";
    }

    return "OK";
  }

  /**
   * 
   * @param datum YYYY-MM-DD (englisch)
   * @return datum DD.MM.YYYY (deutsch)
   */
  public static String ef2df(String datum)
  {
    return datum.substring( 8, 10 ) + "." + 
           datum.substring( 5, 7 )  + "." + 
           datum.substring( 0, 4 );
  }

  /**
   * 
   * @param datum DD.MM.YYYY (deutsch)
   * @return datum YYYY-MM-DD (englisch)
   */
  public static String df2ef(String datum)
  {
    return datum.substring( 6, 10 ) + "-" + 
           datum.substring( 3, 5 )  + "-" + 
           datum.substring( 0, 2 );
  }
  
  /**
   * 
   * @param datum YYYY-MM-DD HH:MM:SS (englisch)
   * @return datum DD.MM.YYYY HH:MM:SS (deutsch)
   */
  public static String ts2df(String datum)
  {
    return datum.substring( 8, 10 ) + "." + 
           datum.substring( 5, 7 )  + "." + 
           datum.substring( 0, 4 )  + "   " +
           datum.substring( 11 );
  }

  
  public static boolean okIntMinMax( String source, int min, int max )
  {
    int temp;
    
    if ( source.length() == 0 )
      return false;
    
    try
    {
      temp = Integer.parseInt( source );
    }
    catch ( NumberFormatException e )
    {
      return false;
    } 
      
    if ( temp < min || temp > max )
      return false;
 
    return true;
  }
  
}
