package kuchenKloneMySQL;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

/**
 * Frame zur Eingabe/Prfung der Benutzer
 * 
 * @author Bernd Schubert
 * 
 */
public class BenutzerForm extends JDialog implements ActionListener, KeyListener, WindowListener
{
  /**
   * 
   */
  private static final long serialVersionUID = 20150305L;
  private JLabel            jLabelDummy;
  private Font              font;
  private JTextField        tfBenutzer;
  private JButton           btnOK, btnAbbrechen;

  private Component         owner;

  private int               benutzerIO       = -1;
  private boolean           hasChanged       = false;
  private String            aktBenutzer;

  //hier fest verdrahtet, Quelle kann auch z.B. DB, Properties oder File werden
  private String[]          benutzerFeld     =
                                             { "andrea", "bernd", "nikolaus", "alfa", "kathrin" };
  private String            admin            = "bernd";

  public BenutzerForm()
  {
    initializeComponent();
  }

  private void initializeComponent()
  {
    aktBenutzer = "";

    this.setTitle( "Benutzer" );
    this.setLayout( null );
    this.setSize( new Dimension( 290, 310 ) );
    this.setDefaultCloseOperation( JDialog.DO_NOTHING_ON_CLOSE );
    this.setResizable( false );
    this.addWindowListener( this );

    jLabelDummy = new JLabel( "Bitte den Benutzer eingeben:" );
    font = jLabelDummy.getFont().deriveFont( Font.BOLD, 13.0f );
    jLabelDummy.setFont( font );
    jLabelDummy.setBounds( 20, 10, 200, 25 );
    this.add( jLabelDummy );

    tfBenutzer = new JTextField();
    tfBenutzer.setBounds( 20, 35, 240, 25 );
    tfBenutzer.setFont( font );
    tfBenutzer.setMargin( new Insets( 0, 2, 0, 0 ) );
    tfBenutzer.addKeyListener( this );
    this.add( tfBenutzer );

    jLabelDummy = new JLabel( "Derzeit gltig sind :-)" );
    jLabelDummy.setFont( font );
    jLabelDummy.setBounds( 20, 90, 200, 25 );
    this.add( jLabelDummy );

    jLabelDummy = new JLabel( "andrea" );
    jLabelDummy.setFont( font );
    jLabelDummy.setBounds( 20, 120, 200, 25 );
    this.add( jLabelDummy );

    jLabelDummy = new JLabel( "nikolaus" );
    jLabelDummy.setFont( font );
    jLabelDummy.setBounds( 150, 120, 200, 25 );
    this.add( jLabelDummy );

    jLabelDummy = new JLabel( "kathrin" );
    jLabelDummy.setFont( font );
    jLabelDummy.setBounds( 20, 150, 200, 25 );
    this.add( jLabelDummy );

    jLabelDummy = new JLabel( "alfa" );
    jLabelDummy.setFont( font );
    jLabelDummy.setBounds( 150, 150, 200, 25 );
    this.add( jLabelDummy );

    jLabelDummy = new JLabel( "bernd (als admin)" );
    jLabelDummy.setFont( font );
    jLabelDummy.setBounds( 20, 180, 200, 25 );
    this.add( jLabelDummy );

    btnOK = new JButton( "OK" );
    btnOK.setFont( font );
    btnOK.setBounds( 20, 230, 110, 25 );
    btnOK.addActionListener( this );
    btnOK.setFocusable( false );
    this.add( btnOK );

    btnAbbrechen = new JButton( "Stop" );
    btnAbbrechen.setFont( font );
    btnAbbrechen.setBounds( 150, 230, 110, 25 );
    btnAbbrechen.addActionListener( this );
    btnAbbrechen.setFocusable( false );
    this.add( btnAbbrechen );
  }

  /**
   * 
   * @param owner
   * @return Status des Benutzers: 
   * -1 ... nicht aktuell 
   *  0 ... aktuell zugelassen 
   *  1 ... Admin Status
   */
  public int showDialog( Component owner )
  {
    this.owner = owner;
    return showDialog();
  }

  /**
   * 
   * @param owner
   * @return Status des Benutzers: 
   * -1 ... nicht aktuell 
   *  0 ... aktuell zugelassen 
   *  1 ... Admin Status
   */
  public int showDialog()
  {
    initDialog();
    this.setVisible( true );

    //weil der Dialog modal ist, kann hier noch der Rckgabewert bestimmt werden:
    //Berechtigung(0), Admin(1) bzw. keine (-1)
    return benutzerIO;
  }

  private void initDialog()
  {
    this.setModal( true );
    this.setLocationRelativeTo( owner );

    initFrame();
  }

  private void initFrame()
  {
  }

  private int benutzerAuswerten()
  {
    int retValue = -1;

    aktBenutzer = tfBenutzer.getText();

    if ( admin.equals( aktBenutzer ) )
      return 1;

    for ( String benutzer : benutzerFeld )
    {
      if ( benutzer.equals( aktBenutzer ) )
        return 0;
    }

    return retValue;
  }

  @Override
  public void windowOpened( WindowEvent e )
  {
  }

  @Override
  public void windowClosing( WindowEvent e )
  {
    if ( hasChanged )
      benutzerIO = benutzerAuswerten();

    this.dispose();
  }

  @Override
  public void windowClosed( WindowEvent e )
  {
  }

  @Override
  public void windowIconified( WindowEvent e )
  {
  }

  @Override
  public void windowDeiconified( WindowEvent e )
  {
  }

  @Override
  public void windowActivated( WindowEvent e )
  {
  }

  @Override
  public void windowDeactivated( WindowEvent e )
  {
  }

  @Override
  public void keyTyped( KeyEvent e )
  {
    int kc = e.getKeyChar();
    Object o = e.getSource();
    JTextField tf = (JTextField)o;

    if ( o == tfBenutzer )
    {
      if ( !( Character.isAlphabetic( kc ) || Character.isDigit( kc ) ) )
      {
        e.consume();
        return;
      }

      hasChanged = true;

      tf.replaceSelection( "" );
      if ( tf.getText().length() >= 32 )
      {
        e.consume();
        return;
      }
    }
  }

  @Override
  public void keyPressed( KeyEvent e )
  {
    int kc = e.getKeyCode();
    Object o = e.getSource();

    if ( o == tfBenutzer && kc == KeyEvent.VK_ENTER && tfBenutzer.getText().length() > 0 )
      windowClosing( new WindowEvent( this, WindowEvent.WINDOW_CLOSING ) );
  }

  @Override
  public void keyReleased( KeyEvent e )
  {
    int kc = e.getKeyCode();
    if ( kc == 27 )
    {
      hasChanged = false;
      windowClosing( new WindowEvent( this, WindowEvent.WINDOW_CLOSING ) );
    }
  }

  @Override
  public void actionPerformed( ActionEvent e )
  {
    Object o = e.getSource();

    if ( o == btnOK )
      windowClosing( new WindowEvent( this, WindowEvent.WINDOW_CLOSING ) );
    else if ( o == btnAbbrechen )
    {
      hasChanged = false;
      windowClosing( new WindowEvent( this, WindowEvent.WINDOW_CLOSING ) );
    }
  }
}
