---
--- (vorher User1) KuchenKloneOracle (ggf. nachher User2)
---
--- Sqript ausfhren von User nikolaus/lebkuchen
---
--- Erstellen der "KuchenBasar" Datenbank fr die Oracle-Version
--- meines Java-Programms (Projekt Alfatraining)
---

---
--- Tabellen erstellen
---

CREATE TABLE kuchen (
    id                 INT NOT NULL,
    anbieter           VARCHAR(50) NOT NULL,
    sorte              INT NOT NULL,
    kurzkuchen         VARCHAR(50) NOT NULL,
    beschreibung       VARCHAR(50) NOT NULL,
    abgabedatum        DATE NOT NULL,
    anzahl             INT NOT NULL,
    preis              DECIMAL(20,4) NOT NULL,
    diabetikergeeignet NUMBER NOT NULL,
    letzterzugriff     TIMESTAMP NOT NULL);

CREATE TABLE sorten (
    id                 INT NOT NULL,
    backwarensorte     VARCHAR(50) NOT NULL);

CREATE TABLE gaeste (
    id                 INT NOT NULL,
    gastname           VARCHAR(50) NOT NULL,
    vorname            VARCHAR(50) NOT NULL,
    kurzgast           VARCHAR(50) NOT NULL,
    einrichtung        INT NOT NULL,
    telefon            VARCHAR(50) NOT NULL,
    letzterzugriff     TIMESTAMP NOT NULL);

CREATE TABLE einrichtungen (
    id                 INT NOT NULL,
    einrichtung        VARCHAR(50) NOT NULL);
    
CREATE TABLE bestellungen (
    id                 INT NOT NULL,
    gast               INT NOT NULL,
    kuchen             INT NOT NULL,
    menge              INT NOT NULL,
    bestelldatum       DATE NOT NULL,
    gesamtpreis        DECIMAL(20,4) NOT NULL,
    bezahlt            NUMBER NOT NULL,
    abgeholt           NUMBER NOT NULL,
    letzterzugriff     TIMESTAMP NOT NULL);
 
---
--- Daten eingeben
---

INSERT ALL
INTO kuchen (id, anbieter, sorte, kurzkuchen, beschreibung, abgabedatum, anzahl, preis, diabetikergeeignet, letzterzugriff) 
VALUES (0, 'noch nicht bekannt', 0, 'noch nicht bekannt', ' ', CAST('04.03.2015' AS DATE), 0, 0.00 , 1, CAST('04.03.2015' AS TIMESTAMP))
INTO kuchen (id, anbieter, sorte, kurzkuchen, beschreibung, abgabedatum, anzahl, preis, diabetikergeeignet, letzterzugriff) 
VALUES (1, 'Frau Schmidt', 4, 'Hefekuchen', 'selbstgebacken', CAST('04.03.2015' AS DATE), 35, 0.45, 0, CAST('04.03.2015' AS TIMESTAMP))
INTO kuchen (id, anbieter, sorte, kurzkuchen, beschreibung, abgabedatum, anzahl, preis, diabetikergeeignet, letzterzugriff) 
VALUES (2, 'Grubenbcker', 2, 'Brtchen', 'nicht belegt', CAST('04.03.2015' AS DATE), 18, 1.25, 1, CAST('04.03.2015' AS TIMESTAMP))
INTO kuchen (id, anbieter, sorte, kurzkuchen, beschreibung, abgabedatum, anzahl, preis, diabetikergeeignet, letzterzugriff) 
VALUES (3, 'Konditorei', 3, 'Sahnetorte', ' ', CAST('04.03.2015' AS DATE), 12, 2.30, 0, CAST('04.03.2015' AS TIMESTAMP))
INTO kuchen (id, anbieter, sorte, kurzkuchen, beschreibung, abgabedatum, anzahl, preis, diabetikergeeignet, letzterzugriff) 
VALUES (5, 'Herr Mller', 3, 'Erdbeertorte', 'mit frischen Erdbeeren', CAST('04.03.2015' AS DATE), 20, 1.85, 0, CAST('04.03.2015' AS TIMESTAMP))
INTO kuchen (id, anbieter, sorte, kurzkuchen, beschreibung, abgabedatum, anzahl, preis, diabetikergeeignet, letzterzugriff) 
VALUES (10, 'Mecklenburger Backstube', 2, 'Ksebrtchen', ' ', CAST('04.03.2015' AS DATE), 25, 1.10, 1, CAST('04.03.2015' AS TIMESTAMP))
INTO kuchen (id, anbieter, sorte, kurzkuchen, beschreibung, abgabedatum, anzahl, preis, diabetikergeeignet, letzterzugriff) 
VALUES (15, 'Lila Bcker', 6, 'Punschkuchen ', 'Vorsicht Alkohol', CAST('04.03.2015' AS DATE), 10, 1.99, 1, CAST('04.03.2015' AS TIMESTAMP))
INTO kuchen (id, anbieter, sorte, kurzkuchen, beschreibung, abgabedatum, anzahl, preis, diabetikergeeignet, letzterzugriff) 
VALUES (16, 'Cafe Wien', 3, 'Sachertorte', 'original Wienerisch', CAST('04.03.2015' AS DATE), 12, 3.00, 0, CAST('04.03.2015' AS TIMESTAMP))
INTO kuchen (id, anbieter, sorte, kurzkuchen, beschreibung, abgabedatum, anzahl, preis, diabetikergeeignet, letzterzugriff) 
VALUES (18, 'Frau Krger', 1, 'Kirschkuchen', 'Spuckkuchen', CAST('04.03.2015' AS DATE), 25, 0.50, 1, CAST('04.03.2015' AS TIMESTAMP))
INTO kuchen (id, anbieter, sorte, kurzkuchen, beschreibung, abgabedatum, anzahl, preis, diabetikergeeignet, letzterzugriff) 
VALUES (19, 'Frau Meier', 1, 'Birne Helene', ' ', CAST('04.03.2015' AS DATE), 10, 1.00, 0, CAST('04.03.2015' AS TIMESTAMP))
INTO kuchen (id, anbieter, sorte, kurzkuchen, beschreibung, abgabedatum, anzahl, preis, diabetikergeeignet, letzterzugriff) 
VALUES (20, 'Herr Schulz', 1, 'Teufelskuchen', ' ', CAST('04.03.2015' AS DATE), 16, 2.22, 1, CAST('04.03.2015' AS TIMESTAMP))
INTO kuchen (id, anbieter, sorte, kurzkuchen, beschreibung, abgabedatum, anzahl, preis, diabetikergeeignet, letzterzugriff) 
VALUES (23, 'Frau Schubert', 4, 'Zuckerkuchen', 'mit Zimt', CAST('04.03.2015' AS DATE), 35, 0.75, 0, CAST('04.03.2015' AS TIMESTAMP))
INTO kuchen (id, anbieter, sorte, kurzkuchen, beschreibung, abgabedatum, anzahl, preis, diabetikergeeignet, letzterzugriff) 
VALUES (24, 'Richi Wagner', 2, 'Brtchen belegt', 'mit Kse/Schinken', CAST('04.03.2015' AS DATE), 16, 2.25, 1, CAST('04.03.2015' AS TIMESTAMP))
INTO kuchen (id, anbieter, sorte, kurzkuchen, beschreibung, abgabedatum, anzahl, preis, diabetikergeeignet, letzterzugriff) 
VALUES (25, 'Grfin Cosel', 1, 'Quarkkeulchen', 'mit Puderzucker', CAST('04.03.2015' AS DATE), 100, 0.40, 1, CAST('04.03.2015' AS TIMESTAMP))
INTO kuchen (id, anbieter, sorte, kurzkuchen, beschreibung, abgabedatum, anzahl, preis, diabetikergeeignet, letzterzugriff) 
VALUES (26, 'Grubenbcker', 6, 'Lebkuchenhaus', 'zum selber Abbauen und Essen', CAST('04.03.2015' AS DATE), 3, 18.00, 0, CAST('04.03.2015' AS TIMESTAMP))
SELECT * FROM dual;

INSERT ALL
INTO sorten (id, backwarensorte) VALUES (0, 'noch nicht bekannt')
INTO sorten (id, backwarensorte) VALUES (1, 'Kuchenstcke')
INTO sorten (id, backwarensorte) VALUES (2, 'Brot und Brtchen')
INTO sorten (id, backwarensorte) VALUES (3, 'Torten')
INTO sorten (id, backwarensorte) VALUES (4, 'Blechkuchen')
INTO sorten (id, backwarensorte) VALUES (6, 'Lebkuchen')
INTO sorten (id, backwarensorte) VALUES (8, 'Kleingebck')
SELECT * FROM dual;

INSERT ALL
INTO gaeste (id, gastname, vorname, kurzgast, einrichtung, telefon, letzterzugriff) 
VALUES (0, 'noch nicht bekannt', 'noch nicht bekannt', 'noch nicht bekannt', 0, ' ', CAST('04.03.2015' AS TIMESTAMP))
INTO gaeste (id, gastname, vorname, kurzgast, einrichtung, telefon, letzterzugriff) 
VALUES (1, 'Meier', 'Hans', 'Hans M', 2, '0381 381', CAST('04.03.2015' AS TIMESTAMP))
INTO gaeste (id, gastname, vorname, kurzgast, einrichtung, telefon, letzterzugriff) 
VALUES (2, 'Bednarz', 'Jana', 'Jana B', 1, ' ', CAST('04.03.2015' AS TIMESTAMP))
INTO gaeste (id, gastname, vorname, kurzgast, einrichtung, telefon, letzterzugriff) 
VALUES (3, 'Olsen', 'Egon', 'Egon Olsen', 3, '007 1234', CAST('04.03.2015' AS TIMESTAMP))
INTO gaeste (id, gastname, vorname, kurzgast, einrichtung, telefon, letzterzugriff) 
VALUES (4, 'Meier ', 'Frieda', 'Frieda M', 1, '0381 333', CAST('04.03.2015' AS TIMESTAMP))
INTO gaeste (id, gastname, vorname, kurzgast, einrichtung, telefon, letzterzugriff) 
VALUES (5, 'Holm-Jensen', ' ', 'Holm', 3, '555 897', CAST('04.03.2015' AS TIMESTAMP))
INTO gaeste (id, gastname, vorname, kurzgast, einrichtung, telefon, letzterzugriff) 
VALUES (10, 'Marx', 'Karl', 'Karl M', 5, '777', CAST('04.03.2015' AS TIMESTAMP))
INTO gaeste (id, gastname, vorname, kurzgast, einrichtung, telefon, letzterzugriff) 
VALUES (11, 'Bolte', 'Witwe', 'Witwe Bolte', 6, ' ', CAST('04.03.2015' AS TIMESTAMP))
INTO gaeste (id, gastname, vorname, kurzgast, einrichtung, telefon, letzterzugriff) 
VALUES (12, 'Buben', 'Max', 'Max', 6, ' ', CAST('04.03.2015' AS TIMESTAMP))
INTO gaeste (id, gastname, vorname, kurzgast, einrichtung, telefon, letzterzugriff) 
VALUES (13, 'Buben', 'Moritz', 'Moritz', 6, ' ', CAST('04.03.2015' AS TIMESTAMP))
INTO gaeste (id, gastname, vorname, kurzgast, einrichtung, telefon, letzterzugriff) 
VALUES (15, 'Lempel', ' ', 'Lehrer Lempel', 2, '23', CAST('04.03.2015' AS TIMESTAMP))
INTO gaeste (id, gastname, vorname, kurzgast, einrichtung, telefon, letzterzugriff) 
VALUES (16, 'Karlsen', 'Lisa', 'Lisa K', 2, '456', CAST('04.03.2015' AS TIMESTAMP))
INTO gaeste (id, gastname, vorname, kurzgast, einrichtung, telefon, letzterzugriff) 
VALUES (17, 'Schubert', 'Bernd', 'Bernd S', 1, '0381 555666777', CAST('04.03.2015' AS TIMESTAMP))
SELECT * FROM dual;

INSERT ALL
INTO einrichtungen (id, einrichtung) VALUES (0, 'noch nicht bekannt')
INTO einrichtungen (id, einrichtung) VALUES (1, 'Alfatraining')
INTO einrichtungen (id, einrichtung) VALUES (2, 'Schule')
INTO einrichtungen (id, einrichtung) VALUES (3, 'Olsenbande')
INTO einrichtungen (id, einrichtung) VALUES (5, 'Volkshochschule')
INTO einrichtungen (id, einrichtung) VALUES (6, 'WilhelmBusch Kindergarten')
SELECT * FROM dual;

INSERT ALL
INTO bestellungen (id, gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, abgeholt, letzterzugriff) 
VALUES (1, 15, 2, 2, CAST('04.03.2015' AS DATE), 2.90, 1, 1, CAST('04.03.2015' AS TIMESTAMP))
INTO bestellungen (id, gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, abgeholt, letzterzugriff) 
VALUES (2, 3, 10, 5, CAST('04.03.2015' AS DATE), 3.75, 1, 0, CAST('04.03.2015' AS TIMESTAMP))
INTO bestellungen (id, gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, abgeholt, letzterzugriff) 
VALUES (6, 10, 20, 4, CAST('04.03.2015' AS DATE), 8.88, 0, 1, CAST('04.03.2015' AS TIMESTAMP))
INTO bestellungen (id, gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, abgeholt, letzterzugriff) 
VALUES (7, 2, 5, 1, CAST('04.03.2015' AS DATE), 1.00, 0, 0, CAST('04.03.2015' AS TIMESTAMP))
INTO bestellungen (id, gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, abgeholt, letzterzugriff) 
VALUES (8, 11, 25, 10, CAST('04.03.2015' AS DATE), 5.00, 1, 0, CAST('04.03.2015' AS TIMESTAMP))
INTO bestellungen (id, gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, abgeholt, letzterzugriff) 
VALUES (9, 12, 15, 2, CAST('04.03.2015' AS DATE), 1.50, 1, 0, CAST('04.03.2015' AS TIMESTAMP))
INTO bestellungen (id, gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, abgeholt, letzterzugriff) 
VALUES (10, 13, 1, 3, CAST('04.03.2015' AS DATE), 2.25, 0, 1, CAST('04.03.2015' AS TIMESTAMP))
INTO bestellungen (id, gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, abgeholt, letzterzugriff) 
VALUES (12, 16, 5, 1, CAST('04.03.2015' AS DATE), 1.40, 0, 1, CAST('04.03.2015' AS TIMESTAMP))
INTO bestellungen (id, gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, abgeholt, letzterzugriff) 
VALUES (13, 3, 18, 3, CAST('04.03.2015' AS DATE), 0.60, 1, 1, CAST('04.03.2015' AS TIMESTAMP))
INTO bestellungen (id, gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, abgeholt, letzterzugriff) 
VALUES (14, 4, 19, 1, CAST('04.03.2015' AS DATE), 1.00, 0, 0, CAST('04.03.2015' AS TIMESTAMP))
INTO bestellungen (id, gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, abgeholt, letzterzugriff) 
VALUES (15, 3, 23, 2, CAST('04.03.2015' AS DATE), 4.00, 1, 0, CAST('04.03.2015' AS TIMESTAMP))
INTO bestellungen (id, gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, abgeholt, letzterzugriff) 
VALUES (16, 4, 23, 1, CAST('04.03.2015' AS DATE), 1.50, 0, 1, CAST('04.03.2015' AS TIMESTAMP))
INTO bestellungen (id, gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, abgeholt, letzterzugriff) 
VALUES (17, 15, 24, 3, CAST('04.03.2015' AS DATE), 12.00, 0, 1, CAST('04.03.2015' AS TIMESTAMP))
INTO bestellungen (id, gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, abgeholt, letzterzugriff) 
VALUES (23, 16, 3, 2, CAST('04.03.2015' AS DATE), 1.20, 1, 0, CAST('04.03.2015' AS TIMESTAMP))
INTO bestellungen (id, gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, abgeholt, letzterzugriff) 
VALUES (24, 5, 16, 2, CAST('04.03.2015' AS DATE), 6.00, 0, 1, CAST('04.03.2015' AS TIMESTAMP))
INTO bestellungen (id, gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, abgeholt, letzterzugriff) 
VALUES (25, 17, 26, 3, CAST('04.03.2015' AS DATE), 61.60, 1, 0, CAST('04.03.2015' AS TIMESTAMP))
INTO bestellungen (id, gast, kuchen, menge, bestelldatum, gesamtpreis, bezahlt, abgeholt, letzterzugriff) 
VALUES (26, 11, 26, 2, CAST('04.03.2015' AS DATE), 36.00, 0, 0, CAST('04.03.2015' AS TIMESTAMP))
SELECT * FROM dual;

COMMIT;

---
--- Primary Key
---
    
ALTER TABLE kuchen
ADD  CONSTRAINT kuchen_PK 
     PRIMARY KEY (id);

ALTER TABLE sorten
ADD  CONSTRAINT sorten_PK 
     PRIMARY KEY (id);

ALTER TABLE gaeste
ADD  CONSTRAINT gaeste_PK 
     PRIMARY KEY (id);

ALTER TABLE einrichtungen
ADD  CONSTRAINT einrichtungen_PK 
     PRIMARY KEY (id);

ALTER TABLE bestellungen
ADD  CONSTRAINT bestellungen_PK 
     PRIMARY KEY (id);

---
--- Foreign Key
---

ALTER TABLE kuchen
ADD CONSTRAINT kuchen_sorte_FK 
    FOREIGN KEY (sorte) REFERENCES sorten (id);
ALTER TABLE kuchen ENABLE CONSTRAINT kuchen_sorte_FK;

ALTER TABLE gaeste
ADD CONSTRAINT gaeste_einrichtung_FK 
    FOREIGN KEY (einrichtung) REFERENCES einrichtungen (id);
ALTER TABLE gaeste ENABLE CONSTRAINT gaeste_einrichtung_FK;

ALTER TABLE bestellungen
ADD CONSTRAINT bestellungen_kuchen_FK 
    FOREIGN KEY (kuchen) REFERENCES kuchen (id);
ALTER TABLE bestellungen ENABLE CONSTRAINT bestellungen_kuchen_FK;

ALTER TABLE bestellungen
ADD CONSTRAINT bestellungen_gast_FK 
    FOREIGN KEY (gast) REFERENCES gaeste (id);
ALTER TABLE bestellungen ENABLE CONSTRAINT bestellungen_gast_FK;

---
--- Defaults
---

ALTER TABLE kuchen 
MODIFY (abgabedatum DATE DEFAULT CURRENT_DATE,
        letzterzugriff TIMESTAMP DEFAULT CURRENT_TIMESTAMP);         

ALTER TABLE gaeste
MODIFY (letzterzugriff TIMESTAMP DEFAULT CURRENT_TIMESTAMP);         

ALTER TABLE bestellungen
MODIFY (bestelldatum DATE DEFAULT CURRENT_DATE,
        letzterzugriff TIMESTAMP DEFAULT CURRENT_TIMESTAMP);         

---
--- Indexe
---

CREATE INDEX kuchen_sorte_IX ON kuchen
(
	sorte ASC
);
CREATE INDEX kuchen_kurz_IX ON kuchen
(
	kurzkuchen ASC
);

CREATE INDEX gaeste_einrichtung_IX ON gaeste
(
	einrichtung ASC
);
CREATE INDEX gaeste_kurzgast_IX ON gaeste
(
	kurzgast ASC
);

CREATE INDEX bestellungen_kuchen_IX ON bestellungen
(
	kuchen ASC
);
CREATE INDEX bestellungen_gast_IX ON bestellungen
(
	gast ASC
);

---
--- AutoIncrement, um zu SQLite/MySQL/SQL-Server kompatibel zu sein
---

CREATE SEQUENCE kuchen_seq
START WITH 27
INCREMENT BY 1
NOMAXVALUE; 

CREATE TRIGGER kuchen_trigger
BEFORE INSERT ON kuchen
FOR EACH ROW
BEGIN
SELECT kuchen_seq.NEXTVAL INTO :new.id FROM dual; END;
/

CREATE SEQUENCE sorten_seq
START WITH 9
INCREMENT BY 1
NOMAXVALUE; 

CREATE TRIGGER sorten_trigger
BEFORE INSERT ON sorten
FOR EACH ROW
BEGIN
SELECT sorten_seq.NEXTVAL INTO :new.id FROM dual; END;
/

CREATE SEQUENCE gaeste_seq
START WITH 18
INCREMENT BY 1
NOMAXVALUE; 

CREATE TRIGGER gaeste_trigger
BEFORE INSERT ON gaeste
FOR EACH ROW
BEGIN
SELECT gaeste_seq.NEXTVAL INTO :new.id FROM dual; END;
/

CREATE SEQUENCE einrichtungen_seq
START WITH 7
INCREMENT BY 1
NOMAXVALUE; 

CREATE TRIGGER einrichtungen_trigger
BEFORE INSERT ON einrichtungen
FOR EACH ROW
BEGIN
SELECT einrichtungen_seq.NEXTVAL INTO :new.id FROM dual; END;
/

CREATE SEQUENCE bestellungen_seq
START WITH 27
INCREMENT BY 1
NOMAXVALUE; 

CREATE TRIGGER bestellungen_trigger
BEFORE INSERT ON bestellungen
FOR EACH ROW
BEGIN
SELECT bestellungen_seq.NEXTVAL INTO :new.id FROM dual; END;
/

---
--- Views
---

CREATE VIEW kuchenview
AS
SELECT  kuchen.id, kuchen.kurzkuchen, kuchen.anbieter, kuchen.beschreibung, sorten.backwarensorte as sorte, 
        kuchen.abgabedatum, kuchen.anzahl, kuchen.preis, kuchen.diabetikergeeignet, kuchen.letzterzugriff
FROM    kuchen INNER JOIN sorten ON kuchen.sorte = sorten.id;

CREATE VIEW gaesteview
AS
SELECT  gaeste.id, gaeste.kurzgast, gaeste.gastname, gaeste.vorname, einrichtungen.einrichtung, 
        gaeste.telefon, gaeste.letzterzugriff
FROM    gaeste INNER JOIN einrichtungen ON gaeste.einrichtung = einrichtungen.id;

CREATE VIEW bestellungenview
AS
SELECT bestellungen.id, bestellungen.bestelldatum, gaeste.kurzgast, kuchen.kurzkuchen, bestellungen.menge, 
       bestellungen.gesamtpreis, bestellungen.bezahlt, bestellungen.abgeholt, gaeste.gastname, gaeste.vorname, 
       einrichtungen.einrichtung, kuchen.anbieter, kuchen.beschreibung, sorten.backwarensorte as sorte, 
       bestellungen.letzterzugriff, bestellungen.gast, bestellungen.kuchen
FROM   sorten INNER JOIN 
      (kuchen INNER JOIN 
      (einrichtungen INNER JOIN 
      (gaeste INNER JOIN bestellungen
       ON gaeste.ID = bestellungen.gast) 
       ON einrichtungen.ID = gaeste.einrichtung) 
       ON kuchen.ID = bestellungen.kuchen) 
       ON sorten.ID = kuchen.Sorte;

--SELECT  * 
--FROM    kuchenview;

--SELECT  *
--FROM    gaesteview;

--SELECT  *
--FROM    bestellungenview;