package kuchenKloneOracle;

import java.sql.*;
import java.util.ArrayList;

import javax.swing.JOptionPane;

import util.ListItem;

public class EinrichtungenDB
{
  private EinrichtungenDB()
  {
  }

  /**
   * 
   * @param ID
   * @return Einrichtung (Vollname)
   */
  public static Einrichtung getEinrichtung( int ID )
  {
    String sql = " SELECT ID, einrichtung ";
          sql += " FROM einrichtungen ";
          sql += " WHERE ID = ? ";

    PreparedStatement prepStatement = DBConnection.prepareStatement( sql );
    ResultSet result = null;
    Einrichtung retValue = new Einrichtung();

    try
    {
      prepStatement.setInt( 1, ID );

      result = prepStatement.executeQuery();

      if ( result != null )
      {
        result.next();
        retValue.setID( result.getInt( 1 ) );
        retValue.setEinrichtung( result.getString( 2 ) );
      }
    }

    catch ( Exception ex )
    {
      JOptionPane.showMessageDialog(
          null,
          "Fehler beim ID-Zugriff auf die Tabelle Einrichtungen: " + ex.getMessage(),
          "db-Fehler",
          JOptionPane.ERROR_MESSAGE
          );
    }

    return retValue;
  }

  /**
   * 
   * @return
   */
  public static ArrayList<ListItem> getEinrichtungenListe()
  {
    String sql = " SELECT ID, einrichtung ";
          sql += " FROM einrichtungen ";
          sql += " ORDER BY 1 ";

    PreparedStatement prepStatement = DBConnection.prepareStatement( sql );
    ResultSet result = null;
    ArrayList<ListItem> retValue = new ArrayList<ListItem>();

    try
    {
      result = prepStatement.executeQuery();

      while ( result.next() )
      {
        ListItem listitem = new ListItem( result.getInt( 1 ), result.getString( 2 ) );
        retValue.add( listitem );
      }
    }

    catch ( Exception ex )
    {
      JOptionPane.showMessageDialog(
          null,
          "Fehler beim Liste-Zugriff auf die Tabelle Einrichtungen: " + ex.getMessage(),
          "db-Fehler",
          JOptionPane.ERROR_MESSAGE
          );
    }

    return retValue;
  }
}