package kuchenKloneOracle;

import java.text.*;
import java.util.Date;

/**
 * Schnittstellenobjekt Gast
 * 
 * @author Bernd Schubert
 * 
 */
public class Gast
{
  private int     ID;
  private String  gastname;
  private String  vorname;
  private String  kurzgast;
  private int     einrichtung;
  private String  einrichtungname;
  private String  telefon;
  private String  letzterzugriff;
  private boolean fehler;

  //Im Java soll per Festlegung das deutsche Datumsformat gelten, auch wenn SQLite dann was anderes will
  DateFormat      df = new SimpleDateFormat( "dd.MM.yyyy" );

  /**
   * Neuer Gast
   */
  public Gast()
  {
    setID( 0 );
    setName( "" );
    setVorname( "" );
    setKurzname( "" );
    setEinrichtung( 0 );
    setTelefon( "" );
    this.letzterzugriff = df.format( new Date() );
    this.fehler = false;
  }

  /**
   * Gast aus den gegebenen Werten
   * 
   * @param ID
   * @param gastname
   * @param vorname
   * @param kurzname
   * @param einrichtung
   * @param telefon
   * @param letzterzugriff
   */
  public Gast(
      int ID,
      String gastname,
      String vorname,
      String kurzname,
      int einrichtung,
      String telefon,
      String letzterzugriff )
  {
    this.ID = ID;
    this.gastname = gastname;
    this.vorname = vorname;
    this.kurzgast = kurzname;
    this.einrichtung = einrichtung;
    this.telefon = telefon;
    this.letzterzugriff = letzterzugriff;
    this.fehler = false;
  }

  /**
   * Gast aus dem CSV-Format
   * 
   * @param zeile
   */
  public Gast( String zeile )
  {
    String[] split = zeile.split( ";" );
    //Das Insert berschreibt die ID und letzten Zugriff jedoch spter
    try
    {
      this.fehler = false;
      this.ID = Integer.parseInt( split[0] );
      this.gastname = split[1];
      this.vorname = split[2];
      this.kurzgast = split[3];
      this.einrichtung = Integer.parseInt( split[4] );
      this.telefon = split[5];
      this.letzterzugriff = split[6];
    }
    catch ( NumberFormatException e )
    {
      this.fehler = true;
      //System.err.println( "Fehler beim Konvertieren importierte Zeile: " + zeile );
    }

    //System.out.println("Ergebnis:" + getGesamt());
  }

  public int getID()
  {
    return ID;
  }

  public void setID( int ID )
  {
    this.ID = ID;
  }

  public boolean getFehler()
  {
    return fehler;
  }

  /**
   * 
   * @return Exportformat als CSV
   */
  public String getGesamt()
  {
    return String.valueOf( ID ) + ";" +
        gastname + ";" +
        vorname + ";" +
        kurzgast + ";" +
        String.valueOf( einrichtung ) + ";" +
        telefon + ";" +
        letzterzugriff;
  }

  public String getName()
  {
    return gastname;
  }

  public void setName( String gastname )
  {
    this.gastname = gastname;
  }

  public String getVorname()
  {
    return vorname;
  }

  public void setVorname( String vorname )
  {
    this.vorname = vorname;
  }

  public String getKurzname()
  {
    return kurzgast;
  }

  public void setKurzname( String kurzgast )
  {
    this.kurzgast = kurzgast;
  }

  public int getEinrichtung()
  {
    return einrichtung;
  }

  public void setEinrichtung( int einrichtung )
  {
    this.einrichtung = einrichtung;
  }

  public String getEinrichtungname()
  {
    return einrichtungname;
  }

  public void setEinrichtungname( String einrichtungname )
  {
    this.einrichtungname = einrichtungname;
  }

  public String getTelefon()
  {
    return telefon;
  }

  public void setTelefon( String telefon )
  {
    this.telefon = telefon;
  }

  public String getLetzterzugriff()
  {
    return letzterzugriff;
  }

  public void setLetzterzugriff( String letzterzugriff )
  {
    this.letzterzugriff = letzterzugriff;
  }
}
