package kuchenKloneOracle;

import java.awt.*;
import java.awt.event.*;
import java.io.*;

import javax.swing.*;

/**
 * Kurzbeschreibung anzeigen fr das Kuchenbasarprogramm
 * 
 * @author Bernd Schubert
 * 
 */
public class Hilfe extends JDialog implements WindowListener
{
  /**
   * 
   */
  private static final long serialVersionUID = 20150528L;
  private String            dateiname        = "kuchenkloneoracle.hlp";
  private String            initString       = "Dies ist das KuchenBasar Verwaltungsprogramm" +
                                                 " von Bernd Schubert, Alfatraining Rostock";
  private String            fehlerString;
  private File              hilfeFile;

  private Component         owner;
  private JTextArea         textArea;
  private JScrollPane       textAreaScrollPane;

  /**
   * Die Hilfe wird initialisiert (Pfad und Hilfedatei)
   */
  public Hilfe( Component owner, String pfad )
  {
    this.owner = owner;
    this.hilfeFile = new File( pfad + dateiname );
    fehlerString = "Die Hilfedatei: " + pfad + dateiname + " kann nicht gefunden werden";

    initializeComponent();
  }

  private void initializeComponent()
  {
    this.setTitle( "Kurzbeschreibung" );
    this.setLayout( null );
    this.setBounds( 10, 10, 800, 480 );

    this.setDefaultCloseOperation( JDialog.DO_NOTHING_ON_CLOSE );
    this.setResizable( false );
    this.addWindowListener( this );

    textArea = new JTextArea();
    textArea.setEditable( false );
    textArea.setLineWrap( true );
    textArea.setWrapStyleWord( true );
    Font font = textArea.getFont().deriveFont( Font.BOLD, 13.0f );
    textArea.setFont( font );
    textArea.setMargin( new Insets( 3, 3, 3, 3 ) );
    textArea.setText( initString );

    textAreaScrollPane = new JScrollPane( textArea );
    textAreaScrollPane.setBounds( 5, 5, 780, 440 );
    textAreaScrollPane.setVerticalScrollBarPolicy( JScrollPane.VERTICAL_SCROLLBAR_ALWAYS );

    this.add( textAreaScrollPane );
  }

  public void showDialog( Component owner )
  {
    this.owner = owner;
    showDialog();
  }

  public void showDialog()
  {
    initDialog();
    this.setVisible( true );
  }

  private void initDialog()
  {
    this.setModal( true );
    this.setLocationRelativeTo( owner );
    this.setLocation( 60, 60 );

    initFrame();
  }

  private void initFrame()
  {
    dateiLesenTextArea( hilfeFile );
  }

  /**
   * Die Hilfedatei wird auf die Anzeigeflche gebracht
   * 
   * @param hilfeFile
   */
  private void dateiLesenTextArea( File hilfeFile )
  {
    FileReader fr = null;
    textArea.setText( "" );

    try
    {
      fr = new FileReader( hilfeFile );
      textArea.read( fr, null );
    }
    catch ( Exception ex )
    {
      JOptionPane.showMessageDialog(
          owner,
          fehlerString,
          "E/A - Fehler ",
          JOptionPane.ERROR_MESSAGE
          );

      textArea.setText( initString );
      return;
    }

    try
    {
      fr.close();
    }
    catch ( IOException e )
    {
    }
  }

  @Override
  public void windowOpened( WindowEvent e )
  {
  }

  @Override
  public void windowClosing( WindowEvent e )
  {
    this.dispose();
  }

  @Override
  public void windowClosed( WindowEvent e )
  {
  }

  @Override
  public void windowIconified( WindowEvent e )
  {
  }

  @Override
  public void windowDeiconified( WindowEvent e )
  {
  }

  @Override
  public void windowActivated( WindowEvent e )
  {
  }

  @Override
  public void windowDeactivated( WindowEvent e )
  {
  }
}
