package kuchenBasar;

import java.text.*;
import java.util.Date;

/**
 * Schnittstellenobjekt Bestellung
 * 
 * @author Bernd Schubert
 * 
 */
public class Bestellung
{
  private int     ID;
  private int     gast;
  private int     kuchen;
  private String  bestelldatum;
  private int     menge;
  private double  gesamtpreis;
  private boolean bezahlt;
  private boolean abgeholt;
  private String  letzterzugriff;
  private boolean fehler;

  //Im Java soll per Festlegung das deutsche Datumsformat gelten, auch wenn SQLite dann was anderes will
  DateFormat      df = new SimpleDateFormat( "dd.MM.yyyy" );

  /**
   * Neue Bestellung
   */
  public Bestellung()
  {
    setID( 0 );
    setGast( 0 );
    setKuchen( 0 );
    setBestelldatum( df.format( new Date() ) );
    setMenge( 0 );
    setGesamtpreis( 0.0 );
    setBezahlt( false );
    setAbgeholt( false );
    this.letzterzugriff = df.format( new Date() );
    this.fehler = false;
  }

  /**
   * 
   * @param ID
   * @param gast
   * @param kuchen
   * @param bestelldatum
   * @param menge
   * @param gesamtpreis
   * @param bezahlt
   * @param abgeholt
   * @param letzterzugriff
   */
  public Bestellung(
      int ID,
      int gast,
      int kuchen,
      String bestelldatum,
      int menge,
      double gesamtpreis,
      boolean bezahlt,
      boolean abgeholt,
      String letzterzugriff )
  {
    this.ID = ID;
    this.gast = gast;
    this.kuchen = kuchen;
    this.bestelldatum = bestelldatum;
    this.menge = menge;
    this.gesamtpreis = gesamtpreis;
    this.bezahlt = bezahlt;
    this.abgeholt = abgeholt;
    this.letzterzugriff = letzterzugriff;
    this.fehler = false;
  }

  /**
   * Bestellung aus dem CSV-Format
   * 
   * @param zeile
   */
  public Bestellung( String zeile )
  {
    String[] split = zeile.split( ";" );
    //Das Insert berschreibt die ID und letzten Zugriff jedoch spter
    try
    {
      this.fehler = false;
      this.ID = Integer.parseInt( split[0] );
      this.gast = Integer.parseInt( split[1] );
      this.kuchen = Integer.parseInt( split[2] );
      this.bestelldatum = split[3];
      this.menge = Integer.parseInt( split[4] );
      this.gesamtpreis = Double.parseDouble( split[5] );
      this.bezahlt = Boolean.parseBoolean( split[6] );
      this.abgeholt = Boolean.parseBoolean( split[7] );
      this.letzterzugriff = split[8];
    }
    catch ( NumberFormatException e )
    {
      this.fehler = true;
      //System.err.println( "Fehler beim Konvertieren importierte Zeile: " + zeile );
    }

    //System.out.println("Ergebnis:" + getGesamt());
  }

  public int getID()
  {
    return ID;
  }

  public void setID( int ID )
  {
    this.ID = ID;
  }

  public boolean getFehler()
  {
    return fehler;
  }

  public int getGast()
  {
    return gast;
  }

  public void setGast( int gast )
  {
    this.gast = gast;
  }

  public int getKuchen()
  {
    return kuchen;
  }

  public void setKuchen( int kuchen )
  {
    this.kuchen = kuchen;
  }

  public String getBestelldatum()
  {
    return bestelldatum;
  }

  public void setBestelldatum( String bestelldatum )
  {
    this.bestelldatum = bestelldatum;
  }

  public int getMenge()
  {
    return menge;
  }

  public void setMenge( int menge )
  {
    this.menge = menge;
  }

  public double getGesamtpreis()
  {
    return gesamtpreis;
  }

  public void setGesamtpreis( double gesamtpreis )
  {
    this.gesamtpreis = gesamtpreis;
  }

  public boolean isBezahlt()
  {
    return bezahlt;
  }

  public void setBezahlt( boolean bezahlt )
  {
    this.bezahlt = bezahlt;
  }

  public boolean isAbgeholt()
  {
    return abgeholt;
  }

  public void setAbgeholt( boolean abgeholt )
  {
    this.abgeholt = abgeholt;
  }

  public String getLetzterzugriff()
  {
    return letzterzugriff;
  }

  public void setLetzterzugriff( String letzterzugriff )
  {
    this.letzterzugriff = letzterzugriff;
  }

  /**
   * 
   * @return Exportformat als CSV
   */
  public String getGesamt()
  {
    return String.valueOf( ID ) + ";" +
        String.valueOf( gast ) + ';' +
        String.valueOf( kuchen ) + ';' +
        bestelldatum + ';' +
        String.valueOf( menge ) + ';' +
        String.valueOf( gesamtpreis ) + ';' +
        String.valueOf( bezahlt ) + ';' +
        String.valueOf( abgeholt ) + ';' +
        letzterzugriff;
  }
}
