package kuchenBasar;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.Properties;

import javax.swing.*;

import util.*;
import util.WinUtil.*;

public class MainFrame extends JFrame implements WindowListener, ActionListener
{
  /**
   * 
   */
  private static final long serialVersionUID   = 20150305L;
  private boolean           admin              = true;
  private final String      userhome           = System.getProperty( "user.home" ) + "/documents/";
  private String            dbpfad             = userhome;
  private String            properties         = userhome + "kuchenbasar.prop";
  private String            database           = "kuchenbasar.s3db";

  public StatusBar          statusBar;
  private JMenuBar          menuBar;
  private JMenu             menuDatei, menuVerwaltung, menuExtra, menuHilfe;
  private JMenuItem         miBeenden, miInfo, miKurz, miAdmin;

  private final int         BASAR_KUCHEN       = 0;
  private final int         BASAR_GAESTE       = 1;
  private final int         BASAR_BESTELLUNGEN = 2;

  protected JMenuItem[]     miKuchenBasar      = new JMenuItem[3];
  protected boolean[]       isAktiv            =
                                               { false, false, false };
  private int               keyKuchen          = 1;
  private int               keyGaeste          = 1;
  private int               keyBestellungen    = 1;

  public MainFrame()
  {
    loadSettings();
    initializeComponent();
  }

  private void initializeComponent()
  {
    this.setTitle( "Kuchenbasar" );
    this.setBounds( 10, 10, 800, 480 );

    this.setDefaultCloseOperation( JFrame.DO_NOTHING_ON_CLOSE );
    this.addWindowListener( this );

    this.setLayout( new BorderLayout() );

    menuBar = new JMenuBar();

    menuDatei = WinUtil.createMenu( menuBar, "Datei", "file", KeyEvent.VK_D );
    miBeenden = WinUtil.createMenuItem( menuDatei, "Beenden", "exit", MenuItemType.ITEM_PLAIN,
        this, null, KeyEvent.VK_E, "Programm beenden" );

    menuVerwaltung = WinUtil.createMenu( menuBar, "Verwaltung", "data", KeyEvent.VK_D );
    miKuchenBasar[BASAR_KUCHEN] = WinUtil.createMenuItem( menuVerwaltung, "Kuchen anzeigen",
        "kuchen", MenuItemType.ITEM_PLAIN, this, null, KeyEvent.VK_K, "Kuchen anzeigen" );
    miKuchenBasar[BASAR_GAESTE] = WinUtil.createMenuItem( menuVerwaltung, "Gste anzeigen",
        "gaeste", MenuItemType.ITEM_PLAIN, this, null, KeyEvent.VK_G, "Gste anzeigen" );
    miKuchenBasar[BASAR_BESTELLUNGEN] = WinUtil.createMenuItem( menuVerwaltung, "Bestellungen anzeigen",
        "bestellungen", MenuItemType.ITEM_PLAIN, this, null, KeyEvent.VK_B, "Bestellungen anzeigen" );

    menuExtra = WinUtil.createMenu( menuBar, "Extra", "extra", KeyEvent.VK_X );
    miAdmin = WinUtil.createMenuItem( menuExtra, "Admin", "admin", MenuItemType.ITEM_CHECK,
        this, null, KeyEvent.VK_A, "Admin" );

    menuHilfe = WinUtil.createMenu( menuBar, "Hilfe", "hilfe", KeyEvent.VK_H );
    miInfo = WinUtil.createMenuItem( menuHilfe, "Info", "info", MenuItemType.ITEM_PLAIN,
        this, null, KeyEvent.VK_I, "Info" );
    miKurz = WinUtil.createMenuItem( menuHilfe, "Kurzbeschreibung", "kurz", MenuItemType.ITEM_PLAIN,
        this, null, KeyEvent.VK_K, "Kurzbeschreibung" );

    this.setJMenuBar( menuBar );

    statusBar = new StatusBar();
    statusBar.setPreferredSize( new Dimension( 0, 25 ) );

    this.add( statusBar, BorderLayout.SOUTH );
  }

  public void Show()
  {
    initFrame();
    this.setVisible( true );
  }

  public void Show( int erlaubnis )
  {
    this.admin = ( erlaubnis > 0 );
    this.miAdmin.setSelected( admin );
    Show();
  }

  private void initFrame()
  {
    statusBar.setMessage( "Bereit..." );
    statusBar.setText( " Verbindung wird aufgebaut" );

    openSQLiteDatabase();
  }

  private void anzeigenKuchen()
  {
    if ( !isAktiv[BASAR_KUCHEN] )
    {
      statusBar.setMessage( "Verwalten Kuchen" );
      KuchenBasarTable dlg = new KuchenBasarTable( BASAR_KUCHEN, keyKuchen, dbpfad, admin );
      dlg.showDialog( this );
    }
  }

  private void anzeigenGaeste()
  {
    if ( !isAktiv[BASAR_GAESTE] )
    {
      statusBar.setMessage( "Verwalten Gste" );
      KuchenBasarTable dlg = new KuchenBasarTable( BASAR_GAESTE, keyGaeste, dbpfad, admin );
      dlg.showDialog( this );
    }
  }

  private void anzeigenBestellungen()
  {
    if ( !isAktiv[BASAR_BESTELLUNGEN] )
    {
      statusBar.setMessage( "Verwalten Bestellungen" );
      KuchenBasarTable dlg = new KuchenBasarTable( BASAR_BESTELLUNGEN, keyBestellungen, dbpfad, admin );
      dlg.showDialog( this );
    }
  }

  private void info()
  {
    statusBar.setMessage( "Info" );
    meldung( "KuchenBasar Verwaltungsprogramm    Version: " + serialVersionUID + "\n\n" +
        "Projektarbeit von  Bernd Schubert, Alfatraining Rostock\n\n" +
        "aus dem Java-Kurs bei Herrn Knig,  12.01.2015 - 06.03.2015\n\n" );
  }

  private void kurz()
  {
    statusBar.setMessage( "Kurzbeschreibung" );
    Hilfe dlg = new Hilfe( this, dbpfad );
    dlg.showDialog( this );
  }

  private void admin()
  {
    BenutzerForm dlg = new BenutzerForm();
    int erlaubnis = dlg.showDialog( this );
    admin = ( erlaubnis > 0 );
    miAdmin.setSelected( admin );
  }

  private void meldung( String satz )
  {
    JOptionPane.showMessageDialog(
        this,
        satz,
        "Kuchenbasar",
        JOptionPane.ERROR_MESSAGE
        );
  }

  private boolean testZugriffSQLite()
  {
    boolean dbOK = false;

    try
    {
      dbOK = KuchenDB.getOK();
    }
    catch ( Exception ex )
    {
      dbOK = false;
    }
    if ( !dbOK )
      meldung( "Die SQLite-Datenbank " + dbpfad + database + " kann nicht gefunden werden " );
 
    return dbOK;
  }

  private void openSQLiteDatabase()
  {
    String classForName = "org.sqlite.JDBC";
    String connectionString = "jdbc:sqlite:" + dbpfad + database;

    dbEnable( DBConnection.connectToDatabase( classForName, connectionString, "", "" )
        && testZugriffSQLite() );
  }

  private void dbEnable( boolean enable )
  {
    menuVerwaltung.setEnabled( enable );

    if ( enable )
    {
      statusBar.setMessage( "Datenbank Kuchenbasar ist aktiv!" );
    }
    else
      statusBar.setMessage( "Datenbank kann nicht geffnet werden!" );
  }

  private boolean frage( String frage )
  {
    Object[] options =
    { "Ja", "Nein" };

    int retValue = JOptionPane.showOptionDialog(
        this,
        frage,
        "Kuchenbasar",
        JOptionPane.YES_NO_OPTION,
        JOptionPane.QUESTION_MESSAGE,
        null,
        options,
        options[1]
        );

    if ( retValue == JOptionPane.NO_OPTION || retValue == JOptionPane.CLOSED_OPTION )
      return false;

    return true;
  }

  private void loadSettings()
  {
    Reader reader = null;
    Properties prop = null;

    try
    {
      reader = new FileReader( properties );
      prop = new Properties();
      prop.load( reader );

      dbpfad = prop.getProperty( "dbpfad", userhome );
      keyKuchen = Integer.parseInt( prop.getProperty( "keyKuchen", "1" ) );
      keyGaeste = Integer.parseInt( prop.getProperty( "keyGaeste", "1" ) );
      keyBestellungen = Integer.parseInt( prop.getProperty( "keyBestellungen", "1" ) );
    }
    catch ( Exception ex )
    {
      //info( "Fehler beim Laden der Savings: " + ex.getMessage() );
    }

    try
    {
      if ( reader != null )
        reader.close();
    }
    catch ( Exception ex )
    {
      meldung( ex.getMessage() );
    }
  }

  private void saveSettings()
  {
    FileWriter fw = null;
    Properties prop = new Properties();

    prop.setProperty( "dbpfad", dbpfad );
    prop.setProperty( "keyKuchen", "1" );
    prop.setProperty( "keyGaeste", "1" );
    prop.setProperty( "keyBestellungen", "1" );

    try
    {
      fw = new FileWriter( properties );
      prop.store( fw, "Kuchenbasar" );
    }
    catch ( Exception ex )
    {
      meldung( "Fehler beim Schreiben der Properites: " + ex.getMessage() );
    }

    if ( fw != null )
      try
      {
        fw.close();
      }
      catch ( Exception ex )
      {
        meldung( ex.getMessage() );
      }
  }

  @Override
  public void windowClosing( WindowEvent e )
  {
    for ( boolean aktiv : isAktiv )
    {
      if ( aktiv )
      {
        meldung( "Bitte erst alle Verwaltungsfenster schlieen!" );
        return;
      }
    }

    if ( frage( "Kuchenbasar schlieen?" ) )
    {
      DBConnection.closeConnection();

      saveSettings();

      this.dispose();
    }
  }

  @Override
  public void windowOpened( WindowEvent e )
  {
  }

  @Override
  public void windowClosed( WindowEvent e )
  {
  }

  @Override
  public void windowIconified( WindowEvent e )
  {
  }

  @Override
  public void windowDeiconified( WindowEvent e )
  {
  }

  @Override
  public void windowActivated( WindowEvent e )
  {
  }

  @Override
  public void windowDeactivated( WindowEvent e )
  {
  }

  @Override
  public void actionPerformed( ActionEvent e )
  {
    JMenuItem mi;
    if ( e.getSource() instanceof JMenuItem )
    {
      mi = (JMenuItem)e.getSource();
      if ( mi.equals( miBeenden ) )
        this.windowClosing( new WindowEvent( this, WindowEvent.WINDOW_CLOSING ) );
      if ( mi.equals( miKuchenBasar[BASAR_KUCHEN] ) )
        anzeigenKuchen();
      if ( mi.equals( miKuchenBasar[BASAR_GAESTE] ) )
        anzeigenGaeste();
      if ( mi.equals( miKuchenBasar[BASAR_BESTELLUNGEN] ) )
        anzeigenBestellungen();
      if ( mi.equals( miInfo ) )
        info();
      if ( mi.equals( miKurz ) )
        kurz();
      if ( mi.equals( miAdmin ) )
        admin();
    }
  }
}
