package kuchenBasar;

import java.sql.*;
import java.util.ArrayList;

import javax.swing.JOptionPane;

import util.ListItem;

public class SortenDB
{
  private SortenDB()
  {
  }

  /**
   * 
   * @param ID
   * @return Backwarensorte (Vollname)
   */
  public static Sorte getSorte( int ID )
  {
    String sql = " SELECT ID, backwarensorte ";
          sql += " FROM sorten ";
          sql += " WHERE ID = ? ";

    PreparedStatement prepStatement = DBConnection.prepareStatement( sql );
    ResultSet result = null;
    Sorte retValue = new Sorte();

    try
    {
      prepStatement.setInt( 1, ID );

      result = prepStatement.executeQuery();

      if ( result != null )
      {
        result.next();
        retValue.setID( result.getInt( 1 ) );
        retValue.setBackwarenSorte( result.getString( 2 ) );
      }
    }

    catch ( Exception ex )
    {
      JOptionPane.showMessageDialog(
          null,
          "Fehler beim ID-Zugriff auf die Tabelle Sorten: " + ex.getMessage(),
          "db-Fehler",
          JOptionPane.ERROR_MESSAGE
          );
    }

    return retValue;
  }

  /**
   * 
   * @return
   */
  public static ArrayList<ListItem> getSortenListe()
  {
    String sql = " SELECT ID, backwarensorte ";
          sql += " FROM sorten ";
          sql += " ORDER BY 1 ";

    PreparedStatement prepStatement = DBConnection.prepareStatement( sql );
    ResultSet result = null;
    ArrayList<ListItem> retValue = new ArrayList<ListItem>();

    try
    {
      result = prepStatement.executeQuery();

      while ( result.next() )
      {
        ListItem listitem = new ListItem( result.getInt( 1 ), result.getString( 2 ) );
        retValue.add( listitem );
      }
    }

    catch ( Exception ex )
    {
      JOptionPane.showMessageDialog(
          null,
          "Fehler beim Liste-Zugriff auf die Tabelle Sorten: " + ex.getMessage(),
          "db-Fehler",
          JOptionPane.ERROR_MESSAGE
          );
    }

    return retValue;
  }
}